/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.agent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.host.agent.action.Stdin;
import com.huawei.ism.drm.host.util.KvJson;
import com.huawei.ism.drm.system.cfgdata.DrvSshPara;
import com.huawei.ism.drm.system.cfgdata.SshResponse;
import com.huawei.ism.drm.system.cfgdata.SshSession;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class RemoteShellAction {
    private static final Log LOGGER = LogFactory.getInstance(RemoteShellAction.class);
    private static final ThreadLocal<SshSession> CONTEXT = new ThreadLocal();
    private static final String KMC_PRE = "AAAAAg";
    private final NeMgrProtocolExtend extend;

    public RemoteShellAction(NeMgrProtocolExtend extend) {
        this.extend = extend;
    }

    public static Map.Entry<String, List<String>> build(String command, Object[] arguments) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(command);
        ArrayList<String> inputs = new ArrayList<String>();
        for (Object argument : arguments) {
            if (argument instanceof Stdin) {
                Stdin stdin = (Stdin)argument;
                String cite = stdin.getCite();
                if (cite != null) {
                    list.add("'@{" + cite + "}'");
                    inputs.add(cite + "=" + stdin.getText());
                    continue;
                }
                inputs.add(stdin.getText());
                continue;
            }
            if (argument != null) {
                String value = argument.toString();
                list.add("'" + value.replaceAll("'", "'\"'\"'") + "'");
                continue;
            }
            list.add("''");
        }
        return new AbstractMap.SimpleEntry<String, List<String>>(String.join((CharSequence)" ", list), inputs);
    }

    public static List<Object> buildAgentlessAuthStr(Map<String, String> params) {
        String asmPwd;
        String asmUserName;
        String pwd;
        String dbUserName = params.get("USERNAME");
        ArrayList<Object> headerList = new ArrayList<Object>();
        if (!VerifyUtil.isEmpty((String)dbUserName)) {
            headerList.add("--db_user");
            headerList.add(dbUserName);
        }
        if (!VerifyUtil.isEmpty((String)(pwd = params.get("PASSWD")))) {
            if (pwd.contains(KMC_PRE)) {
                pwd = WccEncryptor.decrypt((String)pwd);
            }
            headerList.add(Stdin.use("db_user_passwd", pwd));
        }
        if (!VerifyUtil.isEmpty((String)(asmUserName = params.get("ASM_USERNAME")))) {
            headerList.add("--asm_user");
            headerList.add(asmUserName);
        }
        if (!VerifyUtil.isEmpty((String)(asmPwd = params.get("ASM_PASSWD")))) {
            if (asmPwd.contains(KMC_PRE)) {
                asmPwd = WccEncryptor.decrypt((String)asmPwd);
            }
            headerList.add(Stdin.use("asm_user_passwd", asmPwd));
        }
        return headerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Function<SshSession, T> function) {
        T t;
        block9: {
            SshSession currentSession;
            SshSession connectedSession = CONTEXT.get();
            if (connectedSession == null) {
                CONTEXT.remove();
                currentSession = this.createSshSession();
                CONTEXT.set(currentSession);
            } else {
                currentSession = connectedSession;
            }
            try {
                t = function.apply(currentSession);
                if (connectedSession != null) break block9;
                CONTEXT.remove();
            }
            catch (Throwable throwable) {
                if (connectedSession == null) {
                    CONTEXT.remove();
                    try {
                        currentSession.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Close connect failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    }
                }
                throw throwable;
            }
            try {
                currentSession.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close connect failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        return t;
    }

    public SshResponse execute(String command, Object ... arguments) {
        Map.Entry<String, List<String>> entry = RemoteShellAction.build(command, arguments);
        return this.execute(entry.getKey(), entry.getValue().toArray(new String[0]));
    }

    public SshResponse execute(String command, List<String> params) {
        Map.Entry<String, List<String>> entry = RemoteShellAction.build(command, params.toArray(new String[0]));
        return this.execute(entry.getKey(), entry.getValue().toArray(new String[0]));
    }

    public SshResponse execute(String command, String[] inputs) {
        return this.execute(session -> this.execute((SshSession)session, command, inputs));
    }

    private SshResponse execute(SshSession session, String command, String[] inputs) {
        SshResponse response = session.execute(command, inputs);
        if (response.getStatus() == 0) {
            this.encodeAsJson(() -> ((SshResponse)response).getStdOut(), arg_0 -> ((SshResponse)response).setStdOut(arg_0));
        } else {
            LOGGER.error((Object)"Execute failed.");
            this.encodeAsJson(() -> ((SshResponse)response).getStdErr(), arg_0 -> ((SshResponse)response).setStdErr(arg_0));
        }
        return response;
    }

    private void encodeAsJson(Supplier<String> getter, Consumer<String> setter) {
        String source = getter.get();
        String result = new KvJson(source).resolveString();
        setter.accept(result);
    }

    private SshSession createSshSession() {
        SshSession session = new SshSession();
        String hostKey = this.extend.getExtendParams().getOrDefault("hostKey", "");
        hostKey = hostKey.startsWith(KMC_PRE) ? WccEncryptor.decrypt((String)hostKey) : hostKey;
        DrvSshPara para = new DrvSshPara(this.extend.getNetworkIpAddress(), this.extend.getNetworkUserName(), this.extend.getNetworkPassword(), hostKey);
        if (!session.init(para)) {
            LOGGER.error((Object)"Failed to login host server: %s", new Object[]{String.valueOf(para.getIp())});
            try {
                session.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close connect failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            throw new LegoCheckedException(1073948972L);
        }
        return session;
    }
}

