/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.agent.service.impl;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.sdk.model.ClusterInfo;
import com.huawei.ism.drm.app.sdk.model.HostAgentInfo;
import com.huawei.ism.drm.app.sdk.model.SnmpAuthInfo;
import com.huawei.ism.drm.host.agent.action.ClusterAction;
import com.huawei.ism.drm.host.agent.action.HostAction;
import com.huawei.ism.drm.host.agent.action.SnmpAction;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class HostRetrieveProxyImpl
extends BaseService
implements IHostRetrieveProxy {
    private static final Log LOGGER = LogFactory.getInstance(HostRetrieveProxyImpl.class);

    public Host queryHostBaseInfo(NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)("queryHostBaseInfo into, ip: " + extend.getNetworkIpAddress()), 90160758786988L);
        String macAddress = (String)extend.getExtendParams().get("mac_address") + "_info";
        HostAction action = new HostAction(extend, macAddress);
        Host host = action.queryHostInfo();
        return host;
    }

    public Host queryHostDetail(NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)("queryHostDetail into, ip: " + extend.getNetworkIpAddress()), 90160758786988L);
        String macAddress = (String)extend.getExtendParams().get("mac_address");
        HostAction action = new HostAction(extend, macAddress);
        Host host = action.queryHostInfo();
        if (null != host) {
            host.setIpAddress(extend.getNetworkIpAddress());
            host.setManagedIpAddress(extend.getNetworkIpAddress());
            host.setLinkIp(extend.getNetworkIpAddress());
            host.setHostType(Integer.valueOf(1));
            try {
                String ip;
                HostAgentInfo agentInfo = action.queryHostAgentInfo();
                if (null != agentInfo) {
                    host.setAgentVersion(agentInfo.getVersion() + "|" + agentInfo.getBuildNum());
                }
                if (null != (ip = action.queryHostBlockClientIp())) {
                    extend.getExtendParams().put("fsb_block_client_ip", ip);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Get agent info error. " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return host;
    }

    public void testHostConnection(NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)("testHostConnection into, ip: " + extend.getNetworkIpAddress()), 90160758786988L);
        String macAddress = (String)extend.getExtendParams().get("mac_address");
        HostAction action = new HostAction(extend, macAddress);
        action.queryHostInfo();
    }

    public List<Initiator> queryHostInitiators(NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)("queryHostInitiators into, ip: " + extend.getNetworkIpAddress()), 90160758786988L);
        String macAddress = (String)extend.getExtendParams().get("mac_address");
        HostAction action = new HostAction(extend, macAddress);
        List<Initiator> initiators = action.queryInitiators();
        LOGGER.debug((Object)("initiator count:" + initiators.size()), 90160758786988L);
        return initiators;
    }

    public void scanDisk(NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)("scanDisk into, ip: " + extend.getNetworkIpAddress()), 90160758786988L);
        String macAddress = (String)extend.getExtendParams().get("mac_address");
        HostAction action = new HostAction(extend, macAddress);
        action.scanDisk();
    }

    public Set<ProtectObjectStorageInfo> queryDiskInfo(NeMgrProtocolExtend extend, int osType) {
        return null;
    }

    public List<Disk> queryHostDiskInfo(NeMgrProtocolExtend extend) {
        List<Disk> disks;
        LOGGER.debug((Object)("queryHostDiskInfo into, ip: " + extend.getNetworkIpAddress()), 90160758786988L);
        try {
            String macAddress = (String)extend.getExtendParams().get("mac_address");
            HostAction action = new HostAction(extend, macAddress);
            disks = action.queryDisks();
        }
        catch (LegoCheckedException ex) {
            disks = null;
            LOGGER.error((Object)"Query disk error.", (Throwable)ex, 90160758786989L);
        }
        return disks;
    }

    public List<String> queryThirdPartScriptInfo(NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)("queryThirdPartScriptInfo into, ip: " + extend.getNetworkIpAddress()), 90160758786988L);
        String macAddress = (String)extend.getExtendParams().get("mac_address");
        HostAction action = new HostAction(extend, macAddress);
        List<String> thirdPartScriptFiles = action.queryThirdPartScriptFiles();
        LOGGER.debug((Object)("thirdPartScriptFiles count:" + thirdPartScriptFiles), 90160758786988L);
        return thirdPartScriptFiles;
    }

    public List<String> executeThirdPartScript(NeMgrProtocolExtend extend, String scriptName, String scriptParams) {
        ArrayList<String> resultInfos;
        block3: {
            LOGGER.debug((Object)("executeThirdPartScript into, ip: " + extend.getNetworkIpAddress() + ", scriptName: " + scriptName), 90160758786988L);
            resultInfos = new ArrayList<String>();
            try {
                String macAddress = (String)extend.getExtendParams().get("mac_address");
                HostAction action = new HostAction(extend, macAddress);
                action.execThirdPartScript(scriptName, scriptParams);
            }
            catch (LegoCheckedException ex) {
                LOGGER.error((Object)("Execute third part script failed in " + extend.getNetworkIpAddress() + "and scriptName is " + scriptName), (Throwable)ex, 90160758786989L);
                long errorCode = ex.getErrorCode();
                if (134378561L == errorCode || 1073948967L == errorCode) {
                    resultInfos.add("lego.err." + errorCode);
                }
                if (134378563L != errorCode && (0L == errorCode || 134378562L == errorCode)) break block3;
                resultInfos.add("lego.err.1073948724");
            }
        }
        return resultInfos;
    }

    public List<String> executeThirdPartScript(NeMgrProtocolExtend extend, String url, Map<String, String> scriptNames, Map<String, String> scriptParams) {
        ArrayList<String> resultInfos;
        block3: {
            LOGGER.debug((Object)("executeThirdPartScript into, ip: " + extend.getNetworkIpAddress() + ", scriptName: " + scriptNames.values()), 90160758786988L);
            resultInfos = new ArrayList<String>();
            try {
                String macAddress = (String)extend.getExtendParams().get("mac_address");
                HostAction action = new HostAction(extend, macAddress);
                action.execThirdPartScript(url, scriptNames, scriptParams);
            }
            catch (LegoCheckedException ex) {
                LOGGER.error((Object)("Execute third part script failed in " + extend.getNetworkIpAddress() + "and scriptName is " + scriptNames.values()), (Throwable)ex, 90160758786989L);
                long errorCode = ex.getErrorCode();
                if (134378561L == errorCode) {
                    resultInfos.add("lego.err." + errorCode);
                }
                if (134378563L != errorCode && (0L == errorCode || 134378562L == errorCode)) break block3;
                resultInfos.add("lego.err.1073948724");
            }
        }
        return resultInfos;
    }

    public DrHost queryActiveNodeInHostGroup(DrHostGroup hostGroup, final String clusterType, final String resourceGroup) {
        if (null == hostGroup || VerifyUtil.isEmpty((Collection)hostGroup.getChildResources()) || VerifyUtil.isEmpty((String)clusterType) || VerifyUtil.isEmpty((String)resourceGroup)) {
            LOGGER.error((Object)"params is null! hostGroup:[%s].clusterType:[%s].resourceGroup:[%s]", new Object[]{hostGroup, clusterType, resourceGroup});
            throw new LegoCheckedException(1073947393L);
        }
        final INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        ArrayList<1> tasks = new ArrayList<1>();
        for (final DrResource childResource : hostGroup.getChildResources()) {
            tasks.add(new Callable<DrHost>(){

                @Override
                public DrHost call() throws Exception {
                    try {
                        NeMgrProtocolExtend neMgrProtocolExtend = DrHostUtil.getNeMgrProtocolExtend(neMgr, childResource.getDeviceSn());
                        ClusterAction action = new ClusterAction(neMgrProtocolExtend, childResource.getDeviceSn());
                        LOGGER.debug((Object)("begin query acticve in host ip: " + childResource.getIpAddress() + ", resourceGroup: " + resourceGroup), 90160758786988L);
                        if (action.isActiveNode(clusterType, resourceGroup)) {
                            LOGGER.debug((Object)("query acticve host success, ip: " + childResource.getIpAddress() + ", resourceGroup: " + resourceGroup), 90160758786988L);
                            return (DrHost)childResource;
                        }
                        return null;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("query acticve host node error, ip: " + childResource.getIpAddress() + ", resourceGroup: " + resourceGroup + ", errorMessage: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                        return null;
                    }
                }
            });
        }
        List res = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)600, (int)9);
        DrHost activeDrHost = res.stream().filter(host -> !VerifyUtil.isEmpty((Object)host)).findFirst().orElse(null);
        if (null == activeDrHost) {
            LOGGER.error((Object)("query acticve host node error, hostGroup name: " + hostGroup.getName() + ", resourceGroup:" + resourceGroup), 90160758786989L);
            throw new LegoCheckedException(1073948743L);
        }
        return activeDrHost;
    }

    public void registerTrap(NeMgrProtocolExtend extend, Integer snmpType, String trapIp, Integer trapPort) {
        LOGGER.debug((Object)"register trap.", 90160758786988L);
        SnmpAction action = new SnmpAction(extend, "");
        action.registerTrap(snmpType, trapIp, trapPort);
    }

    public void deleteTrap(NeMgrProtocolExtend extend, Integer snmpType, String trapIp, Integer trapPort) {
        LOGGER.debug((Object)"delete trap.", 90160758786988L);
        SnmpAction action = new SnmpAction(extend, null);
        action.deleteTrap(snmpType, trapIp, trapPort);
    }

    public void checkSnmpParam(NeMgrProtocolExtend extend, SnmpAuthInfo snmpAuthInfo) {
        LOGGER.debug((Object)"check snmp param.", 90160758786988L);
        String macAddress = (String)extend.getExtendParams().get("mac_address");
        SnmpAction action = new SnmpAction(extend, macAddress);
        action.validSnmpAuthInfo(snmpAuthInfo);
    }

    public ClusterInfo queryClusterInfos(NeMgrProtocolExtend extend, ProtectObject po) {
        LOGGER.debug((Object)("start query Cluster Info in " + extend.getNetworkIpAddress()), 90160758786988L);
        return DrHostUtil.queryClusterInfo(po, extend);
    }
}

