/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.HostAction;
import com.huawei.ism.drm.host.device.process.AbstractDiskProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;

public class AIXDiskProcessor
extends AbstractDiskProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AIXDiskProcessor.class);

    @Override
    protected void updateDeviceName(RecoveryProcessorContext context, DrHost drHost, List<HostDeviceStorageInfo> hostDeviceStorageInfos, Map<String, List<Disk>> diskMap, HostAction hostAction, boolean isClean) {
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            if (!DrHostDeviceUtil.isNeedUpdateDeviceName(hostDeviceStorageInfo.getDeviceName(), hostDeviceStorageInfo.getStorageSubType(), hostDeviceStorageInfo.getUdevRules())) continue;
            List<Disk> disks = DrHostDeviceUtil.getDiskByStorageInfo(hostDeviceStorageInfo, diskMap);
            if (VerifyUtil.isEmpty(disks)) {
                String key = hostDeviceStorageInfo.getDeviceId() + "_" + hostDeviceStorageInfo.getLunId() + "_" + hostDeviceStorageInfo.getSnapshotId();
                LOGGER.error((Object)("Cannot find the disk(key:" + key + ", wwn:" + hostDeviceStorageInfo.getWwn() + ")"), 90160758786989L);
                continue;
            }
            hostDeviceStorageInfo.setDeviceName(disks.get(0).getDiskName());
        }
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        Integer osType = NumberUtil.parseInteger((Object)drHost.getOsType());
        return DrmAppEnumDefine.OS_TYPE_E.AIX == DrmAppEnumDefine.OS_TYPE_E.getType((int)osType);
    }
}

