/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.device.process.IDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ActiveDeActiveLvmProcessor
implements IDeviceProcessor {
    private static final Log LOGGER = LogFactory.getInstance(ActiveDeActiveLvmProcessor.class);
    private static final int PROCESS_ORDER = 140;
    private static final int CLEAN_ORDER = 150;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        Integer recoverType = (Integer)context.getAttribute("HOST_RECOVERY_TYPE");
        String vgActiveMode = (String)context.getAttribute("VGACTIVEMODE");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        List<HostDeviceStorageInfo> lvmStorageInfos = this.buildLvmStorageInfos(hostDeviceStorageInfos);
        this.filterTarStorage(lvmStorageInfos, context, drHost);
        if (VerifyUtil.isEmpty(lvmStorageInfos)) {
            return true;
        }
        try {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            deviceAction.activateVG(lvmStorageInfos, vgActiveMode, recoverType);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByVgName(lvmStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(ex, "vgName", storageInfoMap);
            return false;
        }
        return true;
    }

    @Override
    public boolean clean(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        List<HostDeviceStorageInfo> lvmStorageInfos = this.buildLvmStorageInfos(hostDeviceStorageInfos);
        this.filterTarStorage(lvmStorageInfos, context, drHost);
        if (VerifyUtil.isEmpty(lvmStorageInfos)) {
            return true;
        }
        try {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            deviceAction.deActivateVG(lvmStorageInfos);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByVgName(lvmStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(ex, "vgName", storageInfoMap);
            return false;
        }
        return true;
    }

    private void filterTarStorage(List<HostDeviceStorageInfo> lvmStorageInfos, RecoveryProcessorContext context, DrHost drHost) {
        if (VerifyUtil.isEmpty(lvmStorageInfos) || VerifyUtil.isEmpty((Object)context) || VerifyUtil.isEmpty((Object)drHost)) {
            LOGGER.debug((Object)"error param");
            return;
        }
        DrmAppEnumDefine.CLUSTER_TYPE_E clusterType = (DrmAppEnumDefine.CLUSTER_TYPE_E)context.getAttribute("CLUSTER_TYPE");
        if (!DrmAppEnumDefine.CLUSTER_TYPE_E.isMultipath((DrmAppEnumDefine.CLUSTER_TYPE_E)clusterType)) {
            return;
        }
        Iterator<HostDeviceStorageInfo> iterator = lvmStorageInfos.iterator();
        while (iterator.hasNext()) {
            HostDeviceStorageInfo hostDeviceStorageInfo = iterator.next();
            if (hostDeviceStorageInfo.getHostSN().equals(drHost.getDeviceSn())) continue;
            iterator.remove();
        }
    }

    private List<HostDeviceStorageInfo> buildLvmStorageInfos(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        ArrayList<HostDeviceStorageInfo> lvmStorageInfos = new ArrayList<HostDeviceStorageInfo>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            int storageSubType = hostDeviceStorageInfo.getStorageSubType();
            if (storageSubType != 4 && storageSubType != 1 && storageSubType != 3 && storageSubType != 2) continue;
            if (hostDeviceStorageInfo.getErrorCode() != 0L) {
                LOGGER.warn((Object)("The storage info(wwn: " + hostDeviceStorageInfo.getWwn() + ", deviceName" + hostDeviceStorageInfo.getDeviceName() + ") has error, errorCode: " + hostDeviceStorageInfo.getErrorCode()), 90160758786989L);
                continue;
            }
            lvmStorageInfos.add(hostDeviceStorageInfo);
        }
        return lvmStorageInfos;
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        DrmAppEnumDefine.CLUSTER_TYPE_E clusterType = (DrmAppEnumDefine.CLUSTER_TYPE_E)context.getAttribute("CLUSTER_TYPE");
        Integer iOsType = NumberUtil.parseInteger((Object)drHost.getOsType());
        DrmAppEnumDefine.OS_TYPE_E osType = DrmAppEnumDefine.OS_TYPE_E.getType((int)iOsType);
        if (DrmAppEnumDefine.OS_TYPE_E.WINDOWS == osType || DrmAppEnumDefine.CLUSTER_TYPE_E.isAPCluster((DrmAppEnumDefine.CLUSTER_TYPE_E)clusterType)) {
            return false;
        }
        return !VerifyUtil.isEmpty(this.buildLvmStorageInfos(hostDeviceStorageInfos));
    }

    @Override
    public int getProcessOrder() {
        return 140;
    }

    @Override
    public int getCleanOrder() {
        return 150;
    }
}

