/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.HostAction;
import com.huawei.ism.drm.host.device.process.AbstractDiskProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;

public class HPUXDiskProcessor
extends AbstractDiskProcessor {
    private static final Log LOGGER = LogFactory.getInstance(HPUXDiskProcessor.class);

    @Override
    protected void updateDeviceName(RecoveryProcessorContext context, DrHost drHost, List<HostDeviceStorageInfo> hostDeviceStorageInfos, Map<String, List<Disk>> diskMap, HostAction hostAction, boolean isClean) {
        block0: for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            if (!DrHostDeviceUtil.isNeedUpdateDeviceName(hostDeviceStorageInfo.getDeviceName(), hostDeviceStorageInfo.getStorageSubType(), hostDeviceStorageInfo.getUdevRules())) continue;
            List<Disk> disks = DrHostDeviceUtil.getDiskByStorageInfo(hostDeviceStorageInfo, diskMap);
            if (null == disks) {
                String key = hostDeviceStorageInfo.getDeviceId() + "_" + hostDeviceStorageInfo.getLunId() + "_" + hostDeviceStorageInfo.getSnapshotId();
                LOGGER.error((Object)("Cannot find the disk(key:" + key + ", wwn:" + hostDeviceStorageInfo.getWwn() + ")"), 90160758786989L);
                continue;
            }
            String deviceName = hostDeviceStorageInfo.getDeviceName();
            for (Disk disk : disks) {
                String diskName = disk.getDiskName();
                if (deviceName.startsWith("/dev/dsk") && diskName.startsWith("/dev/dsk")) {
                    hostDeviceStorageInfo.setDeviceName(diskName);
                    continue block0;
                }
                if (!deviceName.startsWith("/dev/disk") || !diskName.startsWith("/dev/disk")) continue;
                hostDeviceStorageInfo.setDeviceName(diskName);
                continue block0;
            }
        }
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        Integer osType = NumberUtil.parseInteger((Object)drHost.getOsType());
        return DrmAppEnumDefine.OS_TYPE_E.HPUX == DrmAppEnumDefine.OS_TYPE_E.getType((int)osType);
    }
}

