/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.processer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.discovery.proxy.HostApplicationDiscoverProxy;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;

public class HostAppProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(HostAppProcessor.class);

    public void clean(AbstractContext arg0) {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void postProcess(AbstractContext arg0) {
    }

    public boolean process(AbstractContext context) {
        Host host = (Host)context.getAttribute("DRMHOST");
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        if (null == host || null == extend) {
            return false;
        }
        Host existHost = DrHostUtil.getExistHost(extend);
        host = this.getHostAppInfo(host, existHost, extend);
        context.setAttribute("DRMHOST", (Object)host);
        return true;
    }

    private Host getHostAppInfo(Host host, Host existHost, NeMgrProtocolExtend extend) {
        LOGGER.info((Object)"begin to get host app info.", 90160758786989L);
        if (1 != host.getHostStatus()) {
            if (null == existHost) {
                LOGGER.error((Object)("the host(" + extend.getNetworkIpAddress() + ")'status is not valid."), 90160758786989L);
                throw new LegoCheckedException(1073947394L);
            }
            existHost.setHostStatus(host.getHostStatus());
            existHost.setStatus(host.getHostStatus());
            DrHostUtil.generateOfflineAlarm(host);
            return existHost;
        }
        if (null != existHost) {
            DrHostUtil.generateOfflineRestoreAlarm(existHost);
        }
        extend.getExtendParams().put("mac_address", host.getUuid());
        Map<Integer, List<ManagedObject>> resultInfo = HostApplicationDiscoverProxy.getInstance().discoverApplication(extend);
        LOGGER.info((Object)("get host app info return,size:" + resultInfo.size()), 90160758786989L);
        this.updateHostInfo(host, existHost);
        DrHostUtil.updateAppInfo(host, resultInfo);
        return host;
    }

    private void updateHostInfo(Host host, Host existHost) {
        host.setHostSN(host.getUuid());
        host.setSn(host.getUuid());
        host.setHostStatus(Integer.valueOf(1));
        host.setStatus(Integer.valueOf(1));
        host.setName(host.getHostName());
        host.setIsTopMo(Boolean.valueOf(true));
        if (null != existHost) {
            String location = existHost.getLocation();
            if (!VerifyUtil.isEmpty((String)location)) {
                host.setLocation(location);
            }
            host.setHostName(existHost.getHostName());
            host.setName(existHost.getName());
        }
    }
}

