/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.protection.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class BaseFreezeAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(BaseFreezeAction.class);
    private static final int MAX_HOST = 8;
    private static final int RADIX = 60;

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BaseFreezeAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
        if (this.checkDatabaseIsStart(context, protectGroup)) {
            return this.freeze(context, protectGroup);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean freeze(ActionContext context, ProtectGroup protectGroup) {
        Set pos = (Set)context.getObject("PO_ENTITY");
        Set freezePo = this.combineProtectObjectByType(pos, protectGroup);
        context.addObject("FREEZE_PO_ENTITY", (Object)freezePo);
        HashSet<ProtectObject> successFreezePo = new HashSet<ProtectObject>();
        int flag = 0;
        try {
            int size = freezePo.size();
            int count = 0;
            for (ProtectObject po : freezePo) {
                logger.info((Object)("begin to freeze protected object,pgId:" + protectGroup.getUuid()), 90160758786988L);
                ProtectObject poClone = (ProtectObject)po.clone();
                int time = (size - count) * 60;
                ++count;
                poClone.getProps().put("FreezeTime", String.valueOf(time));
                ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).freeze(poClone);
                successFreezePo.add(po);
                logger.info((Object)("end to freeze protected object,pgId:" + protectGroup.getUuid()), 90160758786988L);
            }
            flag = 1;
            boolean bl = true;
            return bl;
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            logger.error((Object)("BaseFreezeAction executed failed,pgId:" + protectGroup.getUuid()), (Throwable)e, errorCode);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("BaseFreezeAction executed failed,pgId:" + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 1073948171L);
            this.setDetail("lego.err.1073948171");
            boolean bl = false;
            return bl;
        }
        finally {
            this.processPoAfterFreeze(context, successFreezePo, flag);
        }
    }

    private void processPoAfterFreeze(ActionContext context, Set<ProtectObject> successFreezePo, int flag) {
        if (0 == flag) {
            for (ProtectObject myPo : successFreezePo) {
                try {
                    ApplicationAdapterProxy.getInstance().getAppManager(myPo.getPoType()).thaw(myPo);
                }
                catch (LegoCheckedException e) {
                    logger.error((Object)("Fail to thaw the freezen protect objects poname:" + myPo.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                }
                catch (Exception e) {
                    logger.error((Object)("Fail to thaw the freezen protect objects poname:" + myPo.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                }
            }
            context.addObject("EXECUTE_FREEZE_FLAG_KEY", (Object)0);
        } else {
            context.addObject("EXECUTE_FREEZE_FLAG_KEY", (Object)1);
        }
    }

    protected boolean checkDatabaseIsStart(ActionContext context, ProtectGroup protectGroup) {
        Set pos = (Set)context.getObject("PO_ENTITY");
        Set freezePo = this.combineProtectObjectByType(pos, protectGroup);
        if (VerifyUtil.isEmpty((Collection)freezePo)) {
            this.setDetail("lego.err.1073948458");
            logger.error((Object)("Pos is null,pgId:" + protectGroup.getUuid()), 1073948458L);
            return false;
        }
        try {
            for (ProtectObject po : freezePo) {
                this.caclProtectObject(po, context);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Test connection with database failed,pgId:" + protectGroup.getUuid()), (Throwable)e, 90160758787071L);
            if (1073948956L == e.getErrorCode()) {
                this.setDetail(e.getErrorMessageKey());
                context.addObject("EXECUTE_FREEZE_EXCEPTION_KEY", (Object)e);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Test connection with database failed,pgId:" + protectGroup.getUuid()), 90160758787071L);
            return false;
        }
        return true;
    }

    protected void caclProtectObject(ProtectObject po, ActionContext context) {
        HashSet<DrResource> hostsOfTest = new HashSet<DrResource>(8);
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(po.getProviderSN());
        if (null == drResource) {
            logger.error((Object)("The device does not exist. DevSN:" + po.getProviderSN()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        if (drResource instanceof DrHostGroup) {
            hostsOfTest.addAll(drResource.getChildResources());
        } else if (drResource instanceof DrHost) {
            hostsOfTest.add(drResource);
        }
        for (DrResource res : hostsOfTest) {
            ProtectObject clonePo;
            try {
                clonePo = (ProtectObject)po.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)("Clone po failed!" + po.getProviderSN()), 1073948171L);
                throw new LegoCheckedException(1073948171L, (Throwable)e);
            }
            String hostSn = res.getDeviceSn();
            clonePo.setProviderSN(hostSn);
            clonePo.getProps().put("OPER_TYPE", String.valueOf(1));
            boolean result = this.isDBStartup(clonePo);
            if (!result) continue;
            context.addObject("EXECUTE_FREEZE_FLAG_KEY", (Object)1);
            return;
        }
        context.addObject("EXECUTE_FREEZE_FLAG_KEY", (Object)0);
        throw new LegoCheckedException(1073948956L);
    }

    protected boolean isDBStartup(ProtectObject po) {
        try {
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).testConnecting(po);
            logger.info((Object)("test connection of database succ, SN=" + po.getProviderSN()), 90160758787071L);
            return true;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("Test connection with database failed!poSn:" + po.getProviderSN()), (Throwable)le, 90160758787071L);
            return 1073948956L != le.getErrorCode();
        }
        catch (Exception e) {
            logger.error((Object)("Test connection of database.poSn:" + po.getProviderSN()), 90160758787071L);
            return true;
        }
    }
}

