/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.protection.action;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.drm.host.protection.action.MapReplicaTask;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MapReplicaSubAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(MapReplicaSubAction.class);

    public boolean doExecute(ActionContext context) {
        logger.debug((Object)"begin exec MapReplicaSubAction");
        try {
            return this.mappingProcess(context);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
        }
        catch (Exception e) {
            logger.error((Object)("MapReplicaSubAction failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.setDetail("lego.err.1073948676");
        }
        return false;
    }

    private boolean mappingProcess(ActionContext context) {
        boolean result;
        Boolean splitSuccess;
        String hostSn = (String)this.getParams().get("hostId");
        if (VerifyUtil.isEmpty((String)hostSn)) {
            logger.error((Object)"hostSn or scriptName is empty", 90160758786989L);
            this.setDetail("lego.err.1073947393");
            return false;
        }
        HashSet<String> hostOrGroupIds = new HashSet<String>();
        hostOrGroupIds.add(hostSn);
        Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIds);
        if (null == resourceVOs || null == resourceVOs.get(hostSn)) {
            logger.error((Object)"hostSn or scriptName is empty", 90160758786989L);
            this.setDetail("lego.err.1073948686");
            return false;
        }
        CloneConsistentGroup cloneCG = (CloneConsistentGroup)context.getObject("CloneCG");
        if (null == cloneCG) {
            logger.error((Object)"clone has no pair.");
            this.setDetail("lego.err.1073947393");
            return false;
        }
        HyperClonePair clonePair = (HyperClonePair)CommonUtil.getFirstElement((Collection)cloneCG.getPairs());
        if (null == clonePair) {
            logger.error((Object)"can not get clone pair in CloneCG.");
            this.setDetail("lego.err.1073947393");
            return false;
        }
        String deviceSn = clonePair.getDeviceSn();
        ResourceVO vo = resourceVOs.get(hostSn);
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        String lunGroupId = this.getLunGroupId(deviceSn, vo);
        if (VerifyUtil.isEmpty((String)lunGroupId)) {
            logger.error((Object)"can not get a lungroupid.");
            this.setDetail("lego.err.1073948676");
            return false;
        }
        Boolean bl = splitSuccess = null != context.getObject("CLONE_SPLIT_RESULT") ? (Boolean)context.getObject("CLONE_SPLIT_RESULT") : Boolean.FALSE;
        if (this.isNeedSnpshot(protectGroup) && !splitSuccess.booleanValue()) {
            result = this.createSnapshotMapping(protectGroup.getUuid(), lunGroupId, vo);
            if (!result) {
                this.setDetail("lego.err.1073948683");
            }
        } else {
            result = this.createCloneTgtLunMapping(cloneCG, deviceSn, lunGroupId, vo);
            if (!result) {
                this.setDetail("lego.err.1073948676");
            }
        }
        return result;
    }

    private String getLunGroupId(String deviceSn, ResourceVO vo) {
        IStorageLunBaseManager proxy = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(deviceSn);
        if (!HvsUnit.class.getName().equals(proxy.getStorageType())) {
            logger.error((Object)("dev(" + deviceSn + ") is not a Hvs."));
            return "";
        }
        if (vo instanceof HostVO) {
            return proxy.prepareMapping(deviceSn, (HostVO)vo);
        }
        return proxy.prepareMapping(deviceSn, (HostGroupVO)vo);
    }

    private boolean createCloneTgtLunMapping(CloneConsistentGroup cloneCG, String deviceSn, String lunGroupId, ResourceVO vo) {
        ArrayList<MapReplicaTask> tasks = new ArrayList<MapReplicaTask>();
        for (HyperClonePair pair : cloneCG.getPairs()) {
            MapReplicaTask task = new MapReplicaTask(deviceSn, pair.getTgtLunId(), null, lunGroupId, vo);
            tasks.add(task);
        }
        if (tasks.isEmpty()) {
            logger.debug((Object)"there is no target lun need to map.");
            return true;
        }
        List resultList = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)0, (int)20);
        if (null == resultList || resultList.size() != tasks.size()) {
            logger.error((Object)"map target lun has error.");
            return false;
        }
        if (resultList.contains(Boolean.FALSE)) {
            logger.error((Object)"map target lun has not success.");
            return false;
        }
        return true;
    }

    private boolean createSnapshotMapping(String pgId, String lunGroupId, ResourceVO vo) {
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pgId, false);
        String cloneSnapStr = (String)protectGroup.getProps().get("CLONE_SNAPSHOT");
        if (null == cloneSnapStr || cloneSnapStr.isEmpty()) {
            logger.debug((Object)"CLONE_SNAPSHOT is null.");
            return false;
        }
        JSONArray snaps = JSONArray.fromObject((Object)cloneSnapStr);
        ArrayList<MapReplicaTask> tasks = new ArrayList<MapReplicaTask>();
        for (int i = 0; i < snaps.size(); ++i) {
            JSONObject snap = snaps.getJSONObject(i);
            Snapshot snapshot = new Snapshot();
            snapshot.setSnapshotId(snap.getString("snapshotId"));
            snapshot.setSnapshotName(snap.getString("snapshotName"));
            MapReplicaTask task = new MapReplicaTask(snap.getString("devSn"), null, snapshot, lunGroupId, vo);
            tasks.add(task);
        }
        if (tasks.isEmpty()) {
            logger.debug((Object)"there is no snap need to map.");
            return true;
        }
        List resultList = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)0, (int)20);
        if (null == resultList || resultList.size() != tasks.size()) {
            logger.error((Object)"map snapshot has error.");
            return false;
        }
        if (resultList.contains(Boolean.FALSE)) {
            logger.error((Object)"map snapshot has not success.");
            return false;
        }
        return true;
    }
}

