/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.protection.action;

import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.concurrent.Callable;

public class UnmapReplicaTask
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getInstance(UnmapReplicaTask.class);
    private final String devSn;
    private final String lunId;
    private final Snapshot snapshot;
    private final ResourceVO vo;

    public UnmapReplicaTask(String devSn, String lunId, Snapshot snapshot, ResourceVO vo) {
        this.devSn = devSn;
        this.lunId = lunId;
        this.snapshot = snapshot;
        this.vo = vo;
    }

    @Override
    public Boolean call() {
        OperationResult operationResult = null != this.snapshot ? this.unmapSnapshot() : this.unmapLun();
        return operationResult.isSuccess();
    }

    private OperationResult unmapLun() {
        IStorageLunBaseManager proxy = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(this.devSn);
        OperationResult operationResult = this.vo instanceof HostVO ? proxy.removeLunMapping(this.devSn, this.lunId, (HostVO)this.vo) : proxy.removeLunMapping(this.devSn, this.lunId, (HostGroupVO)this.vo);
        if (null == operationResult) {
            throw new LegoCheckedException(1073947393L);
        }
        logger.debug((Object)("delete lun mapping(devSn:" + this.devSn + ";lunId:" + this.lunId + ") result is " + operationResult.isSuccess()));
        return operationResult;
    }

    private OperationResult unmapSnapshot() {
        IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.devSn);
        OperationResult operationResult = this.vo instanceof HostVO ? proxy.removeSnapshotFromHost(this.devSn, this.snapshot, (HostVO)this.vo) : proxy.removeSnapshotFromHostGroup(this.devSn, this.snapshot, (HostGroupVO)this.vo);
        logger.debug((Object)("delete snapshot mapping(devSn:" + this.devSn + ";snapshotId:" + this.snapshot.getSnapshotId() + ") result is " + operationResult.isSuccess()));
        return operationResult;
    }
}

