/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Iterator;
import java.util.Set;

public class DeleteLunMappingSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 858616458196377898L;
    private static Log logger = LogFactory.getInstance(DeleteLunMappingSubProcessor.class);
    private String deviceId;
    private String lunId;
    private String lunWWN;
    private String lunName;
    private String hostOrGroupId;
    private String hostOrGroupName;
    private transient ResourceVO resourceVO;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunWWN() {
        return this.lunWWN;
    }

    public void setLunWWN(String lunWWN) {
        this.lunWWN = lunWWN;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public ResourceVO getResourceVO() {
        return this.resourceVO;
    }

    public void setResourceVO(ResourceVO resourceVO) {
        this.resourceVO = resourceVO;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus() && !this.isChangedDisasterHost(context)) {
            logger.debug((Object)("execute DeleteLunMappingSubProcessor. lunName:" + this.getLunName()));
            this.updateProcessNameParams(new String[]{this.getLunName(), this.getHostOrGroupName()});
            this.updateProcessDetail("ism.drm.recovery.lun.already.mapped", new String[]{this.getLunName(), this.getHostOrGroupName()});
            return true;
        }
        this.setHostOrGroupId(this.getCurrentDisasterHost(context));
        OperationResult result = this.deleteMappingLun(context);
        if (null == result) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    protected OperationResult deleteMappingLun(RecoveryProcessorContext context) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(this.getHostOrGroupId());
        if (null == drResource) {
            this.updateProcessName("ism.drm.recovery.lun.mapping.failed");
            OperationResult operationResult = this.checkOperationObject(null);
            return operationResult;
        }
        this.updateProcessNameParams(new String[]{this.lunName, drResource.getName()});
        this.setHostOrGroupName(drResource.getName());
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        if (null == this.resourceVO) {
            logger.info((Object)("resourceVO is null," + this.getHostOrGroupId()));
            OperationResult operationResult = new OperationResult("Mapping", true, false, String.valueOf(1073948717L), new String[]{drResource.getName()});
            return operationResult;
        }
        return this.deleteMappingLunFromStorage(drResource, proxy);
    }

    private OperationResult deleteMappingLunFromStorage(DrResource drResource, IStorageLunBaseManager proxy) {
        if (drResource.getClass().getName().equals(DrHost.class.getName())) {
            return proxy.removeLunMapping(this.getDeviceId(), this.lunId, (HostVO)this.resourceVO);
        }
        return proxy.removeLunMapping(this.getDeviceId(), this.lunId, (HostGroupVO)this.resourceVO);
    }

    private OperationResult checkOperationObject(DrResource drResource) {
        String[] errorParams = null;
        String errorCode = null;
        if (null == drResource) {
            errorParams = new String[]{this.getHostOrGroupId()};
            errorCode = String.valueOf(1073948686L);
        }
        return new OperationResult("Mapping", true, false, errorCode, errorParams);
    }

    private boolean isChangedDisasterHost(RecoveryProcessorContext context) {
        String currentDisasterHost = this.getCurrentDisasterHost(context);
        return !this.getHostOrGroupId().equals(currentDisasterHost);
    }

    private String getCurrentDisasterHost(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            return this.getHostOrGroupId();
        }
        Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        String pgUUID = ((ProtectGroup)pgIter.next()).getUuid();
        RecoverySetting curDisasterHostSetting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)pgUUID, (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
        if (null == curDisasterHostSetting) {
            throw new LegoCheckedException(-1L, "The setting of disaster host does not exist.planId:" + recoveryPlan.getPlanId());
        }
        return curDisasterHostSetting.getValue();
    }
}

