/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.DeleteSnapshotMappingSubProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingSnapshotSubProcessor;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeleteSnapshotMappingProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6004746007005469566L;
    private static final Log LOGGER = LogFactory.getInstance(DeleteSnapshotMappingProcessor.class);
    private static final long LOG_CODE = -1L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessName(this.calcProcessName(context.getRecoveryPlan().getPlanType()));
        List<RecoveryProcessor> allMappingSnapshotProcessor = this.queryMappingSnapshotsProcessor(context);
        Set delMappingSnapshotSubProcs = this.getChildProc();
        if (null == delMappingSnapshotSubProcs || delMappingSnapshotSubProcs.isEmpty()) {
            this.updateSubProcessors(allMappingSnapshotProcessor, context.getRecoveryPlan());
            this.checkIfHasSubProcessor();
        } else {
            LOGGER.debug((Object)("getChildProc subprocs:" + delMappingSnapshotSubProcs.size()), -1L);
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        recoveryTemplate.process(context);
        int successCount = this.countSuccessResult(this.getChildProc());
        LOGGER.debug((Object)("countSuccessResult:" + successCount), -1L);
        this.scanDisk(context);
        this.calcProcessResultBySubProc();
        return true;
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private void scanDisk(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        if (null != protectGroup && 11 == protectGroup.getPoType()) {
            LOGGER.debug((Object)"no scan disk for Lun ProtectGroup.", -1L);
            return;
        }
        try {
            String hostOrGroupId = DrHostUtil.getCurrentDisasterHost(context.getRecoveryPlan(), this.getProcType());
            DrHostDeviceUtil.hostDiskScan(hostOrGroupId);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Fail to scanDisk" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected List<RecoveryProcessor> queryMappingSnapshotsProcessor(RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING;
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING;
        }
        return this.getRecoveryProcessors(context.getRecoveryPlan(), lastRunType, MappingSnapshotSubProcessor.class);
    }

    protected Set<RecoveryProcessor> createDelSnapshotMappingSubProcessors(List<RecoveryProcessor> allMappingSnapshotProcessor, RecoveryPlan recoveryPlan) {
        HashSet<RecoveryProcessor> delMappingSnashotSubProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor mappingSnapshotProcessor : allMappingSnapshotProcessor) {
            MappingSnapshotSubProcessor mstp = (MappingSnapshotSubProcessor)mappingSnapshotProcessor;
            DeleteSnapshotMappingSubProcessor processor = new DeleteSnapshotMappingSubProcessor();
            processor.setProcName(processor.getName());
            if (recoveryPlan.getPlanType() == DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue()) {
                processor.setProcName("com.huawei.ism.drm.host.recovery.process.DeleteSnapshotCopyMappingSubProcessor");
            }
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setDeviceId(mstp.getDeviceId());
            processor.setLunId(mstp.getLunId());
            processor.setSnapshotId(mstp.getSnapshotId());
            processor.setSnapshotName(mstp.getSnapshotName());
            processor.setHostOrGroupId(mstp.getHostOrGroupId());
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            delMappingSnashotSubProcessors.add((RecoveryProcessor)processor);
        }
        return delMappingSnashotSubProcessors;
    }

    private boolean updateSubProcessors(List<RecoveryProcessor> allMappingSnapProcessor, RecoveryPlan recoveryPlan) {
        if (null == allMappingSnapProcessor || allMappingSnapProcessor.isEmpty()) {
            return true;
        }
        Set<RecoveryProcessor> subProcessors = this.createDelSnapshotMappingSubProcessors(allMappingSnapProcessor, recoveryPlan);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(subProcessors);
        }
        IRecoveryProcessService recoveryPlanInterCalledService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        boolean result = recoveryPlanInterCalledService.updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private int countSuccessResult(Set<RecoveryProcessor> mappingLunSubProcessors) {
        int successCount = 0;
        for (RecoveryProcessor process : mappingLunSubProcessors) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != process.getProcStatus()) continue;
            ++successCount;
        }
        return successCount;
    }

    public void updateProcessName() {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoverPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        this.setProcName(this.calcProcessName(recoverPlan.getPlanType()));
    }

    protected String calcProcessName(int planType) {
        String processName = this.getName();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == planType) {
            processName = "com.huawei.ism.drm.host.recovery.process.DeleteSnapshotCopyMappingProcessor";
        }
        return processName;
    }

    public void updateDescription() {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotCopyMappingProcessor.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotMappingProcessor.des");
        }
    }

    public String getStepPosition() {
        return "UnmappingSnapshot";
    }
}

