/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;

public class MappingSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -931973272333339002L;
    private static Log logger = LogFactory.getInstance(MappingSnapshotSubProcessor.class);
    private String deviceId;
    private String lunId;
    private String lunName;
    private String snapshotId = null;
    private String snapshotWWN;
    private String snapshotName = null;
    private String hostOrGroupId;
    private String hostOrGroupName;
    private transient ResourceVO resourceVO;
    private String lunGroupId;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotWWN() {
        return this.snapshotWWN;
    }

    public void setSnapshotWWN(String snapshotWWN) {
        this.snapshotWWN = snapshotWWN;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getLunGroupId() {
        return this.lunGroupId;
    }

    public void setLunGroupId(String lunGroupId) {
        this.lunGroupId = lunGroupId;
    }

    public final boolean execute(RecoveryProcessorContext context) {
        RecoveryProcessResult processResult = context.getProcessResult();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{this.getSnapshotName(), this.getHostOrGroupName()});
            this.updateProcessDetail("ism.drm.recovery.snapshot.already.mapped", new String[]{this.getSnapshotName(), this.getHostOrGroupName()});
            return true;
        }
        String createSnapshotResultkey = RecoveryProcessResult.getCreateSnapshotProcResultKey((String)this.getDeviceId(), (String)this.getLunId());
        boolean createSnapshotResult = processResult.getProcessResult(createSnapshotResultkey);
        if (!createSnapshotResult && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() != this.getProcType()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948680", new String[]{this.getLunId()});
            return true;
        }
        String wwnKey = RecoveryProcessResult.getCopySnapshotProcResultkey((String)this.deviceId, (String)this.lunId);
        this.setSnapshotWWN((String)context.getAttribute(wwnKey));
        OperationResult result = this.mappingSnapshot();
        if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    protected OperationResult mappingSnapshot() {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(this.getHostOrGroupId());
        if (null == drResource) {
            this.updateProcessName("ism.drm.recovery.snapshot.mapping.failed");
            OperationResult operationResult = this.checkOperationObject();
            return operationResult;
        }
        this.updateProcessNameParams(new String[]{this.getSnapshotName(), drResource.getName()});
        this.setHostOrGroupName(drResource.getName());
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setId(this.getSnapshotId());
        arraySnapshot.setSnapshotName(this.getSnapshotName());
        this.initSnapshotWWN(proxy, (Snapshot)arraySnapshot);
        String srcLunId = this.getLunId();
        if (null == this.resourceVO) {
            logger.info((Object)("resourceVO is null," + this.getHostOrGroupId()));
            OperationResult operationResult = new OperationResult("Mapping", true, false, String.valueOf(1073948717L), new String[]{drResource.getName()});
            return operationResult;
        }
        OperationResult operationResult = HvsUnit.class.getName().equals(deviceType) ? this.mappingSnapshotnForHvs((Snapshot)arraySnapshot, proxy) : this.mappingSnapshotForNoHvs(srcLunId, (Snapshot)arraySnapshot, drResource, proxy);
        return operationResult;
    }

    private OperationResult mappingSnapshotnForHvs(Snapshot arraySnapshot, IStorageSnapshotManager proxy) {
        if (VerifyUtil.isEmpty((String)this.lunGroupId)) {
            return new OperationResult("Mapping", true, false, String.valueOf(1073948676L), new String[0]);
        }
        return proxy.addSnapshotToLunGroup(this.getDeviceId(), arraySnapshot, this.lunGroupId, null);
    }

    private OperationResult mappingSnapshotForNoHvs(String srcLunId, Snapshot arraySnapshot, DrResource drResource, IStorageSnapshotManager proxy) {
        if (drResource instanceof DrHost) {
            return proxy.mappingSnapshot(this.getDeviceId(), srcLunId, arraySnapshot, (HostVO)this.resourceVO);
        }
        return proxy.mappingSnapshot(this.getDeviceId(), srcLunId, arraySnapshot, (HostGroupVO)this.resourceVO);
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getMappingLunProcResultKey((String)this.getLunId(), (String)this.getSnapshotId(), (String)this.getSnapshotWWN(), (String)this.getHostOrGroupId(), (String)this.getDeviceId());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void initSnapshotWWN(IStorageSnapshotManager proxy, Snapshot snapshot) {
        if (!(VerifyUtil.isEmpty((String)this.snapshotWWN) || "null".equals(this.snapshotWWN) || "--".equals(this.snapshotWWN))) {
            return;
        }
        List snapshots = proxy.getSnapshot(this.getDeviceId(), snapshot);
        if (!VerifyUtil.isEmpty((Collection)snapshots)) {
            this.snapshotWWN = ((Snapshot)snapshots.get(0)).getWwn();
        }
    }

    private OperationResult checkOperationObject() {
        String[] errorParams = new String[]{this.getHostOrGroupId()};
        String errorCode = String.valueOf(1073948686L);
        return new OperationResult("Mapping", true, false, errorCode, errorParams);
    }

    public ResourceVO getResourceVO() {
        return this.resourceVO;
    }

    public void setResourceVO(ResourceVO resourceVO) {
        this.resourceVO = resourceVO;
    }
}

