/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.RemoveLunMappingSubProcessor;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RemoveLunMappingProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -534662695597223356L;
    private static final Log LOGGER = LogFactory.getInstance(RemoveLunMappingProcessor.class);

    public RemoveLunMappingProcessor() {
        this.setIsNeedSave(false);
    }

    public RemoveLunMappingProcessor(RecoveryProcessor parentProcess) {
        this();
        if (null == parentProcess) {
            return;
        }
        this.setProcName(this.getName());
        this.setProcType(parentProcess.getProcType());
        this.setPlanId(parentProcess.getPlanId());
        this.setParentProc(parentProcess);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        Set removeLunMappingSubProcessors = this.getChildProc();
        if (null == removeLunMappingSubProcessors || removeLunMappingSubProcessors.isEmpty()) {
            this.updateSubProcessors(context);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            return this.endRecoveryProcess(context);
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private boolean updateSubProcessors(RecoveryProcessorContext context) {
        List<ProtectObject> pos = DBRecoveryTools.appCurrentPosFilter(context);
        String poProviderSn = context.getProtectGroup().getPoProviderSN();
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(poProviderSn);
        Set<RecoveryProcessor> removeLunMappingSubProcessors = this.createSubProcessor(context, pos, drResource);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(removeLunMappingSubProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private Set<RecoveryProcessor> createSubProcessor(RecoveryProcessorContext context, List<ProtectObject> pos, DrResource drResource) {
        HashSet<String> removeLunId = new HashSet<String>();
        ProtectGroup protectGroup = context.getProtectGroup();
        HashSet<RecoveryProcessor> removeLunMappingSubProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : pos) {
            if (null == po) {
                LOGGER.error((Object)"po is null.", 90160758786989L);
                continue;
            }
            if (po.getPoType() != protectGroup.getPoType()) {
                LOGGER.info((Object)("po is Nas,po:" + po.getName()), 90160758786989L);
                continue;
            }
            Set storageInfoSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)storageInfoSet)) {
                LOGGER.error((Object)("storageInfo is null,po:" + po.getName()), 90160758786989L);
                continue;
            }
            String productSiteId = protectGroup.getProductSiteId();
            for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
                String lunWwn = storageInfo.getLunWWN();
                List<StorageResource> storageResource = this.getStorageResource(productSiteId, lunWwn);
                if (VerifyUtil.isEmpty(storageResource)) {
                    LOGGER.info((Object)("resources is null,lunWwn=" + lunWwn), 90160758786989L);
                    continue;
                }
                Set<RemoveLunMappingSubProcessor> processors = this.createSubProcessor(storageResource, po, drResource, removeLunId);
                removeLunMappingSubProcessors.addAll(processors);
            }
        }
        return removeLunMappingSubProcessors;
    }

    private Set<RemoveLunMappingSubProcessor> createSubProcessor(List<StorageResource> storageResourceList, ProtectObject protectObject, DrResource drResource, Set<String> removeLunId) {
        HashSet<RemoveLunMappingSubProcessor> processorSet = new HashSet<RemoveLunMappingSubProcessor>();
        for (StorageResource storageResource : storageResourceList) {
            String devSn = storageResource.getDevSn();
            String lunId = storageResource.getResourceId();
            if (removeLunId.contains(devSn + "_" + lunId)) {
                LOGGER.info((Object)("storageInfo is share,lunId:" + lunId + ",po:" + protectObject.getName() + ",deviceSn" + devSn), 90160758786988L);
                continue;
            }
            removeLunId.add(devSn + "_" + lunId);
            RemoveLunMappingSubProcessor processor = new RemoveLunMappingSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setSrcDeviceId(devSn);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setLunId(lunId);
            processor.setHostOrGroupId(protectObject.getProviderSN());
            processor.setLunName(storageResource.getName());
            processor.setHostOrGroupName(drResource.getName());
            processorSet.add(processor);
        }
        return processorSet;
    }

    private List<StorageResource> getStorageResource(String siteId, String lunWwn) {
        try {
            LOGGER.debug((Object)"begin get StorageResource,siteId=%s, lunWwn=%s", new Object[]{siteId, 90160758786988L});
            return ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWwn});
        }
        catch (Exception e) {
            LOGGER.error((Object)("query StorageResource exception,lunId=" + lunWwn + ",siteId=" + siteId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return Collections.emptyList();
        }
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    private boolean endRecoveryProcess(RecoveryProcessorContext context) {
        if (DrmEnumDefine.AppType.LUN == RecoveryServiceUtil.getAppType((RecoveryPlan)context.getRecoveryPlan())) {
            this.updateProcessDetail("ism.drm.recovery.no.configured.host", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.updateProcessDetail("ism.drm.recovery.no.configured.host", new String[0]);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }
}

