/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class RemoveLunMappingSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6337500585921852116L;
    private static final Log LOGGER = LogFactory.getInstance(RemoveLunMappingSubProcessor.class);
    private static final String UNMAPPING_LUN_OPERATION = "ism.drm.unmappinglun.operation";
    private static final int REPEAT_TIMES = 10;
    private static final long RETRY_INTERVAL_TIME_UNIT = 2000L;
    private String srcDeviceId;
    private String lunId;
    private String lunWWN;
    private String lunName;
    private String hostOrGroupId;
    private String hostOrGroupName;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus() && !this.isChangedProductHost(context.getRecoveryPlan())) {
            this.updateProcessNameParams(new String[]{this.getLunName(), this.getHostOrGroupName()});
            this.updateProcessDetail("ism.drm.recovery.lun.already.unmapped", new String[]{this.getLunName(), this.getHostOrGroupName()});
            return true;
        }
        this.setHostOrGroupId(this.getCurrentProductHost(context.getRecoveryPlan()));
        OperationResult result = this.removeMappingLun(context.getRecoveryPlan());
        if (null == result) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    protected String generateResultKey() {
        return RecoveryProcessResult.getMappingLunProcResultKey((String)this.getLunId(), (String)this.getLunWWN(), (String)this.getHostOrGroupId(), (String)this.getSrcDeviceId());
    }

    private boolean isChangedProductHost(RecoveryPlan recoveryPlan) {
        String currentProductHost = this.getCurrentProductHost(recoveryPlan);
        return VerifyUtil.isEmpty((String)this.getHostOrGroupId()) || !this.getHostOrGroupId().equals(currentProductHost);
    }

    private String getCurrentProductHost(RecoveryPlan recoveryPlan) {
        Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)pgIter.next();
        return protectGroup.getPoProviderSN();
    }

    protected OperationResult removeMappingLun(RecoveryPlan recoveryPlan) {
        Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        Lun lun = recoveryService.getTargetLunById(this.getSrcDeviceId(), this.getLunId());
        DrResource drResource = recoveryService.getDrResourceByID(this.getHostOrGroupId());
        if (null == lun || null == drResource) {
            this.updateProcessName("ism.drm.recovery.lun.unmapping.failed");
            OperationResult operationResult = this.checkOperationObject(this.getSrcDeviceId(), lun, drResource);
            return operationResult;
        }
        this.updateProcessNameParams(new String[]{lun.getName(), drResource.getName()});
        this.setLunName(lun.getName());
        this.setLunWWN(lun.getWwn());
        this.setHostOrGroupName(drResource.getName());
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getSrcDeviceId());
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        OperationResult operationResult = this.tryRepeatRemoveMapping(proxy, lun, drResource);
        return operationResult;
    }

    private OperationResult tryRepeatRemoveMapping(IStorageLunBaseManager proxy, Lun lun, DrResource drResource) {
        OperationResult result = null;
        for (int i = 10; i > 0; --i) {
            if (drResource instanceof DrHost) {
                HostVO hostVo = new HostVO();
                hostVo.setName(drResource.getName());
                hostVo.setExtProperty(drResource.getExtProperty());
                hostVo.setIpAddress(drResource.getIpAddress());
                result = proxy.removeLunMapping(this.getSrcDeviceId(), lun.getLunId(), hostVo);
            } else {
                HostGroupVO hostGroupVo = new HostGroupVO();
                hostGroupVo.setName(drResource.getName());
                ArrayList hostVOS = new ArrayList();
                Set resourceSet = drResource.getChildResources();
                if (!VerifyUtil.isEmpty((Collection)resourceSet) && resourceSet.size() > 0) {
                    drResource.getChildResources().forEach(item -> {
                        HostVO hostVO = new HostVO();
                        hostVO.setIpAddress(item.getIpAddress());
                        hostVO.setExtProperty(item.getExtProperty());
                        hostVOS.add(hostVO);
                    });
                }
                hostGroupVo.setHostVOs(hostVOS);
                result = proxy.removeLunMapping(this.getSrcDeviceId(), lun.getLunId(), hostGroupVo);
            }
            if (null == result) {
                throw new LegoCheckedException(1073947393L);
            }
            if (result.isSuccess()) break;
            LOGGER.error((Object)("tryRepeatRemoveMappingFromHost faild: waiting for " + i + " seconds to retry., errorCode: " + result.getErrorCode() + ", lun name: " + lun.getName()), -1L);
            CommUtil.pauseThread((long)((long)i * 2000L));
        }
        return result;
    }

    private OperationResult checkOperationObject(String tmpSrcDeviceId, Lun lun, DrResource drResource) {
        String[] errorParams = null;
        String errorCode = null;
        if (null == lun) {
            errorParams = new String[]{this.getLunId(), tmpSrcDeviceId};
            errorCode = String.valueOf(1073948685L);
        } else if (null == drResource) {
            errorParams = new String[]{this.getHostOrGroupId()};
            errorCode = String.valueOf(1073948686L);
        }
        return new OperationResult("unMapping", true, false, errorCode, errorParams);
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunWWN() {
        return this.lunWWN;
    }

    public void setLunWWN(String lunWWN) {
        this.lunWWN = lunWWN;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }
}

