/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.MountHostDeviceProcessor;
import com.huawei.ism.drm.host.recovery.process.MountHostDeviceSubProcessor;
import com.huawei.ism.drm.host.recovery.process.UmountHostDeviceSubProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UmountHostDeviceProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -8518605192609048221L;
    private static final Log LOGGER = LogFactory.getInstance(UmountHostDeviceProcessor.class);
    private final Map<String, List<HostDeviceStorageInfo>> hostDeviceStorageInfosMap = new HashMap<String, List<HostDeviceStorageInfo>>();
    private List<ProtectObject> protectObjectList;
    private RecoveryPlan recvPlan;

    public RecoveryPlan getRecoveryPlan() {
        return this.recvPlan;
    }

    public void setRecoveryPlan(RecoveryPlan recoveryPlan) {
        this.recvPlan = recoveryPlan;
    }

    public Map<String, List<HostDeviceStorageInfo>> getHostDeviceStorageInfosMap() {
        return this.hostDeviceStorageInfosMap;
    }

    public List<ProtectObject> getProtectObjectList() {
        return this.protectObjectList;
    }

    public void setProtectObjectList(List<ProtectObject> pos) {
        this.protectObjectList = pos;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        Set subProcessors;
        List<ProtectObject> pos = DBRecoveryTools.appProtectObjectsFilter(context);
        this.setProtectObjectList(pos);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        this.setRecoveryPlan(recoveryPlan);
        DrmEnumDefine.RecoveryPlanExecuteTypeE lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING;
        List mountSubProcessors = this.getRecoveryProcessors(recoveryPlan, lastRunType, MountHostDeviceSubProcessor.class);
        if (null == mountSubProcessors || mountSubProcessors.isEmpty()) {
            lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA;
            mountSubProcessors = this.getRecoveryProcessors(recoveryPlan, lastRunType, MountHostDeviceSubProcessor.class);
        }
        if (null == (subProcessors = this.getChildProc()) || subProcessors.isEmpty()) {
            this.createSubProcessors(mountSubProcessors);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.error((Object)"getChildProc is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        List allmountProcessor = this.getRecoveryProcessors(recoveryPlan, lastRunType, MountHostDeviceProcessor.class);
        MountHostDeviceProcessor mountProcess = (MountHostDeviceProcessor)((Object)allmountProcessor.get(0));
        this.buildHostDeviceStorageInfosMap(mountProcess);
        String currentHostOrGroupId = DrHostUtil.getCurrentDisasterHost(recoveryPlan, this.getProcType());
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(currentHostOrGroupId);
        DrmAppEnumDefine.CLUSTER_TYPE_E eClusterType = null;
        if (drResource instanceof DrHostGroup) {
            eClusterType = DrmAppEnumDefine.CLUSTER_TYPE_E.getType((int)((DrHostGroup)drResource).getClusterType());
        }
        subProcessors = this.getChildProc();
        for (RecoveryProcessor recoveryProcessor : subProcessors) {
            UmountHostDeviceSubProcessor subProcessor = (UmountHostDeviceSubProcessor)recoveryProcessor;
            subProcessor.setClusterType(eClusterType);
            subProcessor.setHostDeviceStorageInfos(this.hostDeviceStorageInfosMap.get(subProcessor.getHostSN()));
            subProcessor.setProtectObjects(pos);
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)subProcessors);
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        if (null == recoveryTemplate) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean createSubProcessors(List<RecoveryProcessor> mountProcessors) {
        HashSet<UmountHostDeviceSubProcessor> subProcessors = new HashSet<UmountHostDeviceSubProcessor>();
        for (RecoveryProcessor proc : mountProcessors) {
            if (!(proc instanceof MountHostDeviceSubProcessor)) continue;
            MountHostDeviceSubProcessor mountProc = (MountHostDeviceSubProcessor)proc;
            UmountHostDeviceSubProcessor umountProc = new UmountHostDeviceSubProcessor();
            umountProc.setProcName(umountProc.getName());
            umountProc.setProcType(this.getProcType());
            umountProc.setPlanId(this.getPlanId());
            umountProc.setParentProc((RecoveryProcessor)this);
            umountProc.setPoUuid(mountProc.getPoUuid());
            umountProc.setPoName(mountProc.getPoName());
            umountProc.setHostSN(mountProc.getHostSN());
            umountProc.setHostName(mountProc.getHostName());
            umountProc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessors.add(umountProc);
        }
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected Map<String, Set<UmountHostDeviceSubProcessor>> groupingProcessByHost(Set<UmountHostDeviceSubProcessor> subProcessors) {
        HashMap<String, Set<UmountHostDeviceSubProcessor>> result = new HashMap<String, Set<UmountHostDeviceSubProcessor>>();
        for (UmountHostDeviceSubProcessor process : subProcessors) {
            if (!result.containsKey(process.getHostSN())) {
                result.put(process.getHostSN(), new HashSet());
            }
            ((Set)result.get(process.getHostSN())).add(process);
        }
        return result;
    }

    private void buildHostDeviceStorageInfosMap(MountHostDeviceProcessor mountProcess) {
        ArrayList<HostDeviceStorageInfo> hostDeviceStorageInfoList = new ArrayList<HostDeviceStorageInfo>();
        Map processMap = mountProcess.getProps();
        for (Map.Entry entry : processMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("HOST_STOR_CONFIG_")) continue;
            JSONObject jsonStorageInfo = JSONObject.fromObject(entry.getValue());
            HostDeviceStorageInfo hostDeviceStorageInfo = (HostDeviceStorageInfo)JSONObject.toBean((JSONObject)jsonStorageInfo, HostDeviceStorageInfo.class);
            hostDeviceStorageInfoList.add(hostDeviceStorageInfo);
        }
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfoList) {
            List<HostDeviceStorageInfo> hostDeviceStorageInfos = this.hostDeviceStorageInfosMap.get(hostDeviceStorageInfo.getHostSN());
            if (null == hostDeviceStorageInfos) {
                hostDeviceStorageInfos = new ArrayList<HostDeviceStorageInfo>();
                this.hostDeviceStorageInfosMap.put(hostDeviceStorageInfo.getHostSN(), hostDeviceStorageInfos);
            }
            hostDeviceStorageInfos.add(hostDeviceStorageInfo);
        }
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.host.recovery.process.UmountHostDeviceProcessor.des");
    }
}

