/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.mediation.jms.IMessageReceiverExtender;
import com.huawei.ism.cbb.mediation.service.impl.NeMgrProtocolExtendServiceImpl;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.NetUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import java.util.Map;

public class HostDelMsgReceiverExtender
implements IMessageReceiverExtender {
    private static final Log LOGGER = LogFactory.getInstance(HostDelMsgReceiverExtender.class);

    public void postProcess(NetworkEntity ne) {
        if (null == ne || !(ne instanceof Host)) {
            return;
        }
        this.deleteAlarmTrap(ne);
    }

    private void deleteAlarmTrap(NetworkEntity ne) {
        try {
            NeMgrProtocolExtendServiceImpl neService = new NeMgrProtocolExtendServiceImpl();
            NeMgrProtocolExtend neMgrExtend = neService.findByMoId(ne.getMoId());
            if (null == neMgrExtend) {
                LOGGER.error((Object)("delete trap fail,neMgrExtend is null,moId:" + ne.getMoId()), 90160758786879L);
                return;
            }
            neService.delete(neMgrExtend);
            Map extParams = neMgrExtend.getExtendParams();
            String ip = this.getTrapIp(neMgrExtend.getNetworkIpAddress(), extParams);
            String port = this.getTrapPort(extParams);
            if (VerifyUtil.isEmpty((String)ip) || VerifyUtil.isEmpty((String)port)) {
                LOGGER.error((Object)("register info is null, ip:" + ne.getLinkIp()), 90160758786879L);
                return;
            }
            ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).deleteTrap(neMgrExtend, Integer.valueOf(3), ip, NumberUtil.parseInteger((Object)port));
            LOGGER.info((Object)("delete trap sucess,neip:" + ne.getLinkIp() + ",trapip:" + ip), 90160758786879L);
        }
        catch (Exception e) {
            LOGGER.error((Object)("delete trap failed,neip:" + ne.getLinkIp() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786879L);
        }
    }

    private String getTrapIp(String hostIp, Map<String, String> extParams) {
        String ip = extParams.get("host_trapip");
        if (!VerifyUtil.isEmpty((String)ip)) {
            return ip;
        }
        String port = extParams.get("port");
        String localIp = NetUtil.queryLocalIP((String)hostIp, (int)NumberUtil.convertToInteger((Object)port));
        LOGGER.info((Object)("Getting local ip " + localIp + " vs linkIP:" + hostIp + " remotePort:" + port), 90160758786988L);
        return localIp;
    }

    private String getTrapPort(Map<String, String> extParams) {
        String trapPort = extParams.get("host_trapport");
        if (!VerifyUtil.isEmpty((String)trapPort) && !"0".equals(trapPort.trim())) {
            return trapPort.trim();
        }
        int port = LegoProperties.getTrapListenPort();
        LOGGER.info((Object)("Getting local port:" + port), 90160758786988L);
        return String.valueOf(port);
    }
}

