/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoEvent;
import com.huawei.lego.nem.fault.sdk.model.SnmpTrapPDU;
import com.huawei.lego.nem.fault.sdk.service.ITrapService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class HostSnmpTrapServiceImpl
implements ITrapService {
    private static final Log LOGGER = LogFactory.getInstance(HostSnmpTrapServiceImpl.class);

    public boolean isMyMOIP(String agentIp) {
        IMoDao moDao = CommonDAOLocator.getMoDao();
        Host host = (Host)moDao.getMo(Host.class, "linkIp", (Object)agentIp);
        if (null != host) {
            return true;
        }
        LOGGER.error((Object)("cannot find the host by agentIp: " + agentIp), 90160777658902L);
        return false;
    }

    public boolean isTrapDuplacated(SnmpTrapPDU paramSnmpTrapPDU) {
        return false;
    }

    public LegoEvent parseEvent(SnmpTrapPDU trappdu) {
        if (null == trappdu) {
            LOGGER.error((Object)"trappdu is null.", 90160777658902L);
            return null;
        }
        IMoDao dao = CommonDAOLocator.getMoDao();
        Host host = (Host)dao.getMo(Host.class, "linkIp", (Object)trappdu.getRemoteHost());
        if (null == host) {
            LOGGER.info((Object)("Not found StorageUnit: " + trappdu.getRemoteHost()), 90160777658902L);
            return null;
        }
        String queryString = "from TopoObject mo where mo.name ='Management System'";
        List moList = dao.getHibernateTemplate().find(queryString, new Object[0]);
        if (VerifyUtil.isEmpty((Collection)moList)) {
            LOGGER.info((Object)"query system MO fail.", 90160777658902L);
            return null;
        }
        LegoEvent legoEvent = null;
        try {
            legoEvent = this.buildLegoEventByTrapPDU(trappdu, host);
            TopoObject mo = (TopoObject)moList.get(0);
            legoEvent.setMoIP("127.0.0.1");
            legoEvent.setMoName(mo.getName());
            legoEvent.setMoUuid(mo.getUuid());
            legoEvent.setMoId(mo.getMoId().longValue());
            legoEvent.setPortUuid(mo.getUuid());
            legoEvent.setMoMainType(mo.getMainType());
            legoEvent.setMoSubType(mo.getSubType());
            legoEvent.setSourceId(host.getUuid());
            legoEvent.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
            this.writeLog(legoEvent);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception on parseEvent from " + trappdu.getRemoteHost() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160767696896L);
        }
        return legoEvent;
    }

    private LegoEvent buildLegoEventByTrapPDU(SnmpTrapPDU trappdu, Host host) throws ParseException {
        String prefix = ".1.3.6.1.4.1.2011.2.91.10.3.1.1.";
        String id = trappdu.getSnmpValue(prefix + "7");
        String faultTime = trappdu.getSnmpValue(prefix + "8");
        String sequence = trappdu.getSnmpValue(prefix + "9");
        String additionInfo = trappdu.getSnmpValue(prefix + "10");
        String faultCategory = trappdu.getSnmpValue(prefix + "11");
        LegoEvent legoEvent = new LegoEvent();
        legoEvent.setTrapType(NumberUtil.convertToInteger((Object)faultCategory).intValue());
        legoEvent.setEventId("0x" + Integer.toHexString(NumberUtil.convertToInteger((Object)id)));
        StringBuilder sb = new StringBuilder(null == additionInfo ? "" : additionInfo);
        sb.append(",").append(host.getIpAddress()).append(",").append(host.getUuid());
        legoEvent.setEventParam(sb.toString().split(","));
        legoEvent.setSequence(Long.parseLong(sequence));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = format.parse(faultTime);
        legoEvent.setEventTime(time.getTime());
        if ("2".equals(faultCategory)) {
            legoEvent.setClearState(FaultEnum.ClearState.CLEARED);
            legoEvent.setClearTime(time.getTime());
        }
        return legoEvent;
    }

    private void writeLog(LegoEvent event) {
        StringBuilder builder = new StringBuilder(256);
        builder.append(" A new event return lego is: EventId: ");
        builder.append(event.getEventId());
        builder.append(", from IP: ");
        builder.append(event.getMoIP());
        builder.append(", TrapType: ");
        builder.append(event.getTrapType());
        builder.append(", param: ");
        if (null != event.getEventParam()) {
            builder.append(Arrays.toString(event.getEventParam()));
        }
        builder.append(", sequence: ");
        builder.append(event.getSequence());
        builder.append(", happenTime:");
        builder.append(event.getEventTime());
        builder.append(", clearTime:");
        builder.append(event.getClearTime());
        LOGGER.info((Object)builder.toString(), 90160767696896L);
    }
}

