/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class KvJsonTree {
    private static final int JSON_OBJECT = 1;
    private static final int JSON_ARRAY = 2;
    private static final int JSON_ERROR = 4;
    private static final Pattern SUBSCRIPT = Pattern.compile("^\\[(\\d+)]$");
    private static final Log LOGGER = LogFactory.getInstance(KvJsonTree.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Map<String, KvJsonTree> children = new HashMap<String, KvJsonTree>();
    private final Set<List<String>> fields = new HashSet<List<String>>();
    private String name;
    private int type;
    private KvJsonTree parent;

    public void updateName(String value) {
        this.name = value;
        if (this.parent != null) {
            if (SUBSCRIPT.matcher(value).matches()) {
                this.parent.initType(2);
            } else {
                this.parent.initType(1);
            }
        }
    }

    private void initType(int mode) {
        this.type |= mode;
        if (this.type > 2) {
            KvJsonTree current = this.parent;
            while (current != null) {
                current.type |= 4;
                current = current.parent;
            }
        }
    }

    public boolean isError() {
        if (this.type < 0 || this.type > 2) {
            return true;
        }
        if (!this.children.isEmpty() && !this.fields.isEmpty()) {
            return true;
        }
        return this.children.isEmpty() && this.fields.size() > 1;
    }

    public boolean isJsonObject() {
        return this.type == 0 || this.type == 1;
    }

    public boolean isJsonArray() {
        return this.type == 2;
    }

    public KvJsonTree getChildByName(String name) {
        KvJsonTree child = this.children.get(name);
        if (child != null) {
            return child;
        }
        KvJsonTree tree = new KvJsonTree();
        tree.setParent(this);
        this.children.put(name, tree);
        tree.updateName(name);
        return tree;
    }

    public String resolveString(Map<List<String>, String> items) {
        Object object = this.resolveObject(items);
        if (object == null) {
            return null;
        }
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new LegoCheckedException("write json value failed", (Throwable)e);
        }
    }

    public Object resolveObject(Map<List<String>, String> items) {
        if (this.isError()) {
            return null;
        }
        Object object = this.isJsonObject() ? this.buildJsonObject(items) : (this.isJsonArray() ? this.buildJsonArray(items) : null);
        return object;
    }

    private Object buildJsonObject(Map<List<String>, String> items) {
        if (!this.children.isEmpty()) {
            HashMap data = new HashMap();
            this.children.forEach((name, child) -> data.put(name, child.resolveObject(items)));
            return data;
        }
        return this.resolveFieldValue(items);
    }

    private Object buildJsonArray(Map<List<String>, String> items) {
        Object object = this.buildJsonObject(items);
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap data = new HashMap();
            map.forEach((key, value) -> this.buildJsonArrayItem(data, key, value));
            return data.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        return null;
    }

    private void buildJsonArrayItem(Map<Integer, Object> data, Object key, Object value) {
        if (!(key instanceof String)) {
            return;
        }
        String field = (String)key;
        Matcher matcher = SUBSCRIPT.matcher(field);
        if (matcher.find()) {
            String subscript = matcher.group(1);
            Integer index = Integer.valueOf(subscript);
            data.put(index, value);
        }
    }

    private Object resolveFieldValue(Map<List<String>, String> items) {
        return this.fields.stream().findFirst().map(field -> this.resolveFieldValue(items, (List<String>)field)).orElse(null);
    }

    private Object resolveFieldValue(Map<List<String>, String> items, List<String> field) {
        String value = items.get(field);
        if (value == null) {
            return null;
        }
        try {
            return MAPPER.readValue(value, Object.class);
        }
        catch (JsonProcessingException e) {
            throw new LegoCheckedException("parse json value failed", (Throwable)e);
        }
    }

    public Map<String, KvJsonTree> getChildren() {
        return this.children;
    }

    public Set<List<String>> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public KvJsonTree getParent() {
        return this.parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setParent(KvJsonTree parent) {
        this.parent = parent;
    }

    static {
        try {
            MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Initialize ObjectMapper failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }
}

