/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class ProtectObjectAppUtil {
    private static final Log LOGGER = LogFactory.getInstance(ProtectObjectAppUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProtectObject getProtectObjectByPoUUID(String poUuid) {
        if (VerifyUtil.isEmpty((String)poUuid)) {
            LOGGER.error((Object)"pgId or uuid is empty for getProtectObjectByMoUUID", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject result = null;
        Session session = null;
        try {
            List pos;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"uuid", (Object)poUuid));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            try {
                pos = crit.list();
            }
            catch (DataAccessException e) {
                LOGGER.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            if (!VerifyUtil.isEmpty((Collection)pos)) {
                result = (ProtectObject)pos.get(0);
            }
        }
        catch (Throwable throwable) {
            DBOperationUtil.closeSession(session);
            throw throwable;
        }
        DBOperationUtil.closeSession((Session)session);
        return result;
    }

    public static List<ProtectObject> getProtectObjecstByPoUUIDs(String[] poUuids) {
        List pos;
        if (VerifyUtil.isEmpty((Object[])poUuids)) {
            LOGGER.error((Object)"pgId or uuid is empty for getProtectObjectByMoUUID", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add(Restrictions.in((String)"uuid", (Object[])poUuids));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            pos = crit.list();
        }
        catch (DataAccessException e) {
            try {
                LOGGER.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return pos;
    }

    public static List<ProtectObject> getProtectObjectByHostSnAndPoType(String hostSn, Integer poType) {
        List pos;
        if (VerifyUtil.isEmpty((String)hostSn)) {
            LOGGER.error((Object)"HostSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"providerSN", (Object)hostSn));
            if (!VerifyUtil.isEmpty((Object)poType)) {
                crit.add((Criterion)Restrictions.eq((String)"poType", (Object)poType));
            }
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            pos = crit.list();
        }
        catch (DataAccessException e) {
            try {
                LOGGER.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return pos;
    }

    public static List<ProtectObject> getProtectObjectByHostSn(String hostSn) {
        if (VerifyUtil.isEmpty((String)hostSn)) {
            LOGGER.error((Object)"HostSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        return ProtectObjectAppUtil.getProtectObjectByHostSnAndPoType(hostSn, null);
    }

    public static String getPolicyTemplateSettings(ActionContext context, String propKey) {
        String propValue = null;
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Integer location = (Integer)context.getObject("PG_EXECUTE_LOCATION");
        Map props = protectGroup.getTemplate().getProps();
        if (null != location && location >= 0) {
            propValue = (String)props.get(propKey + location);
        }
        if (null == propValue) {
            propValue = (String)props.get(propKey);
        }
        return propValue;
    }

    public static String getPolicyTemplateSettings(PolicyTemplate policyTemplate, Schedule schedule, String propKey) {
        String propValue = null;
        Integer location = schedule.getProtectLocation();
        Map props = policyTemplate.getProps();
        if (null != location && location >= 0) {
            propValue = (String)props.get(propKey + location);
        }
        if (null == propValue) {
            propValue = (String)props.get(propKey);
        }
        return propValue;
    }

    public static boolean checkPoStorage(ProtectObjectStorageInfo hostStorage, RelicaStorageInfo relicaStorage) {
        return hostStorage.getResourceProviderSN().equals(relicaStorage.getSrcStorageProviderSN()) && hostStorage.getResourceId().equals(relicaStorage.getSrcStorageId()) || !VerifyUtil.isEmpty((String)hostStorage.getLunWWN()) && hostStorage.getLunWWN().equalsIgnoreCase(relicaStorage.getProtectObjectStorageWwn());
    }
}

