/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager;

import com.google.common.collect.ImmutableMap;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public abstract class BaseAntiBlackmailApiManager {
    private static final Log LOGGER;
    private static final Map<String, String> IGNORE_URL_ENCODE_CHAR_MAP;

    protected RestConnection getConnection(String devSn, String connectionType) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn + connectionType);
        if (VerifyUtil.isEmpty((Object)connection)) {
            LOGGER.error((Object)"Failed to get the connection of ProtectManager. Dev sn=%s", new Object[]{devSn});
            throw new LegoCheckedException(1073947393L);
        }
        return connection;
    }

    protected String concatenateQueryParam(String url, Map<String, String> queryParams) {
        if (VerifyUtil.isEmpty(queryParams)) {
            return url;
        }
        StringBuilder queryStrBuilder = new StringBuilder();
        for (Map.Entry<String, String> paramEntry : queryParams.entrySet()) {
            this.concatenateSingleParam(paramEntry, queryStrBuilder);
        }
        String queryStrParams = queryStrBuilder.substring(1);
        try {
            queryStrParams = URLEncoder.encode(queryStrParams, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"The %s encoding is not support", new Object[]{StandardCharsets.UTF_8.name()});
            return url + "?" + queryStrParams;
        }
        for (Map.Entry<String, String> ignoreEncodeCharEntry : IGNORE_URL_ENCODE_CHAR_MAP.entrySet()) {
            queryStrParams = queryStrParams.replace(ignoreEncodeCharEntry.getKey(), ignoreEncodeCharEntry.getValue());
        }
        return url + "?" + queryStrParams;
    }

    private void concatenateSingleParam(Map.Entry<String, String> paramEntry, StringBuilder queryStrBuilder) {
        String[] values;
        for (String value : values = paramEntry.getValue().split(",")) {
            queryStrBuilder.append("&").append(paramEntry.getKey()).append("=").append(value);
        }
    }

    static {
        ImmutableMap tempMap;
        LOGGER = LogFactory.getInstance(BaseAntiBlackmailApiManager.class);
        try {
            tempMap = ImmutableMap.of((Object)URLEncoder.encode("=", StandardCharsets.UTF_8.name()), (Object)"=", (Object)URLEncoder.encode("~", StandardCharsets.UTF_8.name()), (Object)"~", (Object)URLEncoder.encode("&", StandardCharsets.UTF_8.name()), (Object)"&");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"The %s encoding is not support, init ignore encode characters error.", new Object[]{StandardCharsets.UTF_8.name()});
            tempMap = ImmutableMap.of();
        }
        IGNORE_URL_ENCODE_CHAR_MAP = tempMap;
    }
}

