/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.oceanprotect;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.OceanProtectResourceManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailTaskManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.api.IAntiBlackmailTaskApiManager;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.annotation.Nullable;

public class OceanProtectTaskManager
implements IAntiBlackmailTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(OceanProtectResourceManager.class);
    private static final String RUNNING_STATUS_QUERY_STR = StringUtils.join((Iterable)AntiBlackMailConstant.OP_TASK_RUNNING_STATUS_LIST, (String)",");
    private static final String COMPLETED_STATUS_QUERY_STR = StringUtils.join((Iterable)AntiBlackMailConstant.OP_TASK_COMPLETED_STATUS_LIST, (String)",");
    private IAntiBlackmailTaskApiManager taskApiManager;

    public Optional<AntiBlackmailPlatformTask> querySpecificTask(String devSn, String taskId) {
        return this.taskApiManager.querySingleTask(devSn, taskId);
    }

    public List<AntiBlackmailPlatformTask> queryRunningTask(String devSn, @Nullable String types) {
        Map<String, String> queryParams = this.createQueryParams(RUNNING_STATUS_QUERY_STR, types);
        return this.taskApiManager.queryBatchTask(devSn, queryParams);
    }

    public List<AntiBlackmailPlatformTask> queryHistoricTask(String devSn, @Nullable String types) {
        Map<String, String> queryParams = this.createQueryParams(COMPLETED_STATUS_QUERY_STR, types);
        return this.taskApiManager.queryBatchTask(devSn, queryParams);
    }

    public Optional<AntiBlackmailPlatformTask> queryTheLatestTask(String devSn, String type, @Nullable Long startTime) {
        Optional taskType = AntiBlackMailEnumDefine.OceanProtectTaskTypeEnum.getTaskType((String)type);
        if (!taskType.isPresent()) {
            LOGGER.error((Object)"Task type is not an enumeration value, task type: %s.", new Object[]{type});
            return Optional.empty();
        }
        List<AntiBlackmailPlatformTask> runningTaskList = this.queryRunningTask(devSn, type);
        if (!VerifyUtil.isEmpty(runningTaskList)) {
            return Optional.of(runningTaskList.get(0));
        }
        List<AntiBlackmailPlatformTask> completeTaskList = this.queryHistoricTask(devSn, type);
        if (VerifyUtil.isEmpty(completeTaskList)) {
            LOGGER.error((Object)"No task of this type exists, type: %s, dev sn: %s.", new Object[]{type, devSn});
            return Optional.empty();
        }
        AntiBlackmailPlatformTask task = completeTaskList.get(0);
        if (!VerifyUtil.isEmpty((Object)startTime) && task.getStartTime() < startTime) {
            LOGGER.error((Object)"There's no task whose startTime is after the timePoint(%s), type: %s, dev sn: %s.", new Object[]{startTime, type, devSn});
            return Optional.empty();
        }
        return Optional.of(task);
    }

    public int queryRunningTaskNum(String devSn) {
        Map map = this.taskApiManager.queryTaskSummary(devSn);
        return Integer.parseInt((String)map.get("running")) + Integer.parseInt((String)map.get("pending"));
    }

    public String getPlatformType() {
        return AntiBlackMailEnumDefine.PlatformType.OCEAN_PROTECT.getValue();
    }

    public void setTaskApiManager(IAntiBlackmailTaskApiManager taskApiManager) {
        this.taskApiManager = taskApiManager;
    }

    private Map<String, String> createQueryParams(String statusList, @Nullable String types) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("statusList", statusList);
        if (!VerifyUtil.isEmpty((String)types)) {
            queryParams.put("types", types);
        }
        queryParams.put("orderBy", "startTime");
        queryParams.put("orderType", "desc");
        queryParams.put("isVisible", "true");
        queryParams.put("isSystem", "false");
        return queryParams;
    }
}

