/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.protection.action.CreateHyperCloneSnapshotTask;
import com.huawei.ism.drm.storage.protection.action.DeleteHyperCloneSnapshotTask;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CreateHyperCloneSnapshotSubAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(CreateHyperCloneSnapshotSubAction.class);

    public void preExcute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        if (!this.isNeedSnpshot(protectGroup)) {
            this.setEnable(false);
            return;
        }
    }

    public boolean doExecute(ActionContext context) {
        logger.debug((Object)"inter CreateHyperCloneSnapshotSubAction.");
        Boolean splitResult = (Boolean)context.getObject("CLONE_SPLIT_RESULT");
        if (null != splitResult && splitResult.booleanValue()) {
            this.setDetail("com.huawei.ism.drm.createsnap.noneed");
            return true;
        }
        CloneConsistentGroup cloneCG = (CloneConsistentGroup)context.getObject("CloneCG");
        if (null == cloneCG || VerifyUtil.isEmpty((Collection)cloneCG.getPairs())) {
            logger.error((Object)"clone has no pair.");
            this.setDetail("lego.err.1073947393");
            return false;
        }
        String deviceSN = "";
        ArrayList<CreateHyperCloneSnapshotTask> tasks = new ArrayList<CreateHyperCloneSnapshotTask>();
        for (HyperClonePair clonePair : cloneCG.getPairs()) {
            deviceSN = clonePair.getDeviceSn();
            CreateHyperCloneSnapshotTask task = new CreateHyperCloneSnapshotTask(clonePair.getDeviceSn(), clonePair.getSrcLunId());
            tasks.add(task);
        }
        List snapshots = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)0, (int)20);
        if (null == snapshots) {
            logger.error((Object)"create snapshot error.result is null.");
            this.setDetail("lego.err.1073948680");
            return false;
        }
        if (snapshots.size() != tasks.size()) {
            this.deleteSnapshot(deviceSN, snapshots);
            logger.error((Object)"create snapshot error.");
            this.setDetail("lego.err.1073948680");
            return false;
        }
        ArrayList<String> snapshotIds = new ArrayList<String>();
        JSONArray jsonArray = new JSONArray();
        for (Snapshot snap : snapshots) {
            if (null == snap.getSnapshotId() || snap.getSnapshotId().isEmpty()) {
                logger.error((Object)("snapshot is is null.src lun is " + snap.getSrcResourceId() + "@" + deviceSN));
                this.deleteSnapshot(deviceSN, snapshots);
                this.setDetail("lego.err.1073948680");
                return false;
            }
            snapshotIds.add(snap.getSnapshotId());
            JSONObject json = new JSONObject();
            json.put((Object)"devSn", (Object)deviceSN);
            json.put((Object)"snapshotId", (Object)snap.getSnapshotId());
            json.put((Object)"lunId", (Object)(snap.getSrcResourceId() + ""));
            json.put((Object)"snapshotName", (Object)snap.getSnapshotName());
            jsonArray.add((Object)json);
        }
        logger.debug((Object)("create snapshot success:" + snapshotIds));
        return this.activeSnapshot(context, deviceSN, snapshots, snapshotIds, jsonArray);
    }

    private boolean activeSnapshot(ActionContext context, String deviceSN, List<Snapshot> snapshots, List<String> snapshotIds, JSONArray jsonArray) {
        OperationResult optResult = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(deviceSN).activeSnapshotAfterStop(deviceSN, snapshotIds);
        if (null != optResult && !optResult.isSuccess()) {
            this.deleteSnapshot(deviceSN, snapshots);
            this.setDetail("lego.err." + optResult.getErrorCode());
            if (optResult.getArgs() != null && optResult.getArgs().length != 0) {
                this.setDetailParams(this.constructParams(optResult.getArgs()));
            }
            return false;
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("CLONE_SNAPSHOT", jsonArray.toString());
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), prop);
        return true;
    }

    private void deleteSnapshot(String deviceSN, List<Snapshot> snapshots) {
        logger.debug((Object)"delete unexpect snapshot.");
        ArrayList<DeleteHyperCloneSnapshotTask> delTasks = new ArrayList<DeleteHyperCloneSnapshotTask>();
        for (Snapshot snapshot : snapshots) {
            if (null == snapshot.getSnapshotId() || snapshot.getSnapshotId().isEmpty()) continue;
            DeleteHyperCloneSnapshotTask task = new DeleteHyperCloneSnapshotTask(deviceSN, snapshot.getSnapshotId());
            delTasks.add(task);
        }
        if (!delTasks.isEmpty()) {
            ExecutionService.batchSubmit(delTasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)0, (int)20);
        }
    }
}

