/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.action;

import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class CreateHyperCloneSnapshotTask
implements Callable<Snapshot> {
    private static final Log logger = LogFactory.getInstance(CreateHyperCloneSnapshotTask.class);
    private final String devSn;
    private final String lunId;

    public CreateHyperCloneSnapshotTask(String devSn, String lunId) {
        this.devSn = devSn;
        this.lunId = lunId;
    }

    @Override
    public Snapshot call() {
        Snapshot snapshot = new Snapshot();
        snapshot.setSnapshotName(DrmStorageUtil.generateRecoverySnapshotName((String)this.lunId));
        ArrayList<String> lunIds = new ArrayList<String>();
        lunIds.add(this.lunId);
        Snapshot result = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.devSn).createSnapshot(this.devSn, lunIds, snapshot);
        logger.debug((Object)("create snapshot(devSn:" + this.devSn + ";lunId:" + this.lunId + ") result is " + result.getSnapshotId()));
        result.setSrcResourceId(Integer.valueOf(this.lunId));
        result.setSnapshotName(snapshot.getSnapshotName());
        return result;
    }
}

