/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.action;

import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.storage.protection.action.DeleteHyperCloneSnapshotTask;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DeleteHyperCloneSnapshotSubAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(DeleteHyperCloneSnapshotSubAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        String cloneSnapStr = (String)protectGroup.getProps().get("CLONE_SNAPSHOT");
        if (null == cloneSnapStr || cloneSnapStr.isEmpty()) {
            logger.debug((Object)"CLONE_SNAPSHOT is null.");
            return true;
        }
        JSONArray snaps = JSONArray.fromObject((Object)cloneSnapStr);
        if (snaps.isEmpty()) {
            logger.debug((Object)"there is no snap need to delete.");
            return true;
        }
        if (!this.deleteSnapshots(snaps)) {
            logger.error((Object)"delete snapshot error.");
            this.setDetail("lego.err.1073948679");
            return false;
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("CLONE_SNAPSHOT", "[]");
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), prop);
        return true;
    }

    private boolean deleteSnapshots(JSONArray snaps) {
        ArrayList<DeleteHyperCloneSnapshotTask> tasks = new ArrayList<DeleteHyperCloneSnapshotTask>();
        for (int i = 0; i < snaps.size(); ++i) {
            JSONObject snap = snaps.getJSONObject(i);
            DeleteHyperCloneSnapshotTask task = new DeleteHyperCloneSnapshotTask(snap.getString("devSn"), snap.getString("snapshotId"));
            tasks.add(task);
        }
        List resultList = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)0, (int)20);
        if (null == resultList || resultList.size() != tasks.size()) {
            logger.error((Object)"delete snapshot has error.");
            return false;
        }
        if (resultList.contains(Boolean.FALSE)) {
            logger.error((Object)"delete snapshot has not success.");
            return false;
        }
        return true;
    }
}

