/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IRealTimeReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCloneManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCloneManager;
import com.huawei.ism.drm.storage.protection.action.DeleteHyperCloneSnapshotTask;
import com.huawei.ism.drm.storage.protection.action.RefreshHyperClonePairsTask;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class SplitMultiHyperCloneSubAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(SplitMultiHyperCloneSubAction.class);

    public boolean doExecute(ActionContext context) {
        logger.debug((Object)"inter SplitMultiHyperCloneSubAction.");
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        boolean isNeedSnapshot = this.isNeedSnpshot(protectGroup);
        logger.debug((Object)(protectGroup.getName() + " NeedSnapshot is " + isNeedSnapshot));
        Boolean syncTimeout = (Boolean)context.getObject("SYNC_CLONE_TIMEOUT");
        if (null != syncTimeout && syncTimeout.booleanValue()) {
            logger.error((Object)"sync has not complete.");
            this.setDetail("lego.err.1073948230");
            return isNeedSnapshot;
        }
        CloneConsistentGroup cloneCG = (CloneConsistentGroup)context.getObject("CloneCG");
        if (null == cloneCG) {
            logger.error((Object)"clone is null.");
            this.setDetail("lego.err.1073947393");
            return false;
        }
        HyperClonePair clonePair = (HyperClonePair)CommonUtil.getFirstElement((Collection)cloneCG.getPairs());
        if (null == clonePair) {
            logger.error((Object)"can not get clone pair in CloneCG.");
            this.setDetail("lego.err.1073947393");
            return false;
        }
        String deviceSn = clonePair.getDeviceSn();
        StorageHyperCloneManagerProxy mgrProxy = StorageHyperCloneManagerProxy.getInstance();
        IStorageHyperCloneManager hyperCloneMgr = mgrProxy.getStorageHyperCloneManager(deviceSn);
        if (hyperCloneMgr == null) {
            logger.error((Object)("IStorageHyperCloneManager is null.deviceSn:" + deviceSn));
            this.setDetail("lego.err.1073947394");
            return false;
        }
        ArrayList<String> pairIds = new ArrayList<String>();
        Set<HyperClonePair> hyperClonePairSet = this.groupHyperClonePairs(context);
        if (!VerifyUtil.isEmpty(hyperClonePairSet)) {
            for (HyperClonePair pair : hyperClonePairSet) {
                pairIds.add(pair.getPairId());
            }
        }
        OperationResult operationResult = hyperCloneMgr.splitMultiHyperClone(deviceSn, pairIds);
        ExecutionService.submitTask((Runnable)new RefreshHyperClonePairsTask(cloneCG.getPairs()));
        if (!operationResult.isSuccess()) {
            this.setDetail("lego.err." + operationResult.getErrorCode());
            if (operationResult.getArgs() != null && operationResult.getArgs().length != 0) {
                this.setDetailParams(this.constructParams(operationResult.getArgs()));
            }
            return isNeedSnapshot;
        }
        IRealTimeReplicaBuilder replicaBuilder = ExecuteReplicaManager.getInstance().getRealTimeReplicaBuilder(protectGroup);
        if (null != replicaBuilder) {
            ProtectGroupReplica pgReplica = replicaBuilder.buildReplica(context);
            if (null == pgReplica) {
                logger.error((Object)("there is no replica in pg(" + protectGroup.getName() + ")"));
                throw new LegoCheckedException(-1L);
            }
            context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
        }
        context.addObject("CLONE_SPLIT_RESULT", (Object)Boolean.TRUE);
        return true;
    }

    protected Set<HyperClonePair> groupHyperClonePairs(ActionContext context) {
        CloneConsistentGroup cloneCG = (CloneConsistentGroup)context.getObject("CloneCG");
        return cloneCG.getPairs();
    }

    public void callBack(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        String cloneSnapStr = (String)protectGroup.getProps().get("CLONE_SNAPSHOT");
        if (null == cloneSnapStr || cloneSnapStr.isEmpty()) {
            return;
        }
        JSONArray snaps = JSONArray.fromObject((Object)cloneSnapStr);
        ArrayList<DeleteHyperCloneSnapshotTask> tasks = new ArrayList<DeleteHyperCloneSnapshotTask>();
        for (int i = 0; i < snaps.size(); ++i) {
            JSONObject snap = snaps.getJSONObject(i);
            DeleteHyperCloneSnapshotTask task = new DeleteHyperCloneSnapshotTask(snap.getString("devSn"), snap.getString("snapshotId"));
            tasks.add(task);
        }
        if (tasks.isEmpty()) {
            return;
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("CLONE_SNAPSHOT", "[]");
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), prop);
        ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)0, (int)20);
    }
}

