/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.action;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCloneManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCloneManager;
import com.huawei.ism.drm.storage.sdk.model.HyperClone;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Date;

public class SynchronizeHyperCloneSubAction
extends AbstractBaseProtectAction {
    private static final long MINITE_TIME_MILLIS = 60000L;
    private static final long DEFAULT_WAIT_TIME = 0x6DDD00L;
    private static final String SYNC_PROGRESS_MSG_KEY = "com.huawei.ism.drm.sync.progress.msg";
    private static final String SYNC_COMPLETE_MSG_KEY = "com.huawei.ism.drm.sync.complete.msg";
    private static final String WAIT_CLONE_SPLIT = "com.huawei.ism.drm.wait.split.msg";
    private static final Log logger = LogFactory.getInstance(SynchronizeHyperCloneSubAction.class);
    private HyperClonePair hyperClonePair;

    public HyperClonePair getHyperClonePair() {
        return this.hyperClonePair;
    }

    public void setHyperClonePair(HyperClonePair hyperClonePair) {
        this.hyperClonePair = hyperClonePair;
    }

    public void preExcute(ActionContext context) {
        this.setNameParams(this.constructParams(new String[]{this.hyperClonePair.getPairId(), this.hyperClonePair.getDeviceSn()}));
    }

    public boolean doExecute(ActionContext context) {
        logger.debug((Object)"inter SynchronizeHyperCloneSubAction doExecute");
        try {
            this.synchronizeHyperClonePair();
            this.checkSyncHyperClonePairResult(context);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            if (e.getParameters() != null && e.getParameters().length != 0) {
                this.setDetailParams(this.constructParams(e.getParameters()));
            }
            return false;
        }
        return true;
    }

    private void synchronizeHyperClonePair() {
        StorageHyperCloneManagerProxy mgrProxy = StorageHyperCloneManagerProxy.getInstance();
        IStorageHyperCloneManager hyperCloneMgr = mgrProxy.getStorageHyperCloneManager(this.hyperClonePair.getDeviceSn());
        if (hyperCloneMgr == null) {
            logger.error((Object)("IStorageHyperCloneManager is null.deviceSn:" + this.hyperClonePair.getDeviceSn()));
            throw new LegoCheckedException(-1L);
        }
        HyperClone hyperClone = hyperCloneMgr.getHyperClone(this.hyperClonePair.getDeviceSn(), this.hyperClonePair.getSrcLunId());
        if (null == hyperClone) {
            logger.error((Object)("HyperClone is null. devSn is " + this.hyperClonePair.getDeviceSn() + " and srclunid is " + this.hyperClonePair.getSrcLunId()));
            throw new LegoCheckedException(-1L);
        }
        OperationResult operationResult = hyperCloneMgr.syncHyperClone(this.hyperClonePair.getDeviceSn(), hyperClone.getId(), this.hyperClonePair.getTgtLunId());
        if (!operationResult.isSuccess() && !String.valueOf(1077950238L).equals(operationResult.getErrorCode())) {
            throw new LegoCheckedException(NumberUtil.convertToLong((Object)operationResult.getErrorCode(), (long)1073947393L).longValue(), operationResult.getArgs());
        }
    }

    private void checkSyncHyperClonePairResult(ActionContext context) {
        JSONObject prJsonObj;
        long startTime = System.currentTimeMillis();
        long pgStartTime = null != context.getObject("PG_EXECUTE_START_TIME") ? ((Date)context.getObject("PG_EXECUTE_START_TIME")).getTime() : startTime;
        long splitTime = startTime + 0x6DDD00L;
        boolean isConfigSplitTime = false;
        logger.debug((Object)("start time is " + new Date(pgStartTime)));
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        PolicyTemplate template = protectGroup.getTemplate();
        String cloneSplitCofig = (String)template.getProps().get("CLONE_SPLIT");
        logger.debug((Object)("CLONE_SPLIT setting is " + cloneSplitCofig));
        if (null != cloneSplitCofig && !cloneSplitCofig.isEmpty() && (prJsonObj = JSONObject.fromObject((Object)cloneSplitCofig)).containsKey((Object)"split_delay_time")) {
            try {
                int splitDelayTime = Integer.parseInt(prJsonObj.getString("split_delay_time"));
                splitTime = pgStartTime + (long)splitDelayTime * 60000L;
                isConfigSplitTime = true;
            }
            catch (NumberFormatException e) {
                logger.error((Object)"split_delay_time is error", (Throwable)e);
            }
        }
        logger.debug((Object)("isConfigSplitTime is " + isConfigSplitTime));
        boolean synComplete = false;
        while (true) {
            CommUtil.pauseThread((long)5000L);
            long curTime = System.currentTimeMillis();
            if (!synComplete) {
                synComplete = this.isCompletedSyncHyperClonePair();
            }
            if (!isConfigSplitTime && synComplete || curTime >= splitTime) {
                if (synComplete) break;
                logger.debug((Object)("sync is not complite and time is out:" + protectGroup.getName()));
                context.addObject("SYNC_CLONE_TIMEOUT", (Object)Boolean.TRUE);
                break;
            }
            if (!isConfigSplitTime || !synComplete || WAIT_CLONE_SPLIT.equals(this.getDetail())) continue;
            this.setDetail(WAIT_CLONE_SPLIT);
        }
    }

    private boolean isCompletedSyncHyperClonePair() {
        StorageHyperCloneManagerProxy mgrProxy = StorageHyperCloneManagerProxy.getInstance();
        IStorageHyperCloneManager hyperCloneMgr = mgrProxy.getStorageHyperCloneManager(this.hyperClonePair.getDeviceSn());
        if (hyperCloneMgr == null) {
            logger.error((Object)("hyperCloneMgr is null.deviceSn:" + this.hyperClonePair.getDeviceSn()));
            throw new LegoCheckedException(1073947394L);
        }
        HyperCloneTargetLun targetLun = hyperCloneMgr.getTargetLun(this.hyperClonePair.getDeviceSn(), this.hyperClonePair.getSrcLunId(), this.hyperClonePair.getTgtLunId());
        if (null == targetLun) {
            return false;
        }
        DrmStorageUtil.saveOrUpdateHyperCloneTargetLun((String)this.hyperClonePair.getDeviceSn(), (HyperCloneTargetLun)targetLun);
        if (String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(targetLun.getRunningState()) && 5 == targetLun.getDataStatus()) {
            this.setDetail(SYNC_COMPLETE_MSG_KEY);
            return true;
        }
        if (!String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(targetLun.getRunningState()) && !String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue()).equals(targetLun.getRunningState())) {
            throw new LegoCheckedException(1073948231L);
        }
        this.setDetail(SYNC_PROGRESS_MSG_KEY);
        this.setDetailParams(targetLun.getProcess() + "%");
        return false;
    }
}

