/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.bean;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class CloneConsistentGroupCache {
    private final List<CloneConsistentGroup> cache = new ArrayList<CloneConsistentGroup>();
    private final ProtectGroup protectGroup;

    public CloneConsistentGroupCache(ProtectGroup protectGroup) {
        this.protectGroup = protectGroup;
        this.initCloneConsistentGroupCache();
    }

    public synchronized List<CloneConsistentGroup> getCloneConsistentGroups() {
        return Collections.synchronizedList(this.cache);
    }

    public synchronized void addCloneConsistentGroup(CloneConsistentGroup cloneConsistentGroup) {
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)cloneConsistentGroup);
        this.cache.add(cloneConsistentGroup);
    }

    public synchronized void deleteCloneConsistentGroup(CloneConsistentGroup cloneConsistentGroup) {
        CloneConsistentGroup cloneCG = this.getCloneConsistentGroup(cloneConsistentGroup.getCgId());
        if (null == cloneCG) {
            return;
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)cloneCG);
        this.cache.remove(cloneCG);
    }

    public synchronized void deleteCloneConsistentGroup(String pgReplicaId) {
        Iterator<CloneConsistentGroup> cloneGroupIter = this.cache.iterator();
        while (cloneGroupIter.hasNext()) {
            CloneConsistentGroup cloneGroup = cloneGroupIter.next();
            if (!pgReplicaId.equals(cloneGroup.getPgReplicaId())) continue;
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)cloneGroup);
            cloneGroupIter.remove();
        }
    }

    public synchronized void addHyperClonePair(CloneConsistentGroup cloneConsistentGroup, HyperClonePair clonePair) {
        CloneConsistentGroup cloneCG = this.getCloneConsistentGroup(cloneConsistentGroup.getCgId());
        if (null == cloneCG) {
            return;
        }
        HyperClonePair oldHyperClonePair = this.getHyperClonePairBySrcLunId(clonePair.getDeviceSn(), clonePair.getSrcLunId(), cloneCG);
        if (null != oldHyperClonePair) {
            oldHyperClonePair.setTgtLunId(clonePair.getTgtLunId());
            oldHyperClonePair.setPairId(clonePair.getPairId());
        } else {
            cloneCG.getPairs().add(clonePair);
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)cloneCG);
    }

    public synchronized void deleteHyperClonePair(CloneConsistentGroup cloneConsistentGroup, HyperClonePair hyperClonePair) {
        if (VerifyUtil.isEmpty((Collection)cloneConsistentGroup.getPairs())) {
            return;
        }
        Iterator iter = cloneConsistentGroup.getPairs().iterator();
        while (iter.hasNext()) {
            HyperClonePair clonePair = (HyperClonePair)iter.next();
            if (!clonePair.getDeviceSn().equals(hyperClonePair.getDeviceSn()) || !clonePair.getSrcLunId().equals(hyperClonePair.getSrcLunId()) || !clonePair.getTgtLunId().equals(hyperClonePair.getTgtLunId()) || !clonePair.getPairId().equals(hyperClonePair.getPairId())) continue;
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)clonePair);
            iter.remove();
            iter = cloneConsistentGroup.getPairs().iterator();
        }
    }

    private CloneConsistentGroup getCloneConsistentGroup(String cloneCGId) {
        for (CloneConsistentGroup cloneCG : this.cache) {
            if (!cloneCG.getCgId().equals(cloneCGId)) continue;
            return cloneCG;
        }
        return null;
    }

    private HyperClonePair getHyperClonePairBySrcLunId(String deviceSn, String srcLunId, CloneConsistentGroup cloneConsistentGroup) {
        if (VerifyUtil.isEmpty((Collection)cloneConsistentGroup.getPairs())) {
            return null;
        }
        for (HyperClonePair hyperClonePair : cloneConsistentGroup.getPairs()) {
            if (!hyperClonePair.getDeviceSn().equals(deviceSn) || !hyperClonePair.getSrcLunId().equals(srcLunId)) continue;
            return hyperClonePair;
        }
        return null;
    }

    private void initCloneConsistentGroupCache() {
        String queryHQL = "from CloneConsistentGroup where pgId=?";
        HibernateTemplate hibernateTpl = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        List cloneCGs = hibernateTpl.find(queryHQL, new Object[]{this.protectGroup.getUuid()});
        for (Object object : cloneCGs) {
            this.cache.add((CloneConsistentGroup)object);
        }
    }
}

