/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.calculator;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.calculator.sdk.service.IRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.protection.calculator.ArrayHyperMetroAsynReplicationCalculator;
import com.huawei.ism.drm.storage.protection.calculator.ArrayHyperMetroRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayAsynReplicationHyperMetroCalculator
extends BaseRecoveryPointObjectiveCalculator {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroAsynReplicationCalculator.class);
    private static final String REMOTE_SITE = "REMOTE_SITE";
    private IRecoveryPointObjectiveCalculator replicationCalculator;

    public IRecoveryPointObjectiveCalculator getReplicationCalculator() {
        return this.replicationCalculator;
    }

    public void setReplicationCalculator(IRecoveryPointObjectiveCalculator replicationCalculator) {
        this.replicationCalculator = replicationCalculator;
    }

    public List<String> getTypes() {
        return Arrays.asList("20", "24");
    }

    public Map<String, Object> calculate(RPOContext context) {
        HashMap<String, Object> rpoResults = new HashMap<String, Object>();
        if (this.replicationCalculator == null) {
            logger.error((Object)"ReplicationCalculator is null");
            return rpoResults;
        }
        JSONArray rpoJsonArray = new JSONArray();
        this.setRemoteSite(context);
        Map arrayResults = this.replicationCalculator.calculate(context);
        String arrayStr = String.valueOf(arrayResults.get("RPO_ITEM_KEY"));
        JSONArray arrayRpoJsonArray = JSONArray.fromObject((Object)arrayStr);
        Map<String, Object> hyperMetroResults = this.calculateHyperMetro(context);
        String hyperMetroRpoStr = String.valueOf(hyperMetroResults.get("RPO_ITEM_KEY"));
        JSONArray hyperMetorRpoJsonArray = JSONArray.fromObject((Object)hyperMetroRpoStr);
        rpoJsonArray.addAll((Collection)hyperMetorRpoJsonArray);
        rpoJsonArray.addAll((Collection)arrayRpoJsonArray);
        rpoResults.put("RPO_ITEM_KEY", rpoJsonArray.toString());
        return rpoResults;
    }

    protected Map<String, Object> calculateHyperMetro(RPOContext context) {
        ArrayHyperMetroProxy hyperMetroCalculator = new ArrayHyperMetroProxy();
        return hyperMetroCalculator.calculate(context);
    }

    private void setRemoteSite(RPOContext context) {
        Object pgobject = context.getObject("PG_ENTITY");
        if (pgobject == null) {
            return;
        }
        ProtectGroup protectGroup = (ProtectGroup)pgobject;
        Set replicaList = protectGroup.getReplicaList();
        Iterator replicaIterator = replicaList.iterator();
        if (!replicaIterator.hasNext()) {
            logger.error((Object)"replicaList is empty!");
            return;
        }
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)replicaIterator.next();
        String recoverySiteId = pgReplica.getRecoverySite();
        Site remoteSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
        context.addObject(REMOTE_SITE, (Object)remoteSite);
    }

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        return null;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        return null;
    }

    static class ArrayHyperMetroProxy
    extends ArrayHyperMetroRecoveryPointObjectiveCalculator {
        ArrayHyperMetroProxy() {
        }

        @Override
        protected String randomALunWwn(ProtectGroup protectGroup) {
            String errMsg = "pgName:" + protectGroup.getName();
            Set replicaList = protectGroup.getReplicaList();
            if (VerifyUtil.isEmpty((Collection)replicaList)) {
                logger.error((Object)("replicaList is empty!" + errMsg));
                return null;
            }
            ProtectGroupReplica pgReplica = (ProtectGroupReplica)replicaList.iterator().next();
            Set poReplicas = pgReplica.getReplicas();
            if (VerifyUtil.isEmpty((Collection)poReplicas)) {
                logger.error((Object)("poReplicas is empty!" + errMsg));
                return null;
            }
            ProtectObjectReplica poReplica = (ProtectObjectReplica)poReplicas.iterator().next();
            Set storageInfoSet = poReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)storageInfoSet)) {
                logger.error((Object)("storageInfoSet is empty!" + errMsg));
                return null;
            }
            RelicaStorageInfo storageInfoReplica = (RelicaStorageInfo)storageInfoSet.iterator().next();
            String storageId = storageInfoReplica.getStorageId();
            ArrayList<String> resourceIdList = new ArrayList<String>();
            resourceIdList.add(storageId);
            String remoteDeviceSn = storageInfoReplica.getStorageProviderSN();
            List<Lun> lunList = this.getLunList(remoteDeviceSn, resourceIdList);
            if (!VerifyUtil.isEmpty(lunList)) {
                Lun lun = lunList.get(0);
                return lun.getWwn();
            }
            return null;
        }

        @Override
        protected Set<String> getAllWwns(ProtectGroup protectGroup) {
            String errMsg = "pgName:" + protectGroup.getName();
            HashSet<String> wwnSet = new HashSet<String>();
            String remoteDeviceSn = null;
            ArrayList<String> resourceIdList = new ArrayList<String>();
            Set replicaList = protectGroup.getReplicaList();
            if (VerifyUtil.isEmpty((Collection)replicaList)) {
                logger.error((Object)("replicaList is empty!" + errMsg));
                return wwnSet;
            }
            for (ProtectGroupReplica pgReplica : replicaList) {
                try {
                    remoteDeviceSn = this.getWwnFromPgReplica(errMsg, resourceIdList, pgReplica);
                }
                catch (LegoCheckedException e) {
                    logger.error((Object)"getWwnFromPgReplica error!", (Throwable)e);
                    return wwnSet;
                }
            }
            if (VerifyUtil.isEmpty(remoteDeviceSn) || VerifyUtil.isEmpty(resourceIdList)) {
                logger.error((Object)("remoteDeviceSn is empty! or resourceIdList is empty!remoteDeviceSn:" + remoteDeviceSn + ", resourceIdList:" + resourceIdList));
                return wwnSet;
            }
            List<Lun> lunList = this.getLunList(remoteDeviceSn, resourceIdList);
            if (!VerifyUtil.isEmpty(lunList)) {
                for (Lun lun : lunList) {
                    wwnSet.add(lun.getWwn());
                }
            }
            return wwnSet;
        }

        private List<Lun> getLunList(String remoteDeviceSn, List<String> resourceIdList) {
            List lunList = null;
            try {
                lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(remoteDeviceSn, resourceIdList, Lun.class);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("query the storageResources error!remoteDeviceSn:" + remoteDeviceSn + ",resourceIdList:" + resourceIdList), (Throwable)e);
            }
            return lunList;
        }

        private String getWwnFromPgReplica(String errMsg, List<String> resourceIdList, ProtectGroupReplica pgReplica) {
            String remoteDeviceSn = null;
            Set poReplicaSet = pgReplica.getReplicas();
            if (VerifyUtil.isEmpty((Collection)poReplicaSet)) {
                logger.error((Object)("poReplicaSet is empty!" + errMsg));
                throw new LegoCheckedException(1073947393L);
            }
            for (ProtectObjectReplica poReplica : poReplicaSet) {
                Set storageInfoReplicaSet = poReplica.getStorageInfos();
                if (VerifyUtil.isEmpty((Collection)storageInfoReplicaSet)) {
                    logger.error((Object)("storageInfoReplicaSet is empty!" + errMsg));
                    throw new LegoCheckedException(1073947393L);
                }
                for (RelicaStorageInfo storageInfoReplica : storageInfoReplicaSet) {
                    remoteDeviceSn = storageInfoReplica.getStorageProviderSN();
                    resourceIdList.add(storageInfoReplica.getStorageId());
                }
            }
            return remoteDeviceSn;
        }
    }
}

