/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.interceptor.lun.group;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.storage.protection.interceptor.HandlerContext;
import com.huawei.ism.drm.storage.protection.interceptor.IReplicaBuildInterceptorHandler;
import com.huawei.ism.drm.storage.protection.interceptor.lun.group.LunConsistentGroupFactory;
import com.huawei.lego.cbb.resource.rollback.DefaultResourceRollbackTask;
import com.huawei.lego.cbb.resource.rollback.IResourceRollbackTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;

public class LunConsistencyGroupHandler
implements IReplicaBuildInterceptorHandler {
    @Override
    public void handle(HandlerContext context) {
        LunConsistentGroupFactory lunCgFactory = LunConsistentGroupFactory.newFactory((IResourceRollbackTask)context.getTask());
        lunCgFactory.createLunConsistentGroup(context.getProtectGroup());
    }

    @Override
    public void addSchedule(ProtectGroup protectGroup, Schedule schedule) {
        if (null == schedule || schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue()) {
            return;
        }
        if (schedule.getPeriodType() == 5) {
            return;
        }
        DefaultResourceRollbackTask task = new DefaultResourceRollbackTask();
        try {
            LunConsistentGroupFactory.newFactory((IResourceRollbackTask)task).createLunConsistentGroup(protectGroup, schedule);
        }
        catch (LegoCheckedException e) {
            task.execute();
            throw e;
        }
    }

    @Override
    public void updateSchedule(ProtectGroup protectGroup, Schedule schedule) {
        if (null == schedule || schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue()) {
            return;
        }
        if (schedule.getPeriodType() == 5) {
            return;
        }
        DefaultResourceRollbackTask task = new DefaultResourceRollbackTask();
        try {
            LunConsistentGroupFactory.newFactory((IResourceRollbackTask)task).createLunConsistentGroup(protectGroup, schedule);
        }
        catch (LegoCheckedException e) {
            task.execute();
            throw e;
        }
    }
}

