/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.protection.path.builder.ArrayHyperMetroProtectionPath;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperMetroVaultProtectionPath
extends ArrayHyperMetroProtectionPath {
    private static final String VSTOREPAIRID = "VSTOREPAIRID";
    private static final String SRC_DEV_SN = "SRC_DEV_SN";
    private static final String OTHER_SITE_DEV_SN = "OTHER_SITE_DEV_SN";
    private static final String HYPER_VAULT_LIST = "HYPER_VAULT_LIST";
    private static final String HYPER_METRO_LIST = "HYPER_METRO_LIST";
    private static final String DR_REOURCE = "DR_REOURCE";
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroVaultProtectionPath.class);

    @Override
    public int getPolicyTemplateType() {
        logger.debug((Object)"PolicyTemplateType:ARRAY_HYPERMETRO_VAULT");
        return 28;
    }

    @Override
    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> nasFiles, BatchOperation batchOperation) {
        logger.debug((Object)"to buildPath[ArrayHyperMetroVaultProtectionPath] start..");
        try {
            ExecutionContext context = this.init(nasFiles, batchOperation);
            ProtectionPath siteProtectionPath = this.buildSiteProtectionPath(protectgroup, context);
            ProtectionPath storageResProtectionPath = this.buildStorageResProtectionPath(protectgroup, context);
            return this.buildProtectionPathData(siteProtectionPath, storageResProtectionPath, context, protectgroup);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("to buildPath[ArrayHyperMetroVaultProtectionPath] error.msg : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            batchOperation.setErrorCode(e.getErrorCode());
            return new ProtectionPathData();
        }
    }

    private ProtectionPath buildStorageResProtectionPath(ProtectGroup protectgroup, ExecutionContext context) {
        logger.debug((Object)"start build storage resource protection path...", 90160758784000L);
        ProtectionPath protectionpath = new ProtectionPath();
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        rdPathDetails.add(this.getAllRDPath(protectgroup, context));
        protectionpath.setPathDetails(rdPathDetails);
        logger.debug((Object)"end build storage resource protection path...", 90160758784000L);
        return protectionpath;
    }

    private String getAllRDPath(ProtectGroup protectgroup, ExecutionContext context) {
        ArrayList<String> wwns = new ArrayList<String>(RecoveryProcessUtil.getAllWwn((Set)protectgroup.getPolist()));
        List<ProtectObjectStorageInfo> storageResources = this.getPgNasInfos(protectgroup);
        String devSN = ((ProtectObjectStorageInfo)CommonUtil.getFirstElement(storageResources)).getResourceProviderSN();
        String srcDevSn = (String)context.getAttribute(SRC_DEV_SN);
        String otherDevSn = (String)context.getAttribute(OTHER_SITE_DEV_SN);
        List<NasFileSystem> srcNasFileList = null;
        List<NasFileSystem> otherNasFileList = null;
        if (devSN.equals(srcDevSn)) {
            srcNasFileList = this.getIStorageResourceService().getStorageResources(devSN, wwns, NasFileSystem.class);
            otherNasFileList = this.getHyperMetroOtherSiteNasFileSystemList(srcDevSn, otherDevSn, wwns, context);
        } else if (devSN.equals(otherDevSn)) {
            otherNasFileList = this.getIStorageResourceService().getStorageResources(devSN, wwns, NasFileSystem.class);
            srcNasFileList = this.getHyperMetroOtherSiteNasFileSystemList(otherDevSn, srcDevSn, wwns, context);
        }
        this.checkEmpty(srcNasFileList, "srcNasFileList getAllPath");
        this.checkEmpty(otherNasFileList, "otherNasFileList getAllPath");
        List<NasFileSystem> targetNasFileList = this.getVaultRemoteNasFileSystemList(srcDevSn, srcNasFileList, context);
        this.checkEmpty(targetNasFileList, "targetNasFileList getAllPath");
        StringBuilder resourceProtectionPathStr = new StringBuilder();
        for (NasFileSystem otherNas : otherNasFileList) {
            this.getNasFilePath(resourceProtectionPathStr, otherNas, context, srcNasFileList, targetNasFileList);
        }
        return resourceProtectionPathStr.toString();
    }

    private void getNasFilePath(StringBuilder resourceProtectionPathStr, NasFileSystem otherNas, ExecutionContext context, List<NasFileSystem> srcNasFileList, List<NasFileSystem> targetNasFileList) {
        DrResource otherDrReource = this.getDrResouceFromContext(context, otherNas.getDevSn());
        resourceProtectionPathStr.append(otherNas.getName()).append("(").append(otherDrReource == null ? "" : otherDrReource.getIpAddress()).append(")");
        resourceProtectionPathStr.append(" -- ");
        NasFileSystem srcNas = this.getVaultLoaclNas(otherNas, context, srcNasFileList);
        if (VerifyUtil.isEmpty((Object)srcNas)) {
            resourceProtectionPathStr.append(";\n");
            return;
        }
        DrResource srcDrReource = this.getDrResouceFromContext(context, srcNas.getDevSn());
        resourceProtectionPathStr.append(srcNas.getName()).append("(").append(srcDrReource == null ? "" : srcDrReource.getIpAddress()).append(")");
        resourceProtectionPathStr.append(" --> ");
        NasFileSystem targetNas = this.getVaultRemoteNas(srcNas, context, targetNasFileList);
        if (VerifyUtil.isEmpty((Object)targetNas)) {
            resourceProtectionPathStr.append(";\n");
            return;
        }
        DrResource targetDrReource = this.getDrResouceFromContext(context, targetNas.getDevSn());
        resourceProtectionPathStr.append(targetNas.getName()).append("(").append(targetDrReource == null ? "" : targetDrReource.getIpAddress()).append(")");
        resourceProtectionPathStr.append(";\n");
    }

    private DrResource getDrResouceFromContext(ExecutionContext context, String devSn) {
        DrResource drResource = (DrResource)context.getAttribute(DR_REOURCE + devSn, DrResource.class);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            drResource = this.getStorageBySn(devSn);
            context.setAttribute(DR_REOURCE + devSn, (Object)drResource);
        }
        return drResource;
    }

    private NasFileSystem getVaultRemoteNas(NasFileSystem srcNas, ExecutionContext context, List<NasFileSystem> targetNasFileList) {
        List hyperVaultList = (List)context.getAttribute(HYPER_VAULT_LIST);
        String targetId = null;
        for (HyperVault hyperVault : hyperVaultList) {
            if (!hyperVault.getLocalResourceId().equals(srcNas.getResourceId())) continue;
            targetId = hyperVault.getRemoteResourceId();
            break;
        }
        for (NasFileSystem nasFileSystem : targetNasFileList) {
            if (!nasFileSystem.getResourceId().equals(targetId)) continue;
            return nasFileSystem;
        }
        return null;
    }

    private NasFileSystem getVaultLoaclNas(NasFileSystem otherNas, ExecutionContext context, List<NasFileSystem> srcNasFileList) {
        List hyperMetroPairList = (List)context.getAttribute(HYPER_METRO_LIST);
        String otherResourceID = null;
        for (HyperMetroPair pair : hyperMetroPairList) {
            if (pair.getDevSn().equals(otherNas.getDevSn())) {
                if (!otherNas.getResourceId().equals(pair.getLocalObjId())) continue;
                otherResourceID = pair.getRemoteObjId();
                break;
            }
            if (!otherNas.getResourceId().equals(pair.getRemoteObjId())) continue;
            otherResourceID = pair.getLocalObjId();
            break;
        }
        for (NasFileSystem nasFileSystem : srcNasFileList) {
            if (!nasFileSystem.getResourceId().equals(otherResourceID)) continue;
            return nasFileSystem;
        }
        return null;
    }

    private List<NasFileSystem> getVaultRemoteNasFileSystemList(String srcDevSn, List<NasFileSystem> srcNasList, ExecutionContext context) {
        ArrayList<String> ids = new ArrayList<String>();
        for (NasFileSystem nasFileSystem : srcNasList) {
            ids.add(nasFileSystem.getResourceId());
        }
        List vaultList = this.getHyperVaultMgr(srcDevSn).queryHyperVaultListByResourceIds(srcDevSn, ids);
        this.checkEmpty(vaultList, "getVaultRemoteNasFileSystemList vaultList");
        ArrayList<String> remoteSiteIds = new ArrayList<String>();
        for (HyperVault vault : vaultList) {
            remoteSiteIds.add(vault.getRemoteResourceId());
        }
        context.setAttribute(HYPER_VAULT_LIST, (Object)vaultList);
        return this.getIStorageResourceService().getStorageResources(((HyperVault)vaultList.get(0)).getRemoteDeviceSn(), remoteSiteIds, NasFileSystem.class);
    }

    private List<NasFileSystem> getHyperMetroOtherSiteNasFileSystemList(String srcDevSn, String otherDevSn, List<String> ids, ExecutionContext context) {
        List hyperMetroPairList = this.getIStorageResourceService().getHyperMetroPairByFileSystems(srcDevSn, ids, null);
        this.checkEmpty(hyperMetroPairList, "hyperMetroPairList getHyperMetroOtherSiteNasFileSystemList");
        ArrayList<String> otherSiteIds = new ArrayList<String>();
        for (HyperMetroPair hyperMetroPair : hyperMetroPairList) {
            otherSiteIds.add(hyperMetroPair.getRemoteObjId());
        }
        context.setAttribute(HYPER_METRO_LIST, (Object)hyperMetroPairList);
        return this.getIStorageResourceService().getStorageResources(otherDevSn, otherSiteIds, NasFileSystem.class);
    }

    private ProtectionPath buildSiteProtectionPath(ProtectGroup protectgroup, ExecutionContext context) {
        logger.debug((Object)"start build site protection path...", 90160758784000L);
        ProtectionPath siteProtectionPath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        sitePathDetails.add(this.getSiteRelationStr(protectgroup, context));
        siteProtectionPath.setPathDetails(sitePathDetails);
        logger.debug((Object)"end build site protection path...", 90160758784000L);
        return siteProtectionPath;
    }

    protected String getSiteRelationStr(ProtectGroup protectgroup, ExecutionContext context) {
        StringBuilder siteRelationStr = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("pgname:" + protectgroup.getName());
        BatchOperation batchOperation = this.getBatchOperation(context);
        try {
            String otherDevSn;
            String srcDevSn;
            HyperVault hyperVault;
            String vStorePairId = this.getVstorePairIdByPg(protectgroup);
            if (!VerifyUtil.isEmpty((String)vStorePairId)) {
                List<VstoreHyperMetroPair> vstoreHyperMetroPairList = this.getVstoreHyperPairList(vStorePairId);
                List<ProtectObjectStorageInfo> storageInfos = this.getPgNasInfos(protectgroup);
                this.checkEmpty(storageInfos, "storageInfos");
                NasFileSystem fileSystem = this.getRandomNasFileSytem(storageInfos);
                this.checkEmpty(fileSystem, "fileSystem");
                hyperVault = this.getHyperVaultMgr(fileSystem.getDevSn()).queryHyperVaultByResourceId(fileSystem.getDevSn(), fileSystem.getResourceId());
                srcDevSn = null;
                otherDevSn = null;
                if (hyperVault == null) {
                    otherDevSn = fileSystem.getDevSn();
                    srcDevSn = this.getOtherSiteDevSn(vstoreHyperMetroPairList, otherDevSn);
                    this.checkEmpty(srcDevSn, "can find the other site sn. the src sn:" + srcDevSn);
                    hyperVault = this.getOtherSiteHyperVault(vStorePairId, fileSystem.getResourceId(), srcDevSn);
                    this.checkEmpty(hyperVault, "check site,hyperVault is empty");
                } else {
                    srcDevSn = fileSystem.getDevSn();
                    otherDevSn = this.getOtherSiteDevSn(vstoreHyperMetroPairList, srcDevSn);
                }
            } else {
                logger.error((Object)("protectGroup get vstorePairId is NULL. PGUUID:" + protectgroup.getUuid()));
                batchOperation.setErrorCode(2117645L);
                return "";
            }
            context.setAttribute(VSTOREPAIRID, (Object)vStorePairId);
            context.setAttribute(SRC_DEV_SN, (Object)srcDevSn);
            context.setAttribute(OTHER_SITE_DEV_SN, (Object)otherDevSn);
            Site otherSite = this.getSiteByStorageSn(otherDevSn);
            siteRelationStr.append(otherSite == null ? "" : otherSite.getName()).append(" -- ");
            Site srcSite = this.getSiteByStorageSn(srcDevSn);
            siteRelationStr.append(srcSite == null ? "" : srcSite.getName());
            siteRelationStr.append(" --> ");
            Site targetSite = this.getSiteByStorageSn(hyperVault.getRemoteDeviceSn());
            siteRelationStr.append(targetSite == null ? "" : targetSite.getName());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("getRDPath error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            batchOperation.setErrorCode(e.getErrorCode());
            throw e;
        }
        return siteRelationStr.toString();
    }

    private HyperVault getOtherSiteHyperVault(String vStorePairId, String resourceId, String srcDevSn) {
        List<StorageResource> nasFileSystemList = this.getNasFileSystem(vStorePairId, resourceId, "remoteObjId");
        this.checkEmpty(nasFileSystemList, "find other site nasfileSystem which is the local vault failed:" + vStorePairId + " resourceID:" + resourceId + " sn:" + srcDevSn);
        for (StorageResource storageResource : nasFileSystemList) {
            if (!storageResource.getDevSn().equals(srcDevSn)) continue;
            return this.getHyperVaultMgr(storageResource.getDevSn()).queryHyperVaultByResourceId(storageResource.getDevSn(), storageResource.getResourceId());
        }
        logger.error((Object)("getOtherSiteHyperVault failed.dev:" + srcDevSn + " resourceId:" + resourceId + "  vstorePair:" + vStorePairId));
        throw new LegoCheckedException(1073947393L);
    }

    private String getOtherSiteDevSn(List<VstoreHyperMetroPair> pairs, String devSn) {
        for (VstoreHyperMetroPair pair : pairs) {
            String vstorePairDevSn = this.getVestorePairDevSn(pair);
            if (vstorePairDevSn.equals(devSn)) continue;
            return vstorePairDevSn;
        }
        logger.error((Object)("getOtherSiteDevSn for VstorePairList,dev:" + devSn));
        throw new LegoCheckedException(1073947393L);
    }

    private void checkEmpty(Object object, String desc) {
        if (VerifyUtil.isEmpty((Object)object)) {
            logger.error((Object)("checkEmpty " + desc), 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private IStorageHyperVaultManager getHyperVaultMgr(String devSn) {
        IStorageHyperVaultManager service = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (service == null) {
            logger.error((Object)("to get the IStorageHyperVaultManager failed! devSn:" + devSn));
            throw new LegoCheckedException(-1L);
        }
        return service;
    }

    private IStorageResourceService getIStorageResourceService() {
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        if (storageResourceService == null) {
            logger.error((Object)"to get the IStorageResourceService failed! ");
            throw new LegoCheckedException(-1L);
        }
        return storageResourceService;
    }

    private List<VstoreHyperMetroPair> getVstoreHyperPairList(String vStorePairId) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("vstorePairId", vStorePairId);
        List vstoreHyperMetroPairList = CommonDAOLocator.getMoDao().findMoBy(VstoreHyperMetroPair.class, condition);
        if (VerifyUtil.isEmpty((Collection)vstoreHyperMetroPairList) || vstoreHyperMetroPairList.size() != 2) {
            logger.error((Object)("vstoreHyperMetroPairList is empty or the size is not two!vStorePairId:" + vStorePairId), 90160758786897L);
            throw new LegoCheckedException(-1L);
        }
        return vstoreHyperMetroPairList;
    }

    private NasFileSystem getRandomNasFileSytem(List<ProtectObjectStorageInfo> storageInfos) {
        Iterator<ProtectObjectStorageInfo> iterator = storageInfos.iterator();
        if (iterator.hasNext()) {
            ProtectObjectStorageInfo info = iterator.next();
            return (NasFileSystem)((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getStorageResource(info.getResourceProviderSN(), info.getResourceId(), NasFileSystem.class);
        }
        logger.error((Object)"getRandomNasFileSytem failed");
        throw new LegoCheckedException(1073947393L);
    }

    private List<ProtectObjectStorageInfo> getPgNasInfos(ProtectGroup protectGroup) {
        ArrayList<ProtectObjectStorageInfo> nasIds = new ArrayList<ProtectObjectStorageInfo>();
        Set protectObjects = protectGroup.getPolist();
        if (!VerifyUtil.isEmpty((Collection)protectObjects)) {
            for (ProtectObject protectObject : protectObjects) {
                Set storageInfos = protectObject.getUsedStorageResourceSet();
                if (VerifyUtil.isEmpty((Collection)protectObjects)) continue;
                nasIds.addAll(storageInfos);
            }
        }
        return nasIds;
    }

    private ProtectionPathData buildProtectionPathData(ProtectionPath siteProtectionPath, ProtectionPath storageResProtectionPath, ExecutionContext context, ProtectGroup protectgroup) {
        ArrayList<ProtectionPath> pathList = new ArrayList<ProtectionPath>();
        pathList.add(siteProtectionPath);
        pathList.add(storageResProtectionPath);
        ProtectionPathData ppd = new ProtectionPathData(pathList);
        BatchOperation batchOperation = this.getBatchOperation(context);
        if (batchOperation.getErrorCode() != 0L) {
            logger.error((Object)("to buildProtectionPathData error..errorcode:" + batchOperation.getErrorCode() + ", pg name:" + protectgroup.getName()));
            batchOperation.setTargetName(protectgroup.getName());
            ppd.setOperation(batchOperation);
        }
        return ppd;
    }
}

