/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayHyperVaultBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperMetroVaultBuilder
extends ArrayHyperVaultBuilder {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroVaultBuilder.class);

    @Override
    public int getType() {
        return 28;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        this.check(protectGroup);
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " build replica." + this.getMsg(protectGroup)));
        ExecutionContext context = this.init(protectGroup);
        try {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
                this.disableAllExecutePolicyInDevice(context);
            } else {
                Set replicaList = protectGroup.getReplicaList();
                if (this.isExistNewResource((ProtectGroupReplica)replicaList.iterator().next(), this.getAllNewSourceIds(protectGroup, context))) {
                    logger.info((Object)"Set protectGroupReplica status invalid! Because New resource is added!");
                    for (ProtectGroupReplica pgr : replicaList) {
                        pgr.setStatus(DrmEnumDefine.ReplicaStatus.ERROR_STATUS.getValue());
                    }
                    this.disableAllExecutePolicyInDevice(context);
                }
            }
        }
        finally {
            logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " build replica." + this.getMsg(protectGroup)));
        }
    }

    private Set<String> getAllNewSourceIds(ProtectGroup protectGroup, ExecutionContext context) {
        List relationList = (List)context.getAttribute("protectionRelation", List.class);
        String srcDevSN = ((ProtectionRelation)relationList.get(0)).getSrcResourceProviderSn();
        String protectDevSn = this.getProtectStorageSN(protectGroup);
        Set<String> allPoSourceIds = this.getAllProtectSourceIds(protectGroup);
        if (!srcDevSN.equals(protectDevSn)) {
            IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
            List hyperMetroPairList = storageResourceService.getHyperMetroPairByFileSystems(protectDevSn, new ArrayList<String>(allPoSourceIds), null);
            allPoSourceIds.clear();
            for (HyperMetroPair hyperMetroPair : hyperMetroPairList) {
                if (VerifyUtil.isEmpty((String)hyperMetroPair.getVstorePairId())) continue;
                allPoSourceIds.add(hyperMetroPair.getRemoteObjId());
            }
        }
        List vaultList = this.getHyperVaultService(srcDevSN).queryHyperVaultListByResourceIds(srcDevSN, new ArrayList<String>(allPoSourceIds));
        HashSet<String> newIdSet = new HashSet<String>();
        if (!VerifyUtil.isEmpty((Collection)vaultList)) {
            for (HyperVault vault : vaultList) {
                if (VerifyUtil.isEmpty((String)vault.getRemoteResourceId())) {
                    logger.error((Object)"target sourceId is empty!", 90160758786989L);
                    throw new LegoCheckedException(1073948245L);
                }
                newIdSet.add(vault.getRemoteResourceId());
            }
        }
        return newIdSet;
    }

    private Set<String> getAllProtectSourceIds(ProtectGroup protectGroup) {
        HashSet<String> sourceIds = new HashSet<String>();
        Set polist = protectGroup.getPolist();
        this.checkEmpty(polist, "polist is empty! pgName : " + protectGroup.getName());
        for (ProtectObject po : polist) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            this.checkEmpty(usedStorageResourceSet, "usedStorageResourceSet is empty! pgName : " + protectGroup.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName());
            for (ProtectObjectStorageInfo storageInfo : usedStorageResourceSet) {
                sourceIds.add(storageInfo.getResourceId());
            }
        }
        return sourceIds;
    }

    private String getProtectStorageSN(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        this.checkEmpty(polist, "polist is empty! pgName : " + protectGroup.getName());
        ProtectObject po = (ProtectObject)polist.iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        this.checkEmpty(usedStorageResourceSet, "usedStorageResourceSet is empty! pgName : " + protectGroup.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName());
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi.getResourceProviderSN();
    }

    private void checkEmpty(Collection<?> collection, String msg) {
        if (VerifyUtil.isEmpty(collection)) {
            logger.error((Object)msg, 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean isExistNewResource(ProtectGroupReplica oldProtectGroupReplica, Set<String> newResourceIdSet) {
        Set protectObjectReplicas = oldProtectGroupReplica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)protectObjectReplicas)) {
            return true;
        }
        HashSet<String> oldResourceIdSet = new HashSet<String>();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
            Set storageInfos = protectObjectReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)storageInfos)) continue;
            for (RelicaStorageInfo storageInfo : storageInfos) {
                oldResourceIdSet.add(storageInfo.getSrcStorageId());
            }
        }
        for (String newResourceId : newResourceIdSet) {
            if (oldResourceIdSet.contains(newResourceId)) continue;
            logger.info((Object)("New resource[" + newResourceId + "] is added!"), 90160758784000L);
            return true;
        }
        return false;
    }

    private void disableAllExecutePolicyInDevice(ExecutionContext context) {
        List relationList = (List)context.getAttribute("protectionRelation", List.class);
        for (ProtectionRelation relation : relationList) {
            String devSn = relation.getSrcResourceProviderSn();
            try {
                this.getHyperVaultService(devSn).disablePolicys(devSn, relation.getPairId(), String.valueOf(1));
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("to disable policy on device failed! devSn:" + devSn + ", hyperVaultId:" + relation.getPairId()));
                throw e;
            }
        }
    }

    private ExecutionContext init(ProtectGroup protectGroup) {
        ExecutionContext context = new ExecutionContext();
        context.setAttribute("PROTECT_GROUP", (Object)protectGroup);
        List<ProtectionRelation> protectionRelationList = this.initProtectionRelation(protectGroup);
        context.setAttribute("protectionRelation", protectionRelationList);
        ProtectionRelation srcRelation = protectionRelationList.get(0);
        context.setAttribute("DEVICE_SN_LOCATION_" + DrmEnumDefine.ProtectLocation.A_A.getValue(), (Object)srcRelation.getSrcResourceProviderSn());
        List targetResource = srcRelation.getTargetResources();
        if (VerifyUtil.isEmpty((Collection)targetResource)) {
            logger.error((Object)"init failed! Because protectionRelation's targetResources is empty!", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        context.setAttribute("DEVICE_SN_LOCATION_" + DrmEnumDefine.ProtectLocation.B_B.getValue(), (Object)((ProtectionRelation)targetResource.get(0)).getSrcResourceProviderSn());
        return context;
    }

    private List<ProtectionRelation> initProtectionRelation(ProtectGroup protectGroup) {
        PolicyTemplate template = protectGroup.getTemplate();
        Map props = template.getProps();
        String prStr = (String)props.get("protectionRelation");
        if (VerifyUtil.isEmpty((String)prStr)) {
            logger.error((Object)"Create hyper vault Relation failed! Because protectionRelation is empty!", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        List relationList = ProtectionRelationJsonConverter.toProtectionRelationList((String)prStr);
        String prStr2DB = ProtectionRelationJsonConverter.toJsonStr((List)relationList, (boolean)true);
        props.put("protectionRelation", prStr2DB);
        return relationList;
    }
}

