/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayHyperMetroAsyncBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanHyperVaultBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArraySanHyperMetroVaultBuilder
extends ArraySanHyperVaultBuilder {
    private ArrayHyperMetroAsyncBuilder arrayHyperMetroAsyncBuilder;

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        this.buildReplica(protectGroup, (IReplicaBuilder)this.arrayHyperMetroAsyncBuilder);
    }

    @Override
    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        return super.beforeDeleteProtectGroup(protectGroup);
    }

    @Override
    public int getType() {
        return 31;
    }

    public ArrayHyperMetroAsyncBuilder getArrayHyperMetroAsyncBuilder() {
        return this.arrayHyperMetroAsyncBuilder;
    }

    public void setArrayHyperMetroAsyncBuilder(ArrayHyperMetroAsyncBuilder arrayHyperMetroAsyncBuilder) {
        this.arrayHyperMetroAsyncBuilder = arrayHyperMetroAsyncBuilder;
    }

    @Override
    public Map<Integer, String> getProtectedDeviceSn(ProtectGroup protectGroup) {
        ArrayList wwns = new ArrayList();
        protectGroup.distinctStorageInfo().forEach(storage -> wwns.add(storage.getLunWWN()));
        List allStorageResources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwns.toArray(new String[wwns.size()]));
        HashSet<String> devSnOfLocation = new HashSet<String>();
        for (StorageResource storageResource : allStorageResources) {
            devSnOfLocation.add(storageResource.getDevSn());
        }
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.putAll(super.getProtectedDeviceSn(protectGroup));
        for (String devSn : devSnOfLocation) {
            if (result.containsValue(devSn)) continue;
            result.put(DrmEnumDefine.ProtectLocation.B_B.getValue(), devSn);
            break;
        }
        return result;
    }

    @Override
    public Map<String, List<ProtectObjectStorageInfo>> getAllStroageInfo(ProtectGroup protectGroup) {
        ArrayList wwns = new ArrayList();
        protectGroup.distinctStorageInfo().forEach(storage -> wwns.add(storage.getLunWWN()));
        List allStorageResources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwns.toArray(new String[wwns.size()]));
        ProtectGroupReplica replica = protectGroup.getAnyoneReplicationReplica();
        HashMap<String, List<ProtectObjectStorageInfo>> map = new HashMap<String, List<ProtectObjectStorageInfo>>();
        HashMap storageInfoMap = new HashMap();
        protectGroup.distinctStorageInfo().forEach(poStorageInfo -> allStorageResources.forEach(storageResource -> {
            Lun lun = (Lun)storageResource;
            if (poStorageInfo.getLunWWN().equals(lun.getWwn())) {
                ProtectObjectStorageInfo info = new ProtectObjectStorageInfo();
                info.setResourceId(lun.getResourceId());
                info.setResourceProviderSN(lun.getDevSn());
                info.setArchiveLog(poStorageInfo.getArchiveLog());
                info.setLunWWN(poStorageInfo.getLunWWN());
                storageInfoMap.put(poStorageInfo.getLunWWN(), info);
                ProtectGroupUtil.putObjectToMap((Map)map, (Object)info.getResourceProviderSN(), (Object)info);
            }
        }));
        replica.getReplicas().forEach(poReplica -> poReplica.getStorageInfos().forEach(storageInfo -> {
            String replicaKey = storageInfo.getProtectObjectStorageWwn();
            ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)storageInfoMap.get(replicaKey);
            if (null != info) {
                this.convertReplicaInfoToStorageInfo(map, info, (RelicaStorageInfo)storageInfo);
            }
        }));
        return map;
    }
}

