/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySyncReplicationBuilder;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.Collection;

public class ArraySyncAsyncConcurrent3DCBuilder
extends ArraySyncReplicationBuilder {
    private static final Log logger = LogFactory.getInstance(ArraySyncAsyncConcurrent3DCBuilder.class);

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        if (protectGroup == null || VerifyUtil.isEmpty((Collection)protectGroup.getPolist()) || VerifyUtil.isEmpty((Collection)((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet())) {
            logger.error((Object)"protectGroup is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        protectGroup.getReplicaList().clear();
        String srcDevSN = ((ProtectObjectStorageInfo)((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next()).getResourceProviderSN();
        String productSite = protectGroup.getProductSiteId();
        protectGroup.setPgReplicaIndex(1);
        protectGroup.setProductSiteId(productSite);
        if (VerifyUtil.isEmpty((String)srcDevSN)) {
            logger.error((Object)"product array is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.getBuilderContext().put("REPLICA_INDEX", 1);
        this.getBuilderContext().put("PROTECT_TYPE", 1);
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.ProtectLocation.A_B.getValue());
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        ExecutionContext context = this.initData(protectGroup);
        ProtectGroupReplica protectGroupReplicaAB = this.getProtectGroupReplica(protectGroup, context);
        protectGroupReplicaAB.setStatus(DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue());
        protectGroup.getReplicaList().add(protectGroupReplicaAB);
        this.getBuilderContext().put("REPLICA_INDEX", 2);
        this.getBuilderContext().put("PROTECT_TYPE", 2);
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.ProtectLocation.A_C.getValue());
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        ProtectGroupReplica protectGroupReplicaAC = this.getProtectGroupReplica(protectGroup, context);
        protectGroupReplicaAC.setStatus(DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS.getValue());
        protectGroup.getReplicaList().add(protectGroupReplicaAC);
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    protected void generatePosi(int protectLocation, ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        if (DrmEnumDefine.ProtectLocation.A_B.getValue() == protectLocation) {
            super.generatePosi(protectLocation, protectObject, protectObjectReplica, protectGroupReplica, context);
        } else {
            for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
                Lun lunMo = new Lun();
                lunMo.setDevSn(posi.getResourceProviderSN());
                lunMo.setResourceId(posi.getResourceId());
                this.generatePosiByLun(2, protectObjectReplica, protectGroupReplica, posi, lunMo, context);
            }
        }
    }
}

