/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.factory;

import com.google.common.base.Joiner;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaExtendTools;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.protection.replica.factory.AbstractReplicaFactory;
import com.huawei.ism.drm.storage.sdk.model.HyperCDPConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.sdk.model.SnapshotConsistentGroup;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HyperCDPReplicaFactory
extends AbstractReplicaFactory {
    private static final Log logger = LogFactory.getInstance(HyperCDPReplicaFactory.class);

    public ProtectGroupReplica createReplica(ProtectGroupReplica sourceReplica) {
        ProtectGroupReplica cloneReplica = null;
        try {
            cloneReplica = this.getProtectGroupReplica(sourceReplica);
            String devId = sourceReplica.getStorageDeviceId();
            IStorageSnapshotGroupManager snapshotGroupManager = StorageSnapshotGroupManagerProxy.getInstance().getStorageSnapshotGroupMgrByDevId(devId);
            IStorageSnapshotManager storageSnapshotManager = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devId);
            Set replicaList = cloneReplica.getReplicas();
            HashMap snapshotConsistentGroupMap = new HashMap();
            replicaList.stream().filter(poRep -> !VerifyUtil.isEmpty((Object)poRep)).forEach(poRep -> {
                poRep.setId(UUIDGenerator.getUUID());
                Set infos = poRep.getStorageInfos();
                if (VerifyUtil.isEmpty((Collection)infos)) {
                    return;
                }
                HashSet newStorageInfos = new HashSet();
                HashSet srcCgidSet = new HashSet();
                HashSet srcResourceidSet = new HashSet();
                Joiner joiner = Joiner.on((String)"-");
                HashMap poStorageWwnMap = new HashMap();
                infos.forEach(info -> {
                    srcCgidSet.add(((LocalStorageReplica)info).getConsistentGroupId());
                    srcResourceidSet.add(info.getSrcStorageId());
                    poStorageWwnMap.put(joiner.join((Object[])new String[]{info.getSrcStorageProviderSN(), info.getSrcStorageId()}), info.getProtectObjectStorageWwn());
                });
                srcCgidSet.stream().forEach(cgid -> {
                    SnapshotConsistentGroup snapshotConsistentGroup = (SnapshotConsistentGroup)snapshotConsistentGroupMap.get(cgid);
                    if (null == snapshotConsistentGroup) {
                        String cgName = "CopyFrom_" + cgid + "_" + System.currentTimeMillis();
                        snapshotConsistentGroup = snapshotGroupManager.copyFromHyperCDP(devId, cgName, cgid);
                        snapshotConsistentGroupMap.put(cgid, snapshotConsistentGroup);
                    }
                    List newSnap = storageSnapshotManager.querySnapshots(devId, XveMOType.SNAPSHOT_CONSISTENCY_GROUP, snapshotConsistentGroup.getId());
                    ExecutionService.map((Collection)newSnap, snapshot -> {
                        Integer lunId = snapshot.getSrcResourceId();
                        String newName = "DRdata_" + lunId + "_" + System.currentTimeMillis();
                        storageSnapshotManager.renameSnapshot(snapshot.getDevSn(), snapshot, newName);
                        return null;
                    });
                    newSnap.stream().filter(snapshot -> srcResourceidSet.contains(String.valueOf(snapshot.getSrcResourceId()))).forEach(snapshot -> {
                        LocalStorageReplica localStorageReplica = this.getLocalStorageReplica((Snapshot)snapshot);
                        localStorageReplica.setSrcStorageProviderSN(devId);
                        localStorageReplica.setStorageProviderSN(devId);
                        localStorageReplica.setPoReplica(poRep);
                        localStorageReplica.setProtectObjectStorageWwn((String)poStorageWwnMap.get(joiner.join((Object[])new String[]{devId, String.valueOf(snapshot.getSrcResourceId())})));
                        localStorageReplica.setConsistentGroupId(((SnapshotConsistentGroup)snapshotConsistentGroupMap.get(cgid)).getId());
                        newStorageInfos.add(localStorageReplica);
                    });
                });
                poRep.setStorageInfos(newStorageInfos);
            });
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"An error occurred while cloning a copy");
        }
        return cloneReplica;
    }

    private LocalStorageReplica getLocalStorageReplica(Snapshot snapshot) {
        LocalStorageReplica localStorageReplica = new LocalStorageReplica();
        localStorageReplica.setId(UUIDGenerator.getUUID());
        localStorageReplica.setSnapshotName(snapshot.getSnapshotName());
        localStorageReplica.setSrcStorageId(String.valueOf(snapshot.getSrcResourceId()));
        localStorageReplica.setStorageId(snapshot.getSnapshotId());
        return localStorageReplica;
    }

    private ProtectGroupReplica getProtectGroupReplica(ProtectGroupReplica sourceReplica) throws CloneNotSupportedException {
        ProtectGroupReplica cloneReplica = (ProtectGroupReplica)sourceReplica.clone();
        cloneReplica.setId(UUIDGenerator.getUUID());
        cloneReplica.setName(this.buildReplicaName(sourceReplica));
        cloneReplica.setSourceReplicaId(sourceReplica.getId());
        cloneReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
        cloneReplica.setMountedHost("");
        cloneReplica.addProperty("planId", null);
        cloneReplica.setGeneration(Integer.valueOf(2));
        cloneReplica.setType(3);
        return cloneReplica;
    }

    public boolean validReplica(ProtectGroupReplica replica, boolean needHandleException) {
        return CheckReplicaExtendTools.checkSnapshotCorrect((ProtectGroupReplica)replica, (boolean)needHandleException);
    }

    @Override
    protected void deleteReplica(ProtectGroupReplica replica, boolean isNeedSendAlarm) {
        StorageHyperCDPGroupManagerProxy proxy = StorageHyperCDPGroupManagerProxy.getInstance();
        String devId = replica.getRecoveryArray();
        IStorageHyperCDPGroupManager hyperCDPManager = proxy.getStorageHyperCDPGroupMgrByDevId(devId);
        replica.getReplicas().stream().filter(item -> !VerifyUtil.isEmpty((Object)item)).forEach(item -> {
            Set infos = item.getStorageInfos();
            HashMap hyperCDPGroupByCGId = new HashMap();
            infos.stream().filter(info -> !VerifyUtil.isEmpty((Object)info)).forEach(info -> {
                String hyperCDPCGId = ((LocalStorageReplica)info).getConsistentGroupId();
                HashSet<RelicaStorageInfo> cdps = (HashSet<RelicaStorageInfo>)hyperCDPGroupByCGId.get(hyperCDPCGId);
                if (VerifyUtil.isEmpty((Collection)cdps)) {
                    cdps = new HashSet<RelicaStorageInfo>();
                }
                cdps.add((RelicaStorageInfo)info);
                hyperCDPGroupByCGId.put(hyperCDPCGId, cdps);
            });
            hyperCDPGroupByCGId.entrySet().forEach(en -> {
                String cgId = (String)en.getKey();
                HyperCDPConsistencyGroup group = null;
                try {
                    group = hyperCDPManager.query(devId, cgId);
                    if (null != group) {
                        hyperCDPManager.delete(devId, cgId);
                    }
                }
                catch (Exception e) {
                    this.dealDeleteReplicaException(devId, cgId, group.getSrcLunConsistentGroupId(), e, isNeedSendAlarm);
                }
            });
        });
    }

    private void dealDeleteReplicaException(String devSn, String cgId, String lunCgId, Exception e, boolean isNeedSendAlarm) {
        logger.error((Object)("delete repica error.cgId:" + cgId), (Throwable)e);
        if (isNeedSendAlarm) {
            String ipAddress = this.getIpAddress(devSn);
            String[] params = new String[]{cgId, lunCgId, ipAddress};
            AlarmReporter.sendAlarm((String)"0x323005E", null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])params);
        } else {
            ExceptionUtil.rethrowException((Throwable)e, (String)"delete Snapshot error.", (long)-1L, null, (Log)logger);
        }
    }

    public int getFactoryType() {
        return 4;
    }
}

