/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayHyperMetroFilter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperMetroVaultFilter
extends ArrayHyperMetroFilter {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroVaultFilter.class);
    private static final String POLICY_TEMPLATE = "POLICY_TEMPLATE";
    private static final String TARGET_DEVICE_SITE = "TARGET_DEVICE_SITE";
    private static final String PROTECTION_RELATION = "protectionRelation";

    @Override
    public int getType() {
        return 28;
    }

    public boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        PolicyTemplateContext context = new PolicyTemplateContext();
        context.addObject(POLICY_TEMPLATE, policyTemplate);
        if (this.checkFreshHyperMetroHealth(protectObjects, context)) {
            return this.freshMatch(protectObjects, context);
        }
        return this.isMatch(protectObjects, context);
    }

    private boolean checkFreshHyperMetroHealth(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        PolicyTemplate policyTemplate = (PolicyTemplate)context.getObject(POLICY_TEMPLATE);
        String pathStr = (String)policyTemplate.getProps().get(PROTECTION_RELATION);
        if (VerifyUtil.isEmpty((String)pathStr)) {
            logger.error((Object)"pathStr is empty ");
            return false;
        }
        List protectionRelationList = ProtectionRelationJsonConverter.toProtectionRelationList((String)pathStr);
        if (VerifyUtil.isEmpty((Collection)protectionRelationList)) {
            logger.error((Object)"protectionRelationList is empty ");
            return false;
        }
        String devSn = ((ProtectionRelation)CommonUtil.getFirstElement((Collection)protectionRelationList)).getSrcResourceProviderSn();
        return this.checkFreshHyperMetroHealth(protectObjects, context, devSn);
    }

    @Override
    protected void cascadeFilterOperation(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        List<StorageResource> resourceList = this.getNasStorageResource(context);
        List<HyperVault> vaultList = this.getAllHyperVault(resourceList);
        String devSn = null;
        String targetDeviceSN = null;
        List pairList = (List)context.getObject("PAIR_LIST");
        if (vaultList.size() != pairList.size()) {
            logger.error((Object)("the size of pairList  is not equals of the size of vaultList!" + this.getVaultListStr(vaultList)), 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
        for (HyperVault vault : vaultList) {
            this.checkHyperVaultStatus(vault);
            devSn = this.checkBothDeviceExistVault(devSn, vault);
            targetDeviceSN = this.checkRemoteDevice(targetDeviceSN, vault);
        }
        this.checkSite(targetDeviceSN, context);
        this.setProtectionRelation(devSn, context, vaultList);
    }

    private void setProtectionRelation(String srcDeviceSN, PolicyTemplateContext context, List<HyperVault> vaultList) {
        List<ProtectionRelation> relationList = this.getHyperVaultProtectionRelations(vaultList, context, srcDeviceSN);
        PolicyTemplate policyTemplate = (PolicyTemplate)context.getObject(POLICY_TEMPLATE);
        Map props = policyTemplate.getProps();
        props.put(PROTECTION_RELATION, ProtectionRelationJsonConverter.toJsonStr(relationList, (boolean)false));
    }

    private List<ProtectionRelation> getHyperVaultProtectionRelations(List<HyperVault> vaultList, PolicyTemplateContext context, String srcDeviceSN) {
        Site srcDeviceSite = this.getSiteFromSn(srcDeviceSN);
        Site targetSite = (Site)context.getObject(TARGET_DEVICE_SITE);
        ArrayList<ProtectionRelation> relationList = new ArrayList<ProtectionRelation>();
        for (HyperVault hyperVault : vaultList) {
            Integer resourceType = DrmEnumDefine.ResourceTypeE.LUN.getValue();
            if (!VerifyUtil.isEmpty((Object)hyperVault.getResourceType()) && hyperVault.getResourceType().intValue() == XveMOType.FILESYSTEM.getValue()) {
                resourceType = DrmEnumDefine.ResourceTypeE.NAS.getValue();
            }
            ProtectionRelation srcProtectionRelation = this.constructProtectionRelation(hyperVault.getId(), hyperVault.getLocalResourceId(), srcDeviceSN, srcDeviceSite, resourceType);
            ProtectionRelation protectionRelation = this.constructProtectionRelation(hyperVault.getId(), hyperVault.getRemoteResourceId(), hyperVault.getRemoteDeviceSn(), targetSite, resourceType);
            srcProtectionRelation.setTargetResources(Arrays.asList(protectionRelation));
            relationList.add(srcProtectionRelation);
        }
        return relationList;
    }

    private ProtectionRelation constructProtectionRelation(String pairId, String resourceId, String deviceSN, Site site, Integer resourceType) {
        ProtectionRelation protectionRelation = new ProtectionRelation();
        protectionRelation.setPairId(pairId);
        protectionRelation.setSrcResourceId(resourceId);
        protectionRelation.setSrcResourceProviderSn(deviceSN);
        protectionRelation.setSrcSiteId(site.getSiteId());
        protectionRelation.setSrcSiteName(site.getName());
        protectionRelation.setSrcResourceType(resourceType.toString());
        return protectionRelation;
    }

    private void checkSite(String targetDeviceSN, PolicyTemplateContext context) {
        Site targetSite;
        Set siteIdSet = (Set)context.getObject("DEVICE_SITE_SET");
        if (siteIdSet.contains((targetSite = this.getSiteFromSn(targetDeviceSN)).getSiteId())) {
            logger.error((Object)("The targetSite is in hyperMetro site. hyperMetro:" + this.getSetStr(siteIdSet) + ", targetSite:" + targetSite.getSiteId()), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        context.addObject(TARGET_DEVICE_SITE, targetSite);
        this.checkIsLocalSite(targetDeviceSN, targetSite);
    }

    private void checkHyperVaultStatus(HyperVault hyperVault) {
        String healthStateStr = hyperVault.getHealthState();
        String normalStateStr = String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue());
        if (!normalStateStr.equals(healthStateStr)) {
            logger.error((Object)("the health status is not normal! healthStatus:" + healthStateStr));
            throw new LegoCheckedException(1073948239L);
        }
    }

    private String getVaultListStr(List<HyperVault> vaultList) {
        StringBuilder sb = new StringBuilder("vaultList [ ");
        if (VerifyUtil.isEmpty(vaultList)) {
            sb.append("empty.]");
            return sb.toString();
        }
        for (HyperVault vault : vaultList) {
            sb.append(this.getVaultStr(vault));
        }
        return sb.toString();
    }

    private String getVaultStr(HyperVault vault) {
        StringBuilder sb = new StringBuilder();
        String uuid = vault.getUuid();
        String localObjId = vault.getLocalResourceId();
        String remoteObjId = vault.getRemoteResourceId();
        sb.append("pairUuid:" + uuid).append(",").append("runningStatus:" + vault.getRunningState()).append(",").append("healthStatus:" + vault.getHealthState()).append(",").append("localObjId:" + localObjId).append(",").append("remoteObjId:" + remoteObjId).append(",").append("remoteDeviceSn:" + vault.getRemoteDeviceSn()).append(",").append("devSn:" + vault.getDevSn()).append("]");
        return sb.toString();
    }

    private void checkIsLocalSite(String deviceSn, Site devicesite) {
        if (devicesite.getSiteType() != 0) {
            logger.error((Object)("The array [" + deviceSn + "] registered site is not local! site name:" + devicesite.getName()), 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private String checkRemoteDevice(String targetDeviceSN, HyperVault vault) {
        String remoteSn = vault.getRemoteDeviceSn();
        if (targetDeviceSN == null) {
            targetDeviceSN = remoteSn;
        }
        if (VerifyUtil.isEmpty((String)remoteSn)) {
            logger.error((Object)"targetDeviceSN is empty!", 90160758786989L);
            throw new LegoCheckedException(1073948245L);
        }
        if (!remoteSn.equals(targetDeviceSN)) {
            logger.error((Object)("vault remote is not the same device!  targetDeviceSN:" + targetDeviceSN + ", remoteSn:" + remoteSn));
            throw new LegoCheckedException(1073948191L);
        }
        return targetDeviceSN;
    }

    private String checkBothDeviceExistVault(String devSn, HyperVault hyperVault) {
        String srcDevSN = hyperVault.getDevSn();
        if (devSn == null) {
            devSn = srcDevSN;
        } else if (!devSn.equals(srcDevSN)) {
            logger.error((Object)("both of the hyper metro nas exist hyperVault relation!devSn:" + devSn + ", srcDevSN:" + srcDevSN));
            throw new LegoCheckedException(1073948191L);
        }
        return devSn;
    }

    private List<HyperVault> getAllHyperVault(List<StorageResource> allStorageResources) {
        HashMap<String, ArrayList<String>> devSn2StorageResourceList = new HashMap<String, ArrayList<String>>();
        for (StorageResource storageResource : allStorageResources) {
            String devSn = storageResource.getDevSn();
            ArrayList<String> resIdList = (ArrayList<String>)devSn2StorageResourceList.get(devSn);
            if (resIdList == null) {
                resIdList = new ArrayList<String>();
                resIdList.add(storageResource.getResourceId());
                devSn2StorageResourceList.put(devSn, resIdList);
                continue;
            }
            resIdList.add(storageResource.getResourceId());
        }
        ArrayList<HyperVault> allVaults = new ArrayList<HyperVault>();
        for (Map.Entry entry : devSn2StorageResourceList.entrySet()) {
            String devSn = (String)entry.getKey();
            List resIdList = (List)entry.getValue();
            List vaultList = this.getHyperVaultService(devSn).queryHyperVaultListByResourceIds(devSn, resIdList);
            if (VerifyUtil.isEmpty((Collection)vaultList)) continue;
            allVaults.addAll(vaultList);
        }
        if (VerifyUtil.isEmpty(allVaults)) {
            logger.error((Object)"vaultList is null!");
            throw new LegoCheckedException(1073948191L);
        }
        return allVaults;
    }

    private IStorageHyperVaultManager getHyperVaultService(String devSn) {
        IStorageHyperVaultManager service = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (service == null) {
            logger.error((Object)("to get the IStorageHyperVaultManager failed! devSn:" + devSn));
            throw new LegoCheckedException(-1L);
        }
        return service;
    }
}

