/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageDrStarManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageDrStarManager;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySanAirGapSnapshotFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.unistor.sdk.model.HyperDRRing;
import com.huawei.ism.unistor.sdk.model.HyperDRRingMember;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ArraySanHyperMetroAsyncAirGapSnapshotFilter
extends ArraySanAirGapSnapshotFilter {
    private static final Log LOGGER = LogFactory.getInstance(ArraySanHyperMetroAsyncAirGapSnapshotFilter.class);
    private static final String DR_STAR_ENABLE = "1";
    private static final String DR_STAR_MANUALLY_SWAP = "1";

    @Override
    public int getType() {
        return 48;
    }

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        return super.isMatch(protectObjects);
    }

    @Override
    protected void checkAndSetAirGapSite(String devSn, Set<String> siteWwnSet) {
        List<Lun> curSiteLunList = this.getAirGapLunByWwn(siteWwnSet);
        if (this.checkLunVstoreId(curSiteLunList)) {
            LOGGER.error((Object)"Lun list has different vStoreId, error!");
            throw new LegoCheckedException(1073948191L);
        }
        List<String> lunIdList = curSiteLunList.stream().map(Lun::getLunId).collect(Collectors.toList());
        List pairs = this.getStorageService().getReplicationPairsByResourceIds(devSn, lunIdList, false, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        this.checkReplicationPairNums(devSn, lunIdList, pairs);
        HashMap<String, Set<String>> srcDevLunIdMap = new HashMap<String, Set<String>>();
        pairs.forEach(pair -> srcDevLunIdMap.computeIfAbsent(pair.getSrcDevSN(), set -> new HashSet()).add(pair.getSrcLunId()));
        this.checkPairRelateDevSnNums(devSn, srcDevLunIdMap);
        srcDevLunIdMap.keySet().forEach(srcDevSn -> this.checkResource((String)srcDevSn, false));
        this.checkPairModeAndResumePolicy(pairs, devSn);
        this.checkPairDrStarStatus(pairs, devSn);
        this.addAirGapInfo(devSn, pairs);
    }

    private void checkPairDrStarStatus(List<ReplicationPair> pairs, String devSn) {
        IStorageDrStarManager drStarManager = StorageDrStarManagerProxy.getInstance().getStorageDrStarManager(devSn);
        for (ReplicationPair pair : pairs) {
            String drRingId = pair.getDrRingId();
            if (VerifyUtil.isEmpty((String)drRingId)) {
                LOGGER.error((Object)"Replication pair's drRingId is empty. devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
                throw new LegoCheckedException(1073948191L);
            }
            Optional optional = drStarManager.getDrStarById(devSn, drRingId);
            if (!optional.isPresent()) {
                LOGGER.error((Object)"Replication pair is not dr member. devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
                throw new LegoCheckedException(1073948191L);
            }
            if (!"1".equals(((HyperDRRing)optional.get()).getRunningState())) {
                LOGGER.error((Object)"The dr of replication pair is closed. devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
                throw new LegoCheckedException(1073948257L);
            }
            if (!"1".equals(((HyperDRRing)optional.get()).getSwapStrategy())) {
                LOGGER.error((Object)"The dr of replication pair is closed. devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
                throw new LegoCheckedException(1677929523L);
            }
            List drStarMemberInfos = drStarManager.getDrStarMemberInfos(devSn, drRingId);
            this.checkDrStarMemberInfos(drStarMemberInfos);
        }
    }

    private void checkDrStarMemberInfos(List<HyperDRRingMember> drStarMemberInfos) {
        List sync = drStarMemberInfos.stream().filter(e -> DrmEnumDefine.HyperDrRingMemberType.SYNC.getValue().equals(e.getFeatureType())).collect(Collectors.toList());
        if (!VerifyUtil.isEmpty(sync)) {
            LOGGER.error((Object)"The dr must not contain a sync replication member.");
            throw new LegoCheckedException(1073948191L);
        }
        List hyperMetro = drStarMemberInfos.stream().filter(e -> DrmEnumDefine.HyperDrRingMemberType.HYPER_METRO.getValue().equals(e.getFeatureType())).collect(Collectors.toList());
        if (hyperMetro.size() != 1) {
            LOGGER.error((Object)"The dr must have a hyperMetro member.");
            throw new LegoCheckedException(1073948191L);
        }
        List async = drStarMemberInfos.stream().filter(e -> DrmEnumDefine.HyperDrRingMemberType.ASYNC.getValue().equals(e.getFeatureType())).collect(Collectors.toList());
        if (async.size() != 2) {
            LOGGER.error((Object)"The dr must have two async replication members.");
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkReplicationPairNums(String devSn, List<String> lunIdList, List<ReplicationPair> pairs) {
        if (pairs.size() == 0 || pairs.size() % 2 != 0 || pairs.size() / 2 != lunIdList.size()) {
            LOGGER.error((Object)"Storage resource is illegal. devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073948191L);
        }
    }

    protected void checkPairRelateDevSnNums(String devSn, Map<String, Set<String>> srcDevLunIdMap) {
        if (srcDevLunIdMap.keySet().size() != 2) {
            LOGGER.error((Object)"Storage resource is illegal. devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073948191L);
        }
    }

    @Override
    protected void checkPairAndCg(List<ReplicationPair> toBeCheckedPairList, Set<String> cgIdSet) {
        if (!VerifyUtil.isEmpty(toBeCheckedPairList) && !VerifyUtil.isEmpty(cgIdSet)) {
            LOGGER.error((Object)"Protect object contains both pair and cg!");
            throw new LegoCheckedException(1073948191L);
        }
    }

    @Override
    public boolean checkCgGroup(String devSn, Set<String> cgIdSet) {
        if (cgIdSet.size() > 2) {
            LOGGER.error((Object)"Protect object contains multi cg!");
            throw new LegoCheckedException(1073948191L);
        }
        return super.checkCgGroup(devSn, cgIdSet);
    }

    public Site getSiteFromSn(String arraySn) {
        return super.getSiteFromSn(arraySn);
    }
}

