/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CheckRollbackBackupSubProcessor;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class CheckRollbackBackupProcessor
extends BaseRecoveryProcessor {
    private static final long SLEEP_TIME = 5000L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String restoreRequestId = (String)context.getAttribute("context_restore_request_id");
        ProtectGroupReplica replica = (ProtectGroupReplica)context.getAttribute("Recovery_PgReplica");
        VerifyUtil.checkObjs((Object[])new Object[]{restoreRequestId, replica});
        this.updateSubProcessors(replica, restoreRequestId);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.updateProcessDetail("ism.drm.recovery.no.rollback.backup", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        CommUtil.pauseThread((long)5000L);
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private boolean updateSubProcessors(ProtectGroupReplica replica, String requestId) {
        if (VerifyUtil.isEmpty((Object)replica)) {
            return true;
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return true;
        }
        HashSet<CheckRollbackBackupSubProcessor> subProcessors = new HashSet<CheckRollbackBackupSubProcessor>();
        CheckRollbackBackupSubProcessor processor = new CheckRollbackBackupSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setRequestId(requestId);
        processor.setImageId(replica.getId());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDeviceId(replica.getStorageDeviceId());
        subProcessors.add(processor);
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }
}

