/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.BaseRollbackProcessor;
import com.huawei.ism.drm.storage.recovery.process.CheckRollbackBackupProcessor;
import com.huawei.ism.drm.storage.recovery.process.CheckRollbackSnapshotProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class CheckRollbackProcessor
extends BaseRollbackProcessor {
    private static final Log logger = LogFactory.getInstance(CheckRollbackProcessor.class);
    private static final long serialVersionUID = -5614786576176422308L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        return super.execute(context);
    }

    @Override
    protected void handleSubProcessorByReplica(ProtectGroupReplica replica) {
        if (replica.isStorageSnapshotReplica()) {
            logger.debug((Object)"start snapshot rollback check process");
            this.updateSubProcessors((RecoveryProcessor)new CheckRollbackSnapshotProcessor());
        } else if (replica.isBackUpReplica()) {
            logger.debug((Object)"start backup rollback check process");
            this.updateSubProcessors((RecoveryProcessor)new CheckRollbackBackupProcessor());
        } else {
            logger.error((Object)("not supported replication type. replicaId:" + replica.getId() + " replicaType:" + replica.getType()));
            throw new LegoCheckedException(1073947393L);
        }
    }
}

