/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.CheckRollbackSnapshotSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.HyperCDP;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckRollbackSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5614786576176422308L;
    private static final long SLEEP_TIME = 15000L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        int protectType = ((RecoveryTask)recoveryTasks.stream().findAny().get()).getProtectType();
        if (protectType == ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue() || protectType == ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue()) {
            this.updateCgGroupSubProcessors(recoveryTasks, protectType);
        } else {
            this.updateSubProcessors(recoveryTasks);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.updateProcessDetail("ism.drm.recovery.no.rollback.snapshot", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        CommUtil.pauseThread((long)15000L);
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private boolean updateCgGroupSubProcessors(Collection<RecoveryTask> recoveryTasks, int protectType) {
        HashMap<String, HashSet<String>> cgIdMap = new HashMap<String, HashSet<String>>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String string = recoveryTask.getSrcDeviceId();
            String consistentGroupId = recoveryTask.getConsistentGroupId();
            if (cgIdMap.containsKey(string)) {
                ((Set)cgIdMap.get(string)).add(consistentGroupId);
                continue;
            }
            cgIdMap.put(string, new HashSet<String>(Arrays.asList(consistentGroupId)));
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (Map.Entry entry : cgIdMap.entrySet()) {
            String srcDeviceId = (String)entry.getKey();
            Set cgIdSet = (Set)entry.getValue();
            for (String consistentGroupId : cgIdSet) {
                if (protectType == ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue()) {
                    IStorageHyperCDPManager storageHyperCDPManager = StorageHyperCDPManagerProxy.getInstance().getStorageSnapshotMgrByDevId(srcDeviceId);
                    List hyperCDPList = storageHyperCDPManager.getHyperCDPByCGId(srcDeviceId, consistentGroupId);
                    for (HyperCDP hyperCDP : hyperCDPList) {
                        this.addNewSubProcessor(subProcessors, srcDeviceId, (Snapshot)hyperCDP, ReplicationConstantDefine.LocalTaskType.HYPERCDP.getValue());
                    }
                    continue;
                }
                if (protectType != ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue()) continue;
                IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(srcDeviceId);
                List snapshotList = proxy.querySnapshots(srcDeviceId, XveMOType.SNAPSHOT_CONSISTENCY_GROUP, consistentGroupId);
                for (Snapshot snapshot : snapshotList) {
                    this.addNewSubProcessor(subProcessors, srcDeviceId, snapshot, ReplicationConstantDefine.LocalTaskType.SNAPSHOT.getValue());
                }
            }
        }
        this.setChildProc(subProcessors);
        boolean bl = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return bl;
    }

    private void addNewSubProcessor(Set<RecoveryProcessor> subProcessors, String srcDeviceId, Snapshot snapshot, int protectType) {
        CheckRollbackSnapshotSubProcessor processor = new CheckRollbackSnapshotSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDeviceId(srcDeviceId);
        processor.setLunId(String.valueOf(snapshot.getSrcResourceId()));
        processor.setSnapshotId(snapshot.getSnapshotId());
        processor.setSnapshotName(snapshot.getSnapshotName());
        processor.setProtectType(protectType);
        subProcessors.add((RecoveryProcessor)processor);
    }

    private boolean updateSubProcessors(Collection<RecoveryTask> recoveryTasks) {
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            return true;
        }
        HashSet<CheckRollbackSnapshotSubProcessor> subProcessors = new HashSet<CheckRollbackSnapshotSubProcessor>();
        for (RecoveryTask task : recoveryTasks) {
            if (VerifyUtil.isEmpty((Collection)task.getSrcStorageIds())) {
                throw new LegoCheckedException(1073947393L);
            }
            Iterator iterator = task.getSrcStorageIds().iterator();
            if (!iterator.hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            CheckRollbackSnapshotSubProcessor processor = new CheckRollbackSnapshotSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDeviceId(task.getSrcDeviceId());
            processor.setLunId((String)iterator.next());
            processor.setSnapshotId(task.getProtectId());
            processor.setSnapshotName(task.getProtectName());
            processor.setProtectType(task.getProtectType());
            subProcessors.add(processor);
        }
        this.setChildProc(subProcessors);
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckRollbackSnapshotProcessor.des");
    }

    public String getStepPosition() {
        return "CheckRollback";
    }
}

