/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.BackupTargetDataProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DeleteTargetBackupDataProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7740329258639210616L;
    private static final Log logger = LogFactory.getInstance(DeleteTargetBackupDataProcessor.class);
    private static final String SNAPSHOT_ID = "SnapshotId";
    private static final String LUN_ID = "LunId";
    private static final String LUN_NAME = "LunName";
    private static final String DEVICE_ID = "DeviceId";
    private static final String SNAPSHOT_NAME = "SnapshotName";
    private static final String RESOURCE_TYPE = "ResourceType";

    protected boolean execute(RecoveryProcessorContext context) {
        this.setIsResultProcessor(false);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        List recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, type, BackupTargetDataProcessor.class);
        if (null == recoveryProcesses) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.setChildProc(null);
            return true;
        }
        Iterator iterator = recoveryProcesses.iterator();
        if (!iterator.hasNext()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.setChildProc(null);
            return true;
        }
        BackupTargetDataProcessor backupProcessor = (BackupTargetDataProcessor)((Object)iterator.next());
        String snapShotInfos = backupProcessor.getSnapShotInfos();
        if (VerifyUtil.isEmpty((String)snapShotInfos)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.setChildProc(null);
            return true;
        }
        try {
            this.updateSubProcessors(snapShotInfos);
            if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                this.setChildProc(null);
                return true;
            }
            RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
            recoveryTemplate.process(context);
            this.calcProcessResultBySubProc();
        }
        catch (Exception e) {
            logger.error((Object)("DeleteTargetBackupDataProcessor." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        this.cleanSnapshotInfo();
        this.setChildProc(null);
        return true;
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return true;
    }

    private boolean updateSubProcessors(String snapShotInfos) {
        JSONArray resultArray = JSONArray.fromObject((Object)snapShotInfos);
        HashSet<DeleteSnapshotSubProcessor> subProcessor = new HashSet<DeleteSnapshotSubProcessor>();
        for (Object eachSnap : resultArray) {
            JSONObject snapInfo = JSONObject.fromObject(eachSnap);
            if (!DrmEnumDefine.ResourceTypeE.LUN.toString().equalsIgnoreCase(snapInfo.getString(RESOURCE_TYPE)) || !snapInfo.containsKey((Object)SNAPSHOT_ID)) continue;
            String snapshotId = snapInfo.getString(SNAPSHOT_ID);
            DeleteSnapshotSubProcessor processor = new DeleteSnapshotSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setLunId(snapInfo.getString(LUN_ID));
            processor.setLunName(snapInfo.getString(LUN_NAME));
            processor.setDeviceId(snapInfo.getString(DEVICE_ID));
            processor.setSnapshotId(snapshotId);
            processor.setSnapshotName(snapInfo.getString(SNAPSHOT_NAME));
            processor.setIsNeedSave(false);
            processor.setIsNeedCreateDetail(false);
            subProcessor.add(processor);
        }
        this.setChildProc(subProcessor);
        return true;
    }

    private void cleanSnapshotInfo() {
        int procType = this.getProcType();
        DrmEnumDefine.RecoveryPlanExecuteTypeE procTypeE = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        if (procTypeE != DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK) {
            return;
        }
        RecoveryProcessorContext context = this.getContextRef();
        List backupTargetDataProcessorList = this.getRecoveryProcessors(context.getRecoveryPlan(), procTypeE, BackupTargetDataProcessor.class);
        if (VerifyUtil.isEmpty((Collection)backupTargetDataProcessorList)) {
            logger.warn((Object)"can't find previous backupTargetDataProcessor.");
            return;
        }
        BackupTargetDataProcessor backupTargetDataProcessor = (BackupTargetDataProcessor)((Object)backupTargetDataProcessorList.get(0));
        String snapShotInfos = backupTargetDataProcessor.getSnapShotInfos();
        JSONArray jsonArray = JSONArray.fromObject((Object)snapShotInfos);
        if (VerifyUtil.isEmpty((Collection)jsonArray)) {
            logger.debug((Object)"no snapshot info in backupTargetProcessor.");
            return;
        }
        HashSet<String> deletedSnapshotIdSet = new HashSet<String>();
        Set childProc = this.getChildProc();
        for (RecoveryProcessor recoveryProcessor : childProc) {
            DeleteSnapshotSubProcessor deleteSnapshotSubProcessor = (DeleteSnapshotSubProcessor)recoveryProcessor;
            if (deleteSnapshotSubProcessor.getProcStatus() != DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) continue;
            deletedSnapshotIdSet.add(deleteSnapshotSubProcessor.getSnapshotId());
        }
        JSONArray newArray = new JSONArray();
        for (Object obj : jsonArray) {
            JSONObject snapshotInfo = (JSONObject)obj;
            String snapshotId = snapshotInfo.getString(SNAPSHOT_ID);
            if (deletedSnapshotIdSet.contains(snapshotId)) continue;
            newArray.add((Object)snapshotInfo);
        }
        backupTargetDataProcessor.setSnapShotInfos(newArray.toString());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)backupTargetDataProcessor);
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.DeleteTargetBackupDataProcessor.des");
    }
}

