/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageDrStarManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageDrStarManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.recovery.process.DisableHyperMetroOnRemoteSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroOpInfo;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.SanHyperMetroRingAirGapExecuteInfo;
import com.huawei.ism.unistor.sdk.model.HyperDRRingMember;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DisableHyperMetroOnRemoteProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6530350621124158131L;
    private static final Log LOGGER = LogFactory.getInstance(DisableHyperMetroOnRemoteProcessor.class);
    private String deviceId;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean execute(RecoveryProcessorContext context) {
        SanHyperMetroRingAirGapExecuteInfo recoveryInfo = (SanHyperMetroRingAirGapExecuteInfo)context.getAttribute("SAN_HYPER_METRO_RING_RECOVERY_INFO", SanHyperMetroRingAirGapExecuteInfo.class);
        this.setDeviceId(recoveryInfo.getSiteCDevSn());
        List<RecoveryProcessor> subProcessors = this.doCreateSubProcessors(context);
        if (VerifyUtil.isEmpty(subProcessors)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.setHasChildProc(true);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        recoveryTemplate.process(context);
        boolean isExecuteSuccess = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            isExecuteSuccess = false;
        }
        return isExecuteSuccess;
    }

    private List<RecoveryProcessor> doCreateSubProcessors(RecoveryProcessorContext context) {
        Collection<RecoveryTask> remoteRecoveryTasks = this.getRemoteRecoveryTasks(context);
        for (RecoveryTask task : remoteRecoveryTasks) {
            RemoteStorageReplica replica = (RemoteStorageReplica)task.getParamObj("replica", RemoteStorageReplica.class);
            if (VerifyUtil.isEmpty((Object)replica)) {
                LOGGER.error((Object)"Can not get replica from recovery task.");
                throw new LegoCheckedException(2117645L);
            }
            task.setDrRingId(replica.getDrRingId());
            task.setConsistentGroupId(replica.getConsistentGroupId());
        }
        ArrayList<RecoveryProcessor> subProcessors = new ArrayList<RecoveryProcessor>();
        this.checkAndCreateSubProcessors(remoteRecoveryTasks, context, subProcessors);
        return subProcessors;
    }

    protected void checkAndCreateSubProcessors(Collection<RecoveryTask> recoveryTasks, RecoveryProcessorContext context, List<RecoveryProcessor> subProcessors) {
        SanHyperMetroRingAirGapExecuteInfo recoveryInfo = (SanHyperMetroRingAirGapExecuteInfo)context.getAttribute("SAN_HYPER_METRO_RING_RECOVERY_INFO", SanHyperMetroRingAirGapExecuteInfo.class);
        Collection<RecoveryTask> siteARecoveryTasks = this.getMainRecoveryTask(recoveryTasks, recoveryInfo.getSiteADevSn());
        Collection<RecoveryTask> siteBRecoveryTasks = this.getMainRecoveryTask(recoveryTasks, recoveryInfo.getSiteBDevSn());
        ArrayList<RecoveryTask> openedRecoveryTasks = new ArrayList<RecoveryTask>();
        if (recoveryInfo.isSiteAPortOpenSuccess()) {
            LOGGER.info((Object)"Ports on siteA open success.");
            openedRecoveryTasks.addAll(siteARecoveryTasks);
        } else {
            LOGGER.info((Object)"Ports on siteA chain open failed, use pairs on siteB.");
            openedRecoveryTasks.addAll(siteBRecoveryTasks);
        }
        this.checkAndCreateSubProcessors(recoveryTasks, context, openedRecoveryTasks, recoveryInfo, subProcessors);
    }

    private void checkAndCreateSubProcessors(Collection<RecoveryTask> recoveryTasks, RecoveryProcessorContext context, Collection<RecoveryTask> openedRecoveryTasks, SanHyperMetroRingAirGapExecuteInfo recoveryInfo, List<RecoveryProcessor> subProcessors) {
        List hypermetroOpInfoList = recoveryInfo.getHypermetroOpInfoList();
        for (RecoveryTask task : openedRecoveryTasks) {
            RecoveryTask recoveryTask;
            HypermetroOpInfo opInfo = new HypermetroOpInfo();
            opInfo.setConsistentGroup(!VerifyUtil.isEmpty((String)task.getConsistentGroupId()));
            if (opInfo.isConsistentGroup()) {
                HyperMetroConsistentGroup hyperMetroCg = this.getHyperMetroCg(task, context);
                opInfo.setId(hyperMetroCg.getId());
                opInfo.setRunningStatus(Integer.parseInt(hyperMetroCg.getRunningState()));
                opInfo.setSyncDirection(hyperMetroCg.getSyncDirection().intValue());
                int priorityStationType = hyperMetroCg.getPriorityStationType();
                opInfo.setPrimary(priorityStationType == XveEnumDefine.PRIORITY_STATION_TYPE_E.LOCAL.getValue());
            } else {
                HyperMetroPair hyperMetroPair = this.getHyperMetro(task, context);
                opInfo.setId(hyperMetroPair.getId());
                opInfo.setRunningStatus(Integer.parseInt(hyperMetroPair.getRunningState()));
                opInfo.setSyncDirection(hyperMetroPair.getSyncDirection().intValue());
                opInfo.setPrimary(hyperMetroPair.getIsPrimary().booleanValue());
            }
            boolean isMainRecoveryTask = this.isMainRecoveryTask(task);
            boolean isAnotherOpenSuccess = recoveryInfo.isAnotherOpenSuccess(task.getSrcDeviceId());
            if (opInfo.getRunningStatus() == XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()) {
                recoveryTask = this.getMainTaskWhenHyperMetroIsActive(recoveryTasks, task, isMainRecoveryTask, isAnotherOpenSuccess, opInfo);
                this.doCreateSubProcessors(subProcessors, opInfo, recoveryTask);
                hypermetroOpInfoList.add(opInfo);
                continue;
            }
            if (opInfo.getSyncDirection() == XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_LOCAL_TO_REMOTE.getValue()) {
                recoveryTask = this.getMainTaskWhenTaskIsActive(task, isMainRecoveryTask);
                this.doCreateSubProcessors(subProcessors, opInfo, recoveryTask);
                hypermetroOpInfoList.add(opInfo);
                continue;
            }
            if (opInfo.getSyncDirection() != XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_REMOTE_TO_LOCAL.getValue()) continue;
            recoveryTask = this.getMainTaskWhenTaskIsNotActive(recoveryTasks, task, isMainRecoveryTask, isAnotherOpenSuccess, opInfo);
            this.doCreateSubProcessors(subProcessors, opInfo, recoveryTask);
            hypermetroOpInfoList.add(opInfo);
        }
    }

    private RecoveryTask getMainTaskWhenHyperMetroIsActive(Collection<RecoveryTask> recoveryTasks, RecoveryTask task, boolean isMainRecoveryTask, boolean isAnotherOpenSuccess, HypermetroOpInfo opInfo) {
        if (isAnotherOpenSuccess && isMainRecoveryTask) {
            LOGGER.info((Object)"Two ports is open success, this is main RecoveryTask, id =%s.", new Object[]{task.getProtectId()});
            return task;
        }
        if (isAnotherOpenSuccess) {
            LOGGER.warn((Object)"Two ports is open success, this is slave RecoveryTask, id =%s.", new Object[]{task.getProtectId()});
            this.changeHypermetroOpInfo(opInfo);
            return this.getMainRecoveryTask(recoveryTasks, task);
        }
        if (isMainRecoveryTask) {
            LOGGER.warn((Object)"One ports is open success, this is main RecoveryTask, id =%s.", new Object[]{task.getProtectId()});
            return task;
        }
        LOGGER.warn((Object)"One ports is open success, this is slave RecoveryTask, id =%s, occur swap.", new Object[]{task.getProtectId()});
        this.doChangeMainAndSlave(task.getTgtDevcieId(), task.getDrRingId());
        return task;
    }

    private void changeHypermetroOpInfo(HypermetroOpInfo opInfo) {
        opInfo.setPrimary(!opInfo.isPrimary());
    }

    private RecoveryTask getMainTaskWhenTaskIsNotActive(Collection<RecoveryTask> recoveryTasks, RecoveryTask task, boolean isMainRecoveryTask, boolean isAnotherOpenSuccess, HypermetroOpInfo opInfo) {
        if (!isAnotherOpenSuccess) {
            LOGGER.error((Object)"HyperMetro status is not normal, active site's ports open failed.");
            throw new LegoCheckedException(1677929522L);
        }
        if (isMainRecoveryTask) {
            LOGGER.warn((Object)"HyperMetro status is not normal, active site matches task.");
            this.doChangeMainAndSlave(task.getTgtDevcieId(), task.getDrRingId());
            this.changeHypermetroOpInfo(opInfo);
            return this.getMainRecoveryTask(recoveryTasks, task);
        }
        LOGGER.warn((Object)"HyperMetro status is not normal, active site matches task.");
        this.changeHypermetroOpInfo(opInfo);
        return this.getMainRecoveryTask(recoveryTasks, task);
    }

    private RecoveryTask getMainTaskWhenTaskIsActive(RecoveryTask task, boolean isMainRecoveryTask) {
        if (isMainRecoveryTask) {
            LOGGER.warn((Object)"HyperMetro status is not normal, active site matches task.");
            return task;
        }
        LOGGER.warn((Object)"HyperMetro status is not normal, active site matches task.");
        this.doChangeMainAndSlave(task.getTgtDevcieId(), task.getDrRingId());
        return task;
    }

    private void doChangeMainAndSlave(String devSn, String drRingId) {
        IStorageDrStarManager drStarManager = StorageDrStarManagerProxy.getInstance().getStorageDrStarManager(devSn);
        drStarManager.swapDrStar(devSn, drRingId);
    }

    private HyperMetroConsistentGroup getHyperMetroCg(RecoveryTask siteABo, RecoveryProcessorContext context) {
        String hyperMetroId = this.getHyperMetroId(siteABo, context);
        IStorageHyperMetroManager hyperMetroManager = (IStorageHyperMetroManager)ServiceLocator.getInstance().getService(IStorageHyperMetroManager.class);
        return hyperMetroManager.queryHyperMetroConsistentGroupOnRemote(siteABo.getTgtDevcieId(), siteABo.getSrcDeviceId(), hyperMetroId);
    }

    private HyperMetroPair getHyperMetro(RecoveryTask siteABo, RecoveryProcessorContext context) {
        String hyperMetroId = this.getHyperMetroId(siteABo, context);
        IStorageHyperMetroManager hyperMetroManager = (IStorageHyperMetroManager)ServiceLocator.getInstance().getService(IStorageHyperMetroManager.class);
        return hyperMetroManager.queryHyperMetroPairOnRemote(siteABo.getTgtDevcieId(), siteABo.getSrcDeviceId(), hyperMetroId, null);
    }

    private String getHyperMetroId(RecoveryTask siteABo, RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        String drRingId = siteABo.getDrRingId();
        if (VerifyUtil.isEmpty((String)drRingId)) {
            LOGGER.error((Object)"Dr ringId is empty, pg name: %s, RecoveryTask id.", new Object[]{pg.getName(), siteABo.getProtectId()});
            throw new LegoCheckedException(2117645L);
        }
        IStorageDrStarManager drStarManager = StorageDrStarManagerProxy.getInstance().getStorageDrStarManager(siteABo.getTgtDevcieId());
        List drStarMemberInfos = drStarManager.getDrStarMemberInfos(siteABo.getTgtDevcieId(), drRingId);
        String hyperMetroId = "";
        for (HyperDRRingMember drStarMemberInfo : drStarMemberInfos) {
            if (!DrmEnumDefine.HyperDrRingMemberType.HYPER_METRO.getValue().equals(drStarMemberInfo.getFeatureType())) continue;
            hyperMetroId = drStarMemberInfo.getId();
        }
        if (VerifyUtil.isEmpty((String)hyperMetroId)) {
            LOGGER.error((Object)"HyperMetro id is empty, pg name: %s., RecoveryTask id.", new Object[]{pg.getName(), siteABo.getProtectId()});
            throw new LegoCheckedException(2117645L);
        }
        return hyperMetroId;
    }

    private boolean isMainRecoveryTask(RecoveryTask task) {
        IRecoveryProcessHandler recoveryProcessHandler = null;
        IRecoveryProcessBaseHandler recoveryProcessBaseHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        if (recoveryProcessBaseHandler instanceof IRecoveryProcessHandler) {
            recoveryProcessHandler = (IRecoveryProcessHandler)recoveryProcessBaseHandler;
        }
        List targetLuns = recoveryProcessHandler.querySyncStatus(task.getSrcDeviceId(), task.getTgtDevcieId(), task.getProtectId(), !VerifyUtil.isEmpty((String)task.getConsistentGroupId()));
        for (ReplicationTargetLun repTargetLun : targetLuns) {
            if (XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue() != repTargetLun.getPairStatus().intValue()) continue;
            LOGGER.info((Object)"This is the slave chain, RecoveryTask pair id=%s.", new Object[]{task.getProtectId()});
            return false;
        }
        return true;
    }

    private Collection<RecoveryTask> getMainRecoveryTask(Collection<RecoveryTask> recoveryTasks, String devSn) {
        ArrayList<RecoveryTask> mainTasks = new ArrayList<RecoveryTask>();
        for (RecoveryTask task : recoveryTasks) {
            if (!task.getSrcDeviceId().equals(devSn)) continue;
            mainTasks.add(task);
        }
        if (mainTasks.isEmpty()) {
            LOGGER.error((Object)"Failed get main RecoveryTask, devSn=%s. ", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(2117645L);
        }
        return mainTasks;
    }

    private RecoveryTask getMainRecoveryTask(Collection<RecoveryTask> recoveryTasks, RecoveryTask openedTask) {
        Collection tempTasks = recoveryTasks.stream().filter(task -> !task.getSrcDeviceId().equals(openedTask.getSrcDeviceId()) && task.getTgtStorageIds().contains(openedTask.getTgtStorageIds().iterator().next())).collect(Collectors.toList());
        if (tempTasks.size() == 0) {
            LOGGER.error((Object)"Failed get main RecoveryTask, devSn=%s. ", new Object[]{SecurityUtil.desensitizeId((String)openedTask.getSrcDeviceId())});
            throw new LegoCheckedException(2117645L);
        }
        return tempTasks.stream().findFirst().orElse(null);
    }

    private void doCreateSubProcessors(List<RecoveryProcessor> subProcessors, HypermetroOpInfo opInfo, RecoveryTask recoveryTask) {
        opInfo.setDevSn(this.getDeviceId());
        opInfo.setRemoteDevSn(recoveryTask.getSrcDeviceId());
        if (opInfo.getRunningStatus() == XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()) {
            DisableHyperMetroOnRemoteSubProcessor disableProcessor = this.generateDisableHyperMetroOnRemoteSubProcessor(opInfo, recoveryTask);
            subProcessors.add((RecoveryProcessor)disableProcessor);
        }
    }

    private DisableHyperMetroOnRemoteSubProcessor generateDisableHyperMetroOnRemoteSubProcessor(HypermetroOpInfo opInfo, RecoveryTask recoveryTask) {
        DisableHyperMetroOnRemoteSubProcessor processor = new DisableHyperMetroOnRemoteSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setDeviceId(this.getDeviceId());
        processor.setRemoteDeviceId(recoveryTask.getSrcDeviceId());
        processor.setPairId(opInfo.getId());
        processor.setIsConsistentGroup(opInfo.isConsistentGroup());
        processor.setRunningState(opInfo.getRunningStatus());
        processor.setIsNeedSave(true);
        processor.setIsNeedCreateDetail(true);
        processor.setIsPrimary(opInfo.isPrimary());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setVstoreId(opInfo.getVstoreId());
        return processor;
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DisableHyperMetroProcessor.sr.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DisableHyperMetroProcessor.pm.des");
        }
    }

    public String getRecoveryTasksKey() {
        return super.getRecoveryTasksKey();
    }

    protected Collection<RecoveryTask> getRemoteRecoveryTasks(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        return RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getRecoveryTasks(recoveryPlan);
    }
}

