/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.SyncReplicationSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ReprotectSynchronizeManager {
    private static final Log logger = LogFactory.getInstance(ReprotectSynchronizeManager.class);
    private static final String ALL_RELATED_REPLICATION_PAIRS = "all-related-replication-pairs";
    private static final String STANDBY = "standby";
    private RecoveryProcessor parentProc;

    public ReprotectSynchronizeManager(RecoveryProcessor parentProc) {
        this.setParentProc(parentProc);
    }

    public RecoveryProcessor getParentProc() {
        return this.parentProc;
    }

    public void setParentProc(RecoveryProcessor parentProc) {
        this.parentProc = parentProc;
    }

    public Set<RecoveryProcessor> createSyncReplicationProcessors(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, boolean isNeedReverse) {
        ProtectGroup pg;
        boolean isDRRing;
        HashSet<RecoveryProcessor> syncReplicationSubProcessors = new HashSet<RecoveryProcessor>();
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            logger.error((Object)("Executing sync replication task failed for plan not existed. PlanId:" + planId));
            return syncReplicationSubProcessors;
        }
        recoveryPlan.getGlobalSettings().put("IS_REVERSE_SYNC", String.valueOf(isNeedReverse));
        IRecoveryProcessBaseHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        Set recoveryTasks = recoveryProcHandler.getRecoveryTasks(recoveryPlan);
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            logger.error((Object)("Generating the recovery tasks failed. PlanId:" + planId));
            return syncReplicationSubProcessors;
        }
        boolean bl = isDRRing = recoveryTasks.stream().map(RecoveryTask::getParams).filter(Objects::nonNull).count() > 0L;
        if (isDRRing) {
            recoveryTasks = this.filterNormalRecoveryTask(recoveryTasks);
        }
        boolean isDrStarAirGap = (pg = recoveryPlan.getProtectGroup()).getTemplate().getType() == 48;
        boolean isRepConsistentGroup = pg.isRepConsistentGroup();
        if (!isDRRing && isDrStarAirGap) {
            recoveryTasks.removeIf(task -> !this.isMainRecoveryTask((RecoveryTask)task, isRepConsistentGroup));
        }
        recoveryTasks = RecoveryTaskUtil.getRootRecoveryTasks(recoveryTasks);
        Collection<RecoveryTask> filterTasks = this.filterRecoveryTasks(recoveryTasks);
        for (RecoveryTask recoveryTask : filterTasks) {
            SyncReplicationSubProcessor processor = this.createSyncReplicationSubProcessor(recoveryTask, planId, procType);
            if (!VerifyUtil.isEmpty((Collection)recoveryTask.getCascadeTasks())) {
                this.buildProcessorCascadeRelation(recoveryTask, (RecoveryProcessor)processor, procType);
            }
            if (!VerifyUtil.isEmpty((Collection)recoveryTask.getParallelTasks())) {
                this.buildProcessorParallelRelation(recoveryTask, syncReplicationSubProcessors, planId, procType);
            }
            syncReplicationSubProcessors.add((RecoveryProcessor)processor);
        }
        return syncReplicationSubProcessors;
    }

    private Collection<RecoveryTask> filterRecoveryTasks(Collection<RecoveryTask> recoveryTasks) {
        ArrayList<RecoveryTask> filterTasks = new ArrayList<RecoveryTask>();
        filterTasks.addAll(recoveryTasks);
        ArrayList<String> replicationIdList = new ArrayList<String>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            if (replicationIdList.contains(recoveryTask.getProtectType() + "-" + recoveryTask.getProtectId())) {
                filterTasks.remove(recoveryTask);
            }
            if (this.isStandbyReplicationPairTask(recoveryTask)) {
                filterTasks.remove(recoveryTask);
                continue;
            }
            replicationIdList.add(recoveryTask.getProtectType() + "-" + recoveryTask.getProtectId());
        }
        return filterTasks;
    }

    private Collection<RecoveryTask> filterNormalRecoveryTask(Collection<RecoveryTask> recoveryTasks) {
        ArrayList<RecoveryTask> candidates = new ArrayList<RecoveryTask>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Map params = recoveryTask.getParams();
            if (params == null) {
                candidates.add(recoveryTask);
                continue;
            }
            Object allRelatedReplicationPairs = params.get(ALL_RELATED_REPLICATION_PAIRS);
            if (allRelatedReplicationPairs == null) {
                candidates.add(recoveryTask);
                continue;
            }
            if (((Boolean)params.get(STANDBY)).booleanValue()) continue;
            candidates.add(recoveryTask);
        }
        return candidates;
    }

    private boolean isMainRecoveryTask(RecoveryTask task, boolean isRepConsistentGroup) {
        IRecoveryProcessHandler recoveryProcessHandler = null;
        IRecoveryProcessBaseHandler recoveryProcessBaseHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        if (recoveryProcessBaseHandler instanceof IRecoveryProcessHandler) {
            recoveryProcessHandler = (IRecoveryProcessHandler)recoveryProcessBaseHandler;
        }
        List targetLuns = recoveryProcessHandler.querySyncStatus(task.getSrcDeviceId(), task.getTgtDevcieId(), task.getProtectId(), isRepConsistentGroup);
        for (ReplicationTargetLun repTargetLun : targetLuns) {
            if (XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue() != repTargetLun.getPairStatus().intValue()) continue;
            logger.info((Object)"This is the slave chain, RecoveryTask pair id=%s.", new Object[]{task.getProtectId()});
            return false;
        }
        return true;
    }

    private boolean isStandbyReplicationPairTask(RecoveryTask recoveryTask) {
        Map params = recoveryTask.getParams();
        if (params == null) {
            return false;
        }
        Object standby = params.get("STANDBY");
        if (!(standby instanceof Boolean)) {
            return false;
        }
        return (Boolean)standby;
    }

    private SyncReplicationSubProcessor createSyncReplicationSubProcessor(RecoveryTask recoveryTask, String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        SyncReplicationSubProcessor processor = new SyncReplicationSubProcessor();
        processor.setPlanId(planId);
        processor.setProcType(procType.getValue());
        processor.setReplicationId(recoveryTask.getProtectId());
        processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
        processor.setCurrentSrcDeviceSN(recoveryTask.getSrcDeviceId());
        processor.setTgtDeviceId(recoveryTask.getTgtDevcieId());
        processor.setCurrentTgtDeviceSN(recoveryTask.getTgtDevcieId());
        processor.setRelationType(recoveryTask.getProtectType());
        processor.setParentProc(this.getParentProc());
        processor.setIsNeedSave(false);
        processor.setIsNeedCreateDetail(true);
        return processor;
    }

    private RecoveryProcessor buildProcessorCascadeRelation(RecoveryTask task, RecoveryProcessor processor, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (null == task.getCascadeTasks()) {
            return processor;
        }
        for (RecoveryTask recoveryTask : task.getCascadeTasks()) {
            if (null == recoveryTask || null != recoveryTask.getParams() && !Boolean.FALSE.equals(recoveryTask.getParams().get(STANDBY))) continue;
            SyncReplicationSubProcessor cascadeSyncProcessor = this.createSyncReplicationSubProcessor(recoveryTask, processor.getPlanId(), procType);
            processor.setNextCascadeProcessor((RecoveryProcessor)cascadeSyncProcessor);
            this.buildProcessorCascadeRelation(recoveryTask, (RecoveryProcessor)cascadeSyncProcessor, procType);
        }
        return processor;
    }

    private void buildProcessorParallelRelation(RecoveryTask recoveryTask, Set<RecoveryProcessor> syncReplicationSubProcessors, String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        for (RecoveryTask task : recoveryTask.getParallelTasks()) {
            Map params = task.getParams();
            if (null != params && params.size() > 0) {
                Object allRelatedReplicationPairs = params.get(ALL_RELATED_REPLICATION_PAIRS);
                Object isStandBy = params.get(STANDBY);
                if (null == allRelatedReplicationPairs || null == isStandBy || ((Boolean)isStandBy).booleanValue()) continue;
                SyncReplicationSubProcessor parallelSubProcessor = this.createSyncReplicationSubProcessor(task, planId, procType);
                syncReplicationSubProcessors.add((RecoveryProcessor)parallelSubProcessor);
                continue;
            }
            SyncReplicationSubProcessor parallelSubProcessor = this.createSyncReplicationSubProcessor(task, planId, procType);
            syncReplicationSubProcessors.add((RecoveryProcessor)parallelSubProcessor);
        }
    }
}

