/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.RollbackHyperVaultSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.RollbackNasSnapshotSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RollbackNasSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6668957141791350595L;
    private static final Log logger = LogFactory.getInstance(RollbackNasSnapshotProcessor.class);
    private String snapShotInfos;

    public String getSnapShotInfos() {
        return this.snapShotInfos;
    }

    public void setSnapShotInfos(String snapShotInfos) {
        this.snapShotInfos = snapShotInfos;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateSubProcessors(context);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.updateProcessDetail("ism.drm.recovery.no.rollback.snapshot", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
        recoveryTemplate.process(context);
        boolean result = this.calcProcessResultBySubProc();
        if (result) {
            this.invalidReplicaAfterRollback(context);
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            result = false;
            RecoveryServiceUtil.setProtectGroupsInvalidByPlan((RecoveryPlan)context.getRecoveryPlan(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        }
        return result;
    }

    protected void invalidReplicaAfterRollback(RecoveryProcessorContext context) {
        try {
            RecoveryPlan rp = context.getRecoveryPlan();
            Iterator iterator = rp.getProtectGroups().iterator();
            if (!iterator.hasNext()) {
                logger.error((Object)("pg is empty. pgId: " + context.getRecoveryLogId()), 90160758784001L);
                return;
            }
            ProtectGroup pg = (ProtectGroup)iterator.next();
            if (VerifyUtil.isEmpty((Object)context.getAttribute("REPLICA_ID"))) {
                logger.error((Object)("Replica ID is null or empty. pgId: " + pg.getUuid()), 90160758784001L);
                return;
            }
            String replicaId = context.getAttribute("REPLICA_ID").toString();
            List rollbackReplicas = RecoveryProcessUtil.getAllReplicaById((RecoveryPlan)rp, (String)replicaId);
            if (null == rollbackReplicas) {
                logger.error((Object)("Without certain replica in the protectGroup. pgId: " + pg.getUuid()), 90160758784001L);
                return;
            }
            Iterator repIterator = rollbackReplicas.iterator();
            if (!repIterator.hasNext()) {
                logger.error((Object)("Without certain replica in the protectGroup. pgId: " + pg.getUuid()), 90160758784001L);
                return;
            }
            ProtectGroupReplica rollbackReplica = (ProtectGroupReplica)repIterator.next();
            if (this.isSkipInvalidReplica(rollbackReplica)) {
                return;
            }
            List<String> replicaIdsAfter = this.needToInValidReplicIds(rollbackReplica, pg);
            if (VerifyUtil.isEmpty(replicaIdsAfter)) {
                logger.info((Object)("no replicaneed to invalid. pgId: " + pg.getUuid()), 90160758784001L);
                return;
            }
            IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            protectGroupService.invalidProtectGroupReplica(pg.getUuid(), replicaIdsAfter);
        }
        catch (Exception e) {
            logger.error((Object)("Invalid replica result failed. " + context.getRecoveryLogId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private boolean isSkipInvalidReplica(ProtectGroupReplica rollbackReplica) {
        StorageUnit storageUnit;
        String productModel;
        if (VerifyUtil.isEmpty((Object)rollbackReplica) || VerifyUtil.isEmpty((String)rollbackReplica.getProductArray())) {
            logger.info((Object)"roll back replica param error, default not skip invalid replica");
            return false;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", rollbackReplica.getProductArray());
        List storageUnits = CommonDAOLocator.getMoDao().findMoBy(StorageUnit.class, props);
        if (null != storageUnits && null != (productModel = (storageUnit = (StorageUnit)storageUnits.get(0)).getProductModel()) && productModel.contains("Dorado")) {
            logger.info((Object)"dorado nas no need invalid after replica");
            return true;
        }
        return false;
    }

    protected List<String> needToInValidReplicIds(ProtectGroupReplica rollbackReplica, ProtectGroup pg) {
        ArrayList<String> replicaIdsAfter = new ArrayList<String>();
        if (rollbackReplica.getProtectLocation() == DrmEnumDefine.ProtectLocation.B_B.getValue()) {
            return replicaIdsAfter;
        }
        Set pgReplicas = pg.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)pgReplicas)) {
            logger.error((Object)("PGReplica is null. pgId: " + pg.getUuid()), 90160758784001L);
            return replicaIdsAfter;
        }
        for (ProtectGroupReplica replica : pgReplicas) {
            if (DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue() != replica.getStatus() || replica.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_A.getValue() || replica.getTimeStamp().compareTo(rollbackReplica.getTimeStamp()) <= 0) continue;
            replicaIdsAfter.add(replica.getId());
        }
        return replicaIdsAfter;
    }

    private boolean updateSubProcessors(RecoveryProcessorContext context) {
        Collection recoveryTasks = context.getRecoveryTask("recoveryTasks");
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            return true;
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.getChildProc().clear();
        }
        ProtectGroup protectGroup = this.getProtectGroup(context);
        int type = protectGroup.getTemplate().getType();
        ProtectionRelation protectionRelation = this.getProtectionRelation(protectGroup);
        HashSet<RollbackNasSnapshotSubProcessor> subProcessors = new HashSet<RollbackNasSnapshotSubProcessor>();
        for (RecoveryTask task : recoveryTasks) {
            if ("NONE".equals(task.getProtectId())) {
                logger.warn((Object)"The snap id is null, do not create subprocess");
                continue;
            }
            RollbackNasSnapshotSubProcessor processor = this.buildSubProcessor(type, task, protectionRelation);
            subProcessors.add(processor);
            if (!this.isNasAirGap(protectGroup)) continue;
            this.saveSnapshotLastRollbackInfo(context, processor);
        }
        this.setChildProc(subProcessors);
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private boolean isNasAirGap(ProtectGroup protectGroup) {
        return protectGroup.getTemplate().getType() == 45 || protectGroup.getTemplate().getType() == 46;
    }

    private ProtectGroup getProtectGroup(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Iterator pgIterator = recoveryPlan.getProtectGroups().iterator();
        if (!pgIterator.hasNext()) {
            logger.error((Object)"PgIterator is empty.The name of recovery plan is %s", new Object[]{recoveryPlan.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectGroup)pgIterator.next();
    }

    private ProtectionRelation getProtectionRelation(ProtectGroup protectGroup) {
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        Map props = policyTemplate.getProps();
        String prStr = (String)props.get("protectionRelation");
        ProtectionRelation protectionRelation = null;
        if (!VerifyUtil.isEmpty((String)prStr)) {
            protectionRelation = ProtectionRelationJsonConverter.toProtectionRelation((String)prStr);
        }
        return protectionRelation;
    }

    private RollbackNasSnapshotSubProcessor buildSubProcessor(int templateType, RecoveryTask recoveryTask, ProtectionRelation protectionRelation) {
        RollbackNasSnapshotSubProcessor processor = 17 == templateType || 28 == templateType ? new RollbackHyperVaultSubProcessor() : new RollbackNasSnapshotSubProcessor();
        processor.setProcName(processor.getName());
        if (!VerifyUtil.isEmpty((Object)protectionRelation)) {
            processor.setSrcDeviceId(protectionRelation.getSrcResourceProviderSn());
        }
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDeviceId(recoveryTask.getSrcDeviceId());
        Set srcStorageIds = recoveryTask.getSrcStorageIds();
        if (VerifyUtil.isEmpty((Collection)srcStorageIds)) {
            logger.error((Object)"SrcStorageIds is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        processor.setResourceId((String)srcStorageIds.iterator().next());
        processor.setSnapshotId(recoveryTask.getProtectId());
        processor.setSnapshotName(recoveryTask.getProtectId());
        return processor;
    }

    private void saveSnapshotLastRollbackInfo(RecoveryProcessorContext context, RollbackNasSnapshotSubProcessor processor) {
        String snapshotId = processor.getSnapshotId();
        String resourceId = processor.getResourceId();
        String deviceId = processor.getDeviceId();
        IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(deviceId);
        Snapshot snapshot = fileSystemSnapshotManagerProxy.querySpecificSnapshot(deviceId, resourceId, snapshotId);
        if (VerifyUtil.isEmpty((Object)snapshot)) {
            logger.error((Object)"The snapshot(id:%s) to be rolled back does not exist.", new Object[]{snapshotId});
            throw new LegoCheckedException(1073947394L);
        }
        context.getSnapshotLastRollBackTimeMap().put(snapshotId, snapshot.getRollbackEndTime());
    }
}

