/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;

public class RollbackSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6872830667401920622L;
    private String deviceId;
    private String snapshotId;
    private String snapshotName;
    private String lunId;
    private String lunName;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        OperationResult result = this.rollbackSnapshot(context);
        if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    protected String generateResultKey() {
        return RecoveryProcessResult.getRollbackSnapshotResultKey((String)this.getDeviceId(), (String)this.getLunId(), (String)this.getSnapshotId());
    }

    protected OperationResult rollbackSnapshot(RecoveryProcessorContext context) {
        OperationResult operationResult;
        Lun lun;
        String restoreSpeed = (String)context.getRecoveryPlan().getGlobalSettings().get("ROLLBACK_RATE");
        if (VerifyUtil.isEmpty((String)restoreSpeed)) {
            restoreSpeed = String.valueOf(4);
        }
        if ((lun = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getTargetLunById(this.getDeviceId(), this.getLunId())) == null) {
            this.updateProcessName("ism.drm.recovery.snapshot.rollback.failed");
            OperationResult operationResult2 = this.checkOperationObject(this.getDeviceId());
            return operationResult2;
        }
        this.updateProcessNameParams(new String[]{lun.getName(), this.getSnapshotName()});
        this.setLunName(lun.getName());
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setId(this.getSnapshotId());
        arraySnapshot.setSnapshotName(this.getSnapshotName());
        arraySnapshot.setSrcResourceId(Integer.valueOf(Integer.parseInt(lun.getLunId())));
        int protectType = (Integer)context.getAttribute("protectType");
        if (protectType == ReplicationConstantDefine.LocalTaskType.HYPERCDP.getValue()) {
            IStorageHyperCDPManager manager = StorageHyperCDPManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.getDeviceId());
            operationResult = manager.restoreSnapshot(this.getDeviceId(), (Snapshot)arraySnapshot, restoreSpeed);
        } else {
            IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.getDeviceId());
            operationResult = proxy.restoreSnapshot(this.getDeviceId(), (Snapshot)arraySnapshot, restoreSpeed);
        }
        return operationResult;
    }

    private OperationResult checkOperationObject(String tgtDeviceId) {
        String[] errorParams = new String[]{this.getLunId(), tgtDeviceId};
        String errorCode = "lego.err.1073948685";
        return new OperationResult("Rollback", true, false, errorCode, errorParams);
    }
}

