/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.SwapVstoreHyperMetroPairProcessor;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Set;

public class SwapVstoreHyperMetroPairForVaultProcessor
extends SwapVstoreHyperMetroPairProcessor {
    private static final Log logger = LogFactory.getInstance(SwapVstoreHyperMetroPairForVaultProcessor.class);

    @Override
    protected boolean isNeedSwitch(RecoveryProcessorContext context, VstoreHyperMetroPair vstoreHyperMetroPair) {
        Integer activeOrPassive;
        String active = vstoreHyperMetroPair.getActiveOrPassive();
        if (VerifyUtil.isEmpty((String)active)) {
            HyperMetroDomain hyperMetroDomain = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getHyperMetroDomainById(vstoreHyperMetroPair.getDomainId(), false);
            active = hyperMetroDomain.getServiceStatus();
        }
        if ((activeOrPassive = NumberUtil.convertToInteger((Object)active)) != null && activeOrPassive.equals(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue())) {
            logger.info((Object)"The vstoreHyperMetroPair has been switched!");
            return false;
        }
        return true;
    }

    @Override
    protected VstoreHyperMetroPair getVstorePairInfo(RecoveryProcessorContext context) {
        VstoreHyperMetroPair vstoreHyperMetroPair = (VstoreHyperMetroPair)context.getAttribute("vstoreHyperMetroPair");
        vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId((String)context.getAttribute("hyperMetroDeviceSn"), vstoreHyperMetroPair.getVstorePairId());
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            logger.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        return vstoreHyperMetroPair;
    }

    @Override
    protected String getVstorePairId(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set pgs = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)pgs);
        String vStorePairId = (String)pg.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        logger.debug((Object)("getVstorePairId:" + vStorePairId));
        return vStorePairId;
    }

    @Override
    protected boolean checkHyperMetroPairStatus(RecoveryProcessorContext context) {
        return true;
    }
}

