/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.EndRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.SynchronizeHyperMetroOnRemoteSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroOpInfo;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.SanHyperMetroRingAirGapExecuteInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SynchronizeHyperMetroOnRemoteProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4086081583947513428L;
    private static final Log LOGGER = LogFactory.getInstance(SynchronizeHyperMetroOnRemoteProcessor.class);
    private String deviceId;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        if (pg == null || pg.getTemplate() == null) {
            LOGGER.info((Object)"Pg and template can not be null!");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        int templateType = pg.getTemplate().getType();
        return this.execSyncHyperMetro(context, templateType);
    }

    private boolean execSyncHyperMetro(RecoveryProcessorContext context, int templateType) {
        if (templateType != 48) {
            LOGGER.error((Object)"Is not 3dc hyper metro air gap.");
            return true;
        }
        SanHyperMetroRingAirGapExecuteInfo recoveryInfo = (SanHyperMetroRingAirGapExecuteInfo)context.getAttribute("SAN_HYPER_METRO_RING_RECOVERY_INFO", SanHyperMetroRingAirGapExecuteInfo.class);
        List hypermetroOpInfoList = recoveryInfo.getHypermetroOpInfoList();
        boolean isContinue = true;
        this.updateSubProcessors(hypermetroOpInfoList, isContinue);
        if (this.getChildProc() == null || this.getChildProc().isEmpty()) {
            this.updateProcessDetail("ism.drm.recovery.no.rollback.snapshot", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()), (boolean)false);
        recoveryTemplate.process(context);
        this.calcProcessResultBySubProc();
        if (this.getNextProcessor() instanceof EndRecoveryProcessor) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private boolean updateSubProcessors(List<HypermetroOpInfo> hypermetroOpInfoList, boolean isContinue) {
        if (VerifyUtil.isEmpty(hypermetroOpInfoList)) {
            return true;
        }
        if (this.getChildProc() != null) {
            this.getChildProc().clear();
        }
        HashSet<SynchronizeHyperMetroOnRemoteSubProcessor> subProcessors = new HashSet<SynchronizeHyperMetroOnRemoteSubProcessor>();
        for (HypermetroOpInfo hypermetroOpInfo : hypermetroOpInfoList) {
            SynchronizeHyperMetroOnRemoteSubProcessor processor = new SynchronizeHyperMetroOnRemoteSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDeviceId(hypermetroOpInfo.getDevSn());
            processor.setRemoteDeviceId(hypermetroOpInfo.getRemoteDevSn());
            processor.setPairId(hypermetroOpInfo.getId());
            processor.setIsConsistentGroup(hypermetroOpInfo.isConsistentGroup());
            processor.setVstoreId(hypermetroOpInfo.getVstoreId());
            processor.setAllAwaysContinue(isContinue);
            subProcessors.add(processor);
        }
        this.setChildProc(subProcessors);
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeHyperMetroProcessor.des");
    }
}

