/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.recovery.process.SynchronizeHyperMetroSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;

public class SynchronizeHyperMetroOnRemoteSubProcessor
extends SynchronizeHyperMetroSubProcessor {
    private static final long serialVersionUID = -2277122128872896474L;
    private static final Log LOGGER = LogFactory.getInstance(SynchronizeHyperMetroOnRemoteSubProcessor.class);
    private String remoteDeviceId;

    public String getRemoteDeviceId() {
        return this.remoteDeviceId;
    }

    public void setRemoteDeviceId(String remoteDeviceId) {
        this.remoteDeviceId = remoteDeviceId;
    }

    @Override
    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getPairId()});
        return this.synchronizeHyperMetroPairOnRemote();
    }

    @Override
    protected String generateResultKey() {
        return this.getSynchronizeHyperMetroPairResultKey();
    }

    private boolean synchronizeHyperMetroPairOnRemote() {
        boolean isResult;
        try {
            DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.getDeviceId());
            if (drResource == null) {
                LOGGER.error((Object)"DrResource is null, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)this.getDeviceId())});
                return false;
            }
            IStorageHyperMetroManager manager = null;
            IStorageHyperMetroBaseManager baseManager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(this.getDeviceId());
            if (baseManager instanceof IStorageHyperMetroManager) {
                manager = (IStorageHyperMetroManager)baseManager;
            }
            manager.synchronizeOnRemote(this.getDeviceId(), this.getRemoteDeviceId(), this.getPairId(), this.getIsConsistentGroup().booleanValue(), this.getVstoreId());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            isResult = true;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Swap HyperMetro pair failed. PairId:%s, DevSN:%s, isCg:%s, error", new Object[]{this.getPairId(), SecurityUtil.desensitizeId((String)this.getDeviceId()), this.getIsConsistentGroup(), ExceptionUtil.getErrorMessage((Throwable)e)});
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            isResult = false;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Swap HyperMetro pair failed. PairId:%s, IsConsistentGroup:%s, DevSN:", new Object[]{this.getPairId(), this.getIsConsistentGroup(), SecurityUtil.desensitizeId((String)this.getDeviceId()), ExceptionUtil.getErrorMessage((Throwable)e)});
            this.updateProcessDetail("lego.err.1073948758", new String[]{this.getPairId()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            isResult = false;
        }
        if (this.isAllAwaysContinue()) {
            return true;
        }
        return isResult;
    }

    private String getSynchronizeHyperMetroPairResultKey() {
        StringBuilder builder = new StringBuilder();
        builder.append("SynchronizeHyperMetroPair:");
        builder.append("DeviceId=");
        builder.append(this.getDeviceId());
        builder.append(";");
        builder.append("RemoteDeviceId=");
        builder.append(this.getRemoteDeviceId());
        builder.append(";");
        builder.append("PairId=");
        builder.append(this.getPairId());
        builder.append("IsConsistentGroup=");
        builder.append(this.getIsConsistentGroup());
        return builder.toString();
    }
}

