/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.resource.service.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.sdk.constant.DeviceType;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.ScopeManagerUtil;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@ServiceBoundInfo(methodName="onBind", targetBeanName="siteResourceServiceProxy", properties="resType:ism.deviceType.storage.mainType")
public class StorageSiteResourceServiceImpl
implements ISiteResourceService {
    private static final List<String> HVS_REST_DEVICE_TYPE_NAMES = new ArrayList<String>();
    private static final Log LOGGER = LogFactory.getInstance(StorageSiteResourceServiceImpl.class);

    public void isResourceUsed(Long moId) {
        ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).checkStorageUsed(moId);
    }

    public void registerResource(Site site, String[] resSns) {
        if (null == site) {
            throw new LegoCheckedException(1073947393L);
        }
        if (0 == site.getSiteType() && VerifyUtil.isEmpty((Object[])resSns)) {
            return;
        }
        if (site.getSiteType() != 0) {
            LOGGER.error((Object)("the type is error:" + site.getSiteType()), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.saveStorageIntoDB(site, resSns);
    }

    private void saveStorageIntoDB(Site site, String[] resSns) {
        if (VerifyUtil.isEmpty((Object)site) || VerifyUtil.isEmpty((Object[])resSns)) {
            return;
        }
        ArrayList<DrStorage> drStorages = new ArrayList<DrStorage>(resSns.length);
        for (String storageSn : resSns) {
            NetworkEntity entity = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)storageSn);
            if (null == entity) {
                LOGGER.error((Object)("the entity is not existed:" + storageSn), 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            if (!(entity instanceof StorageNE)) continue;
            if (null != ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(storageSn, "ism.deviceType.storage.mainType")) {
                LOGGER.error((Object)("the storage has been registered:" + storageSn), 90160758787071L);
                throw new LegoCheckedException(1073947671L);
            }
            DrStorage drStorage = (DrStorage)this.getDrResourceByMo(entity);
            drStorage.setSiteId(site.getSiteId());
            drStorage.setIsAirGapResource(site.getIsAirGapSite());
            drStorages.add(drStorage);
        }
        SiteResourceManagerUtil.checkMaxRes((int)2, (int)drStorages.size());
        CommonDAOLocator.getBaseDao().saveOrUpdateAll(drStorages);
    }

    public void refreshResouce(Site site) {
    }

    public int sum(String siteId, Long userId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            return 0;
        }
        List sns = SiteResourceManagerUtil.getResourceSNBySiteId((String)siteId, (int)2);
        if (VerifyUtil.isEmpty((Collection)sns)) {
            return 0;
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (!VerifyUtil.isEmpty((Object)site) && site.getSiteType() == 0) {
            sns = ScopeManagerUtil.filterSNByScope((List)sns, (Long)userId, StorageNE.class);
        }
        return sns.size();
    }

    public <T extends ManagedObject> DrResource getDrResourceByMo(T mo) {
        if (!(mo instanceof StorageNE)) {
            return null;
        }
        DrStorage storage = new DrStorage();
        StorageNE ne = (StorageNE)mo;
        storage.setDeviceSn(ne.getSn());
        storage.setIpAddress(ne.getLinkIp());
        storage.setName(ne.getName());
        storage.setStatus(String.valueOf(ne.getStatus()));
        storage.setProductModel(ne.getSubType());
        storage.setDbId(UUIDGenerator.getUUID());
        return storage;
    }

    public DrResource getDrResourceBySn(String devSn) {
        List storages = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrStorage where deviceSn=?", new Object[]{devSn});
        if (null != storages && !storages.isEmpty()) {
            return (DrResource)storages.get(0);
        }
        return null;
    }

    public List<DrResource> getDrResourceBySite(Integer siteType) {
        List drStorages = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrStorage where siteId in (select siteId from Site where siteType = ?)", new Object[]{siteType});
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        if (null != drStorages) {
            result.addAll(drStorages);
        }
        return result;
    }

    public List<DrResource> getDrResourceBySite(String siteId) {
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrStorage where siteId=?", new Object[]{siteId});
        if (null == resources) {
            return result;
        }
        for (Object dr : resources) {
            result.add((DrResource)dr);
        }
        return result;
    }

    static {
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS85TC00.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS88TC00.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.XVETV2R2.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS_18500.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS_18800.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS_18800F.getName());
    }
}

