/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.storage.topology.ArrayTopoBuilder;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.storage.topology.ReplicationLinkSkin;
import com.huawei.ism.drm.topo.element.LunElement;
import com.huawei.ism.drm.topo.element.NasFileSystemElement;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.skin.LinkSkin;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.twaver.IData;
import com.huawei.twaver.Link;
import com.huawei.twaver.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-15##PolicyTemplate-18##PolicyTemplate-19##PolicyTemplate-23##PolicyTemplate-28##PolicyTemplate-31")
public class ArrayDoubleActiveTopoBuilder
extends ArrayTopoBuilder {
    public static final Log logger = LogFactory.getInstance(ArrayDoubleActiveTopoBuilder.class);
    private static final double LINK_FROM_XOFFSET = -10.0;
    private static final double LINK_FROM_YOFFSET = 1.0;
    private static final double OUTLINE_ALPHA = 0.0;
    private static final double STORAGE_Y_SONS_GAP = 14.0;
    private static final int SNAP_X_OFFSET_ONE = 1;
    private static final int SNAP_X_OFFSET_TWO = 10;
    private static final int SNAP_X_OFFSET_THREE = 11;

    public void buildTopo(TopoBaseContext context) {
        boolean hasRoot;
        this.checkParam(context);
        boolean bl = hasRoot = context.getProtectGroup().getPoType() != 11 && context.getProtectGroup().getPoType() != 14;
        if (context.getRootNode() == null) {
            hasRoot = false;
            this.initialize(context);
        }
        ProtectGroup pg = context.getProtectGroup();
        List poStorageWwns = this.getPoStorageWwns(pg);
        HashSet<StorageResource> resourceList = new HashSet<StorageResource>();
        Node arraySiteStyle = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)("hyperMetroStyle:" + pg.getUuid()));
        arraySiteStyle.setClient("sonsGap", 14.0);
        Node root = (Node)context.addChild((IData)context.getRootNode(), (IData)arraySiteStyle);
        if (this.getStorageResourceType(pg) == DrmEnumDefine.ResourceTypeE.NAS.getValue()) {
            String devSn = null;
            HashSet<String> resourceIds = new HashSet<String>();
            for (ProtectObject protectObject : context.getProtectGroup().getPolist()) {
                for (ProtectObjectStorageInfo storageInfo : protectObject.getUsedStorageResourceSet()) {
                    devSn = storageInfo.getResourceProviderSN();
                    resourceIds.add(storageInfo.getResourceId());
                }
            }
            List hmList = this.getHyperMetroPairList(devSn, new ArrayList(resourceIds));
            String vstorePairId = (String)context.getProtectGroup().getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            List srList = StorageResourceServiceRouter.getInstance().getNasHyperMetroStoreageList(devSn, vstorePairId, hmList);
            hmList.addAll(this.getTgtHyperMetroPair(srList, hmList));
            resourceList.addAll(srList);
            this.initNasNodeData(context, resourceList, root, hasRoot, hmList);
        } else {
            for (String wwn : poStorageWwns) {
                resourceList.addAll(this.getSanHyperMetroStoreageList(context, wwn));
            }
            this.initLunNodedata(context, resourceList, root, hasRoot);
        }
        this.buildReplicationTopo(context, root);
    }

    private List<HyperMetroPair> getTgtHyperMetroPair(List<StorageResource> srList, List<HyperMetroPair> hmList) {
        if (VerifyUtil.isEmpty(hmList) || VerifyUtil.isEmpty(srList)) {
            logger.error((Object)"hyperMetropair and resourceList can not be null");
            return null;
        }
        HyperMetroPair pair = (HyperMetroPair)CommonUtil.getFirstElement(hmList);
        HashSet<String> remoteIds = new HashSet<String>();
        String remoteDevSn = null;
        for (StorageResource resource : srList) {
            if (resource.getDevSn().equals(pair.getDevSn())) continue;
            remoteIds.add(resource.getResourceId());
            remoteDevSn = resource.getDevSn();
        }
        return this.getHyperMetroPairList(remoteDevSn, new ArrayList(remoteIds));
    }

    private void initNasNodeData(TopoBaseContext context, Set<StorageResource> resourceList, Node root, boolean hasRoot, List<HyperMetroPair> pairList) {
        ProtectGroup pg = context.getProtectGroup();
        HashMap<String, List<ProtectGroupReplica>> replicaMap = new HashMap<String, List<ProtectGroupReplica>>();
        HashMap<String, Integer> locationMap = new HashMap<String, Integer>();
        this.getReplicaInfo(context, replicaMap, locationMap);
        HashSet<String> siteList = new HashSet<String>();
        HashSet<String> wwnSet = new HashSet<String>();
        Map dataMap = this.getNasHyperMetroPairMap(pg, pairList);
        Map vstoreMap = this.getVstoreIdMap(pairList);
        String vaultDevSn = this.getVaultLocalDevSN(pg);
        List<StorageResource> sortedResourceList = this.sortStorageResource(vaultDevSn, resourceList);
        for (StorageResource each : sortedResourceList) {
            if (!(each instanceof NasFileSystem)) {
                return;
            }
            NasFileSystem nasfs = (NasFileSystem)each;
            String devSn = nasfs.getDevSn();
            DrStorage drStorage = (DrStorage)this.getDrResource(devSn);
            String srcSiteId = drStorage.getSiteId();
            Site srcSite = context.getSiteService().getSiteById(srcSiteId);
            Node srcStorageNode = this.addStorageNode(context, drStorage, srcSite, root);
            String pairId = this.getHyperPairID(dataMap, (String)vstoreMap.get(devSn), nasfs);
            wwnSet.add(pairId);
            siteList.add(srcSiteId);
            NasFileSystemElement srcNode = new NasFileSystemElement((Object)(srcSiteId + pairId), nasfs);
            context.addChild((IData)srcStorageNode, (IData)srcNode);
            String nodeId = devSn + ":" + nasfs.getResourceId();
            context.bind((Object)nodeId, (Object)(srcSiteId + pairId));
        }
        if (!hasRoot) {
            logger.debug((Object)"add nas link info.");
            this.addHyperMetroLinkInfo(context, siteList, wwnSet, pairList);
        }
        this.buildVaultSnap(context, replicaMap, locationMap, vaultDevSn);
    }

    private List<StorageResource> sortStorageResource(String vaultDevSn, Set<StorageResource> resourceList) {
        if (VerifyUtil.isEmpty((String)vaultDevSn)) {
            return new ArrayList<StorageResource>(resourceList);
        }
        ArrayList<StorageResource> arrayList = new ArrayList<StorageResource>(resourceList.size());
        for (StorageResource storageResource : resourceList) {
            if (storageResource.getDevSn().equals(vaultDevSn)) continue;
            arrayList.add(storageResource);
        }
        for (StorageResource storageResource : resourceList) {
            if (!storageResource.getDevSn().equals(vaultDevSn)) continue;
            arrayList.add(storageResource);
        }
        return arrayList;
    }

    private void buildVaultSnap(TopoBaseContext context, Map<String, List<ProtectGroupReplica>> replicaMap, Map<String, Integer> locationMap, String devSn) {
        ProtectGroup pg = context.getProtectGroup();
        if (pg.getTemplate().getType() != 28 && pg.getTemplate().getType() != 31) {
            return;
        }
        if (VerifyUtil.isEmpty((String)devSn)) {
            return;
        }
        try {
            DrStorage drStorage = (DrStorage)this.getDrResource(devSn);
            String srcSiteId = drStorage.getSiteId();
            Site srcSite = context.getSiteService().getSiteById(srcSiteId);
            for (Map.Entry<String, List<ProtectGroupReplica>> entry : replicaMap.entrySet()) {
                List<ProtectGroupReplica> pgReplicaList = entry.getValue();
                if (VerifyUtil.isEmpty(pgReplicaList) || null == locationMap.get(entry.getKey())) {
                    return;
                }
                String scheduleInfo = TooltipUtil.getScheduleInfo((Schedule)TopoServiceUtil.getSchedule((int)locationMap.get(entry.getKey()), (Set)pg.getTemplate().getSchedules(), (ProtectGroup)pg));
                String siteStyleNodeId = srcSite.getSiteId() + "---" + "Style:unvisible";
                Node siteStyleNode = (Node)context.getElementBox().getDataByID((Object)siteStyleNodeId);
                String storageStyleNodeId = devSn + "---" + "Style:unvisible";
                Node storageStyleNode = (Node)context.getElementBox().getDataByID((Object)storageStyleNodeId);
                storageStyleNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/ic_asynchronous.png");
                storageStyleNode.setToolTip(scheduleInfo);
                this.buildSnapReplicaTopo(context, siteStyleNode, scheduleInfo, storageStyleNode, pgReplicaList);
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("buildSnapTopo failed. RuntimeException msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)"buildSnapTopo failed", 1073947393L);
        }
    }

    private String getVaultLocalDevSN(ProtectGroup pg) {
        if (pg.getTemplate().getType() == 28) {
            List protectionRelations = null;
            String prStr = (String)pg.getTemplate().getProps().get("protectionRelation");
            if (!VerifyUtil.isEmpty((String)prStr)) {
                protectionRelations = ProtectionRelationJsonConverter.toProtectionRelationList((String)prStr);
            }
            if (VerifyUtil.isEmpty(protectionRelations)) {
                logger.info((Object)"replication protectionRelations is empty");
                return null;
            }
            return ((ProtectionRelation)CommonUtil.getFirstElement((Collection)protectionRelations)).getSrcResourceProviderSn();
        }
        if (pg.getTemplate().getType() == 18) {
            Set pgReplicas = pg.getReplicaList();
            if (VerifyUtil.isEmpty((Collection)pgReplicas)) {
                return null;
            }
            ProtectGroupReplica replica = (ProtectGroupReplica)pgReplicas.iterator().next();
            return replica.getProductArray();
        }
        return null;
    }

    private void initLunNodedata(TopoBaseContext context, Set<StorageResource> resourceList, Node root, boolean hasRoot) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List<StorageResource> sortedResourceList = new ArrayList<StorageResource>(resourceList);
        ProtectGroupReplica remoteReplica = protectGroup.getAnyoneReplicationReplica();
        if (this.hasReplication(protectGroup.getTemplate().getType()) && !VerifyUtil.isEmpty((Object)remoteReplica)) {
            sortedResourceList = this.sortStorageResource(remoteReplica.getProductArray(), resourceList);
            sortedResourceList = this.symmetrySort(sortedResourceList);
        }
        HashSet<String> siteList = new HashSet<String>();
        HashSet<String> wwnSet = new HashSet<String>();
        for (StorageResource each : sortedResourceList) {
            if (!(each instanceof Lun)) {
                return;
            }
            Lun eachLun = (Lun)each;
            String devSn = eachLun.getDevSn();
            DrStorage drStorage = (DrStorage)this.getDrResource(devSn);
            String siteId = drStorage.getSiteId();
            Site srcSite = context.getSiteService().getSiteById(siteId);
            Node srcStorageNode = !VerifyUtil.isEmpty((Object)remoteReplica) && devSn.equals(remoteReplica.getProductArray()) || protectGroup.getTemplate().getType() == 19 ? this.addStorageForRepAsyn(context, drStorage, srcSite, root) : this.addStorageNode(context, drStorage, srcSite, root);
            LunElement srcNode = new LunElement((Object)(siteId + eachLun.getWwn()), eachLun);
            context.addChild((IData)srcStorageNode, (IData)srcNode);
            siteList.add(siteId);
            wwnSet.add(eachLun.getWwn());
        }
        List<Integer> templateToAddLink = Arrays.asList(31, 18, 19, 26);
        if (templateToAddLink.contains(protectGroup.getTemplate().getType()) && !hasRoot) {
            logger.debug((Object)"Add LUN link info.");
            List pairs = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getHyperMetroPairByWwn(new ArrayList(wwnSet), Boolean.TRUE);
            this.addHyperMetroLinkInfo(context, siteList, wwnSet, pairs);
        }
    }

    private void buildParaInfo(TopoBaseContext context, Map<String, List<ProtectGroupReplica>> snToReplica, Map<String, Integer> locationMap) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List protectGroupReplicaSet = context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "TIME_STAMP", true);
        for (ProtectGroupReplica pgr : protectGroupReplicaSet) {
            if (!pgr.isSanSnapshotReplica()) continue;
            String devSn = pgr.getProductArray();
            if (snToReplica.containsKey(devSn)) {
                snToReplica.get(devSn).add(pgr);
            } else {
                ArrayList<ProtectGroupReplica> replicas = new ArrayList<ProtectGroupReplica>();
                replicas.add(pgr);
                snToReplica.put(devSn, replicas);
            }
            locationMap.put(devSn, pgr.getProtectLocation());
        }
    }

    private String getHyperPairID(Map<String, String> dataMap, String vstoreId, NasFileSystem nasfs) {
        String uuid = new XveUUID(nasfs.getDevSn(), XveMOType.FILESYSTEM, nasfs.getResourceId() + "_vstoreId=" + vstoreId).toString();
        return dataMap.get(uuid);
    }

    private Skin getLinkColorBaseLinkStatus(HyperMetroPair hyperMetroPair) {
        if (String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.UNKNOWN.getValue()).equals(hyperMetroPair.getHealthState())) {
            return new LinkSkin("0x1dcfef");
        }
        if (String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.FAULT.getValue()).equals(hyperMetroPair.getHealthState())) {
            return new LinkSkin("0xfc4133");
        }
        if (String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(hyperMetroPair.getHealthState()) && String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.PAUSE.getValue()).equals(hyperMetroPair.getRunningState())) {
            return new LinkSkin("0xfc9215");
        }
        return new LinkSkin();
    }

    private void addHyperMetroLinkInfo(TopoBaseContext context, Set<String> siteIdList, Set<String> pairList, List<HyperMetroPair> hmPairList) {
        if (siteIdList.size() != 2) {
            logger.error((Object)("the hyperMetra site size is: " + siteIdList.size()));
            return;
        }
        for (String pair : pairList) {
            Iterator<String> iterator = siteIdList.iterator();
            Node node1 = (Node)context.getDataByID((Object)(iterator.next() + pair));
            Node node2 = (Node)context.getDataByID((Object)(iterator.next() + pair));
            HyperMetroPair hyperMetroPair = this.getHyperMetro(hmPairList, pair);
            if (!VerifyUtil.isEmpty((Object)hyperMetroPair)) {
                Skin linkSkin = this.getLinkColorBaseLinkStatus(hyperMetroPair);
                context.linkTo(node1, node2, new Skin[]{linkSkin});
                continue;
            }
            context.linkTo(node1, node2, new Skin[0]);
        }
        String id = "hyperMetroStyle:" + context.getProtectGroup().getUuid() + ":unvisible";
        Node group = (Node)context.getElementBox().getElementByID((Object)id);
        if (null != group) {
            group.setClient("layout", (Object)"leftright");
        }
    }

    private HyperMetroPair getHyperMetro(List<HyperMetroPair> hmPairList, String pairId) {
        if (!VerifyUtil.isEmpty(hmPairList)) {
            for (HyperMetroPair pair : hmPairList) {
                if (!pairId.equals(pair.getResourceWwn())) continue;
                return pair;
            }
        }
        return null;
    }

    private void buildReplicationTopo(TopoBaseContext context, Node root) {
        ProtectGroup pg = context.getProtectGroup();
        if (!this.hasReplication(pg.getTemplate().getType())) {
            return;
        }
        StringBuilder lunIdList = new StringBuilder();
        Set pgReplicas = pg.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)pgReplicas)) {
            logger.error((Object)"pgReplicas is empty", 1073947393L);
            return;
        }
        Node arraySiteStyle = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)("trgHyperMetroStyle:" + pg.getUuid()));
        arraySiteStyle.setClient("sonsGap", 14.0);
        arraySiteStyle.setClient("layout", (Object)"leftright");
        Node trgRoot = (Node)context.addChild((IData)context.getRootNode(), (IData)arraySiteStyle);
        List<ReplicaRelation> relations = this.transform(pg, pg.getReplicaList());
        Set schedules = pg.getTemplate().getSchedules();
        lunIdList = this.buildReplicationTopo(context, relations, schedules, lunIdList, trgRoot, root);
        context.setLinkIdList(lunIdList.toString());
    }

    private StringBuilder buildReplicationTopo(TopoBaseContext context, List<ReplicaRelation> relations, Set<Schedule> schedules, StringBuilder lunIdList, Node trgRoot, Node root) {
        ProtectGroup pg = context.getProtectGroup();
        for (ReplicaRelation relation : relations) {
            DrStorage trgDrStorage;
            String srcSN = relation.getSourceSN();
            String trgSN = relation.getTargetSN();
            DrStorage drStorage = (DrStorage)this.getDrResource(srcSN);
            if (this.checkDrStorage(drStorage, trgDrStorage = (DrStorage)this.getDrResource(trgSN))) continue;
            String srcSiteId = drStorage.getSiteId();
            Site srcSite = context.getSiteService().getSiteById(srcSiteId);
            String trgSiteId = relation.getRecoverySite();
            Site trgSite = context.getSiteService().getSiteById(trgSiteId);
            Node srcStorageNode = null;
            Node trgStorageNode = null;
            if (31 == pg.getTemplate().getType()) {
                srcStorageNode = this.addStorageForRepAsyn(context, drStorage, srcSite, root);
                trgStorageNode = this.addStorageForRepAsyn(context, trgDrStorage, trgSite, trgRoot);
            } else {
                srcStorageNode = this.addStorageNode(context, drStorage, srcSite, root);
                trgStorageNode = this.addStorageNode(context, trgDrStorage, trgSite, trgRoot);
            }
            List<String> srResourceIdList = relation.getSourceLuns();
            List sources = this.getResourceListFromDB(srcSite, srcSN, srResourceIdList);
            List trgLuns = this.getResourceListFromDB(trgSite, trgSN, relation.getTargetLuns());
            List<ReplicationTargetLun> targets = this.getTrgLunListFromDB(srcSite, srcSN, trgSN, relation.getTargetLuns());
            String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(srcSN);
            Map<String, StorageResource> srcResourceIDMap = this.getResourceIDMap(sources);
            Map<String, StorageResource> trgResourceIDMap = this.getResourceIDMap(trgLuns);
            Map<String, ReplicationTargetLun> repLunIDMap = this.getReplicationLunIDMap(targets);
            Schedule schedule = TopoServiceUtil.getSchedule((int)relation.getProtectLocation(), schedules, (ProtectGroup)pg);
            String scheduleInfo = TooltipUtil.getScheduleInfo((Schedule)schedule);
            ArrayList<NasFileSystem> nasFileSystemList = new ArrayList<NasFileSystem>();
            HashMap<String, ReplicationRelation> coninstanceIdToGroup = new HashMap<String, ReplicationRelation>();
            for (String srcResourceId : srResourceIdList) {
                StorageResource source = null;
                int resType = relation.getStorageTypeBySource(srcResourceId);
                if (resType == DrmEnumDefine.ResourceTypeE.LUN.getValue()) {
                    source = srcResourceIDMap.get(DrmEnumDefine.ResourceTypeE.LUN.name() + srcResourceId);
                } else if (resType == DrmEnumDefine.ResourceTypeE.NAS.getValue()) {
                    source = srcResourceIDMap.get(DrmEnumDefine.ResourceTypeE.NAS.name() + srcResourceId);
                }
                if (this.checkSource(nasFileSystemList, source)) continue;
                Node srcLunNode = this.addProductLun(context, srcSiteId, srcStorageNode, (Lun)source);
                String trgLunID = relation.getTargetLunBySource(srcResourceId);
                Node trgLunNode = this.getNode(trgSN, trgResourceIDMap, (Lun)source, trgLunID);
                if (trgLunNode == null) continue;
                trgLunNode = (Node)context.addChild((IData)trgStorageNode, (IData)trgLunNode);
                ReplicationTargetLun repLunInfo = repLunIDMap.get(trgLunID);
                if (null == repLunInfo) continue;
                String linkId = this.getLinkId(lunIdList, srcSN, trgSN, srcResourceId, trgLunID);
                ReplicationRelation repliationRelation = this.getReplicationGroup(repLunInfo, relation, coninstanceIdToGroup, srcSite, trgLunID);
                context.linkTos(srcLunNode, trgLunNode, linkId, new Skin[]{new ReplicationLinkSkin(repliationRelation, deviceType, repLunInfo, scheduleInfo)});
            }
            for (NasFileSystem srcFileSystem : nasFileSystemList) {
                String srcFileSystemId = srcFileSystem.getResourceId();
                String nodeKey = srcFileSystem.getDevSn() + ":" + srcFileSystem.getResourceId();
                String nodeId = (String)context.find((Object)nodeKey);
                NasFileSystemElement srcNasNode = new NasFileSystemElement((Object)nodeId, srcFileSystem);
                srcNasNode = (Node)context.addChild((IData)srcStorageNode, (IData)srcNasNode);
                String trgNasID = relation.getTargetLunBySource(srcFileSystemId);
                if (trgNasID == null) continue;
                NasFileSystem trgLun = (NasFileSystem)trgResourceIDMap.get(DrmEnumDefine.ResourceTypeE.NAS.name() + trgNasID);
                NasFileSystemElement trgNasNode = trgLun != null ? new NasFileSystemElement((Object)(trgSN + trgNasID), trgLun) : new NasFileSystemElement((Object)(trgSN + trgNasID), srcFileSystem, trgNasID);
                trgNasNode = (Node)context.addChild((IData)trgStorageNode, (IData)trgNasNode);
                ReplicationTargetLun repLunInfo = repLunIDMap.get(trgNasID);
                String linkId = srcSN + ":" + srcFileSystemId + ":" + trgSN + ":" + trgNasID;
                this.addLinkIdInfo(lunIdList, repLunInfo, linkId);
                context.linkTos((Node)srcNasNode, (Node)trgNasNode, linkId, new Skin[]{new ReplicationLinkSkin(deviceType, repLunInfo, scheduleInfo)});
            }
        }
        return lunIdList;
    }

    private Node getNode(String trgSN, Map<String, StorageResource> trgResourceIDMap, Lun srcLun, String trgLunID) {
        if (trgLunID == null) {
            return null;
        }
        Lun trgLun = (Lun)trgResourceIDMap.get(DrmEnumDefine.ResourceTypeE.LUN.name() + trgLunID);
        LunElement trgLunNode = trgLun != null ? new LunElement((Object)(trgSN + trgLunID), trgLun) : new LunElement((Object)(trgSN + trgLunID), srcLun, trgLunID);
        return trgLunNode;
    }

    private String getLinkId(StringBuilder lunIdList, String srcSN, String trgSN, String srcResourceId, String trgLunID) {
        String linkId = srcSN + ":" + srcResourceId + ":" + trgSN + ":" + trgLunID;
        lunIdList.append(linkId);
        lunIdList.append(";");
        return linkId;
    }

    protected Node addProductLun(TopoBaseContext context, String siteId, Node storageNode, Lun lun) {
        LunElement srcLunNode = new LunElement((Object)(siteId + lun.getWwn()), lun);
        srcLunNode = (Node)context.addChild((IData)storageNode, (IData)srcLunNode);
        return srcLunNode;
    }

    protected boolean hasReplication(int templateType) {
        return Arrays.asList(18, 23, 31).contains(templateType);
    }

    private boolean checkDrStorage(DrStorage drStorage, DrStorage trgDrStorage) {
        return drStorage == null || trgDrStorage == null;
    }

    protected void setSnapNodeOffset(TopoBaseContext context, Node node, List<ProtectGroupReplica> protectGroupReplicaList) {
        if (VerifyUtil.isEmpty((Object)node) || VerifyUtil.isEmpty(protectGroupReplicaList)) {
            return;
        }
        List poStorageWwns = this.getPoStorageWwns(context.getProtectGroup());
        node.setClient("isHyperMetroSnap", true);
        if (poStorageWwns.size() == 1 && protectGroupReplicaList.size() == 1) {
            node.setClient("hyperMetroSnapOffset", 10);
        } else if (poStorageWwns.size() + 1 >= protectGroupReplicaList.size() && protectGroupReplicaList.size() >= 3) {
            node.setClient("hyperMetroSnapOffset", 11);
        } else if (protectGroupReplicaList.size() < 3) {
            node.setClient("hyperMetroSnapOffset", 11);
        } else {
            node.setClient("hyperMetroSnapOffset", 1);
        }
    }

    private void checkParam(TopoBaseContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Node createUnVisibleStyleNode(TopoBaseContext context, String styleNodeId) {
        String nodeID = styleNodeId + ":unvisible";
        Node group = (Node)context.getElementBox().getElementByID((Object)nodeID);
        if (group == null) {
            group = this.createGroupStyleNode(nodeID);
            group.setStyle("vector.fill.color", (Object)"0xFAFAFA");
            group.setClient("leftGap", 11.0);
            group.setClient("topGap", 11.0);
            group.setClient("sonsGap", 7.0);
            group.setStyle("vector.outline.width", 1.0);
            group.setStyle("vector.outline.color", (Object)"0xFAFAFA");
            group.setStyle("vector.outline.alpha", 0.0);
            group.setStyle("vector.fill", false);
            group.setStyle("content.type", (Object)"vector");
        }
        group.setStyle("icons.position", (Object)"right.right");
        group.setClient("iconHeight", 48.0);
        group.setClient("iconWidth", 48.0);
        group.setClient("ISSNAPPO", (Object)"FALSE");
        return group;
    }

    private Node createGroupStyleNode(String id) {
        Node group = new Node((Object)id);
        group.setStyle("vector.roundrect.radius", 7);
        group.setClient("layout", (Object)"leftright");
        group.setClient("TopoModel", (Object)"StyleGroup");
        group.setStyle("content.type", (Object)"vector");
        group.setStyle("vector.shape", (Object)"roundrect");
        return group;
    }

    protected void setLinkOffset(Link link) {
        link.setStyle("link.from.xoffset", -10.0);
        link.setStyle("link.from.yoffset", 1.0);
        link.setStyle("link.from.at.edge", true);
        link.setClient("linkType", (Object)"hyperSnapLink");
    }

    private void getReplicaInfo(TopoBaseContext context, Map<String, List<ProtectGroupReplica>> replicaMap, Map<String, Integer> locationMap) {
        if (!this.isLocalReplica(context)) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        List protectGroupReplicaSet = context.getReplicaService().queryProtectGroupReplicaByGroup(pg.getUuid(), "TIME_STAMP", true);
        for (ProtectGroupReplica pgReplica : protectGroupReplicaSet) {
            List<ProtectGroupReplica> pgReplicaList;
            if (!ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)pgReplica)) continue;
            String devSn = pgReplica.getProductArray();
            if (!pgReplica.isLocalStorageSnapshotReplica()) {
                devSn = pgReplica.getRecoveryArray();
            }
            if (VerifyUtil.isEmpty(pgReplicaList = replicaMap.get(devSn))) {
                pgReplicaList = new ArrayList<ProtectGroupReplica>();
            }
            pgReplicaList.add(pgReplica);
            replicaMap.put(devSn, pgReplicaList);
            locationMap.put(devSn, pgReplica.getProtectLocation());
        }
    }

    private boolean isLocalReplica(TopoBaseContext context) {
        ProtectGroup pg = context.getProtectGroup();
        List<Integer> types = Arrays.asList(19, 28, 31);
        return types.contains(pg.getTemplate().getType());
    }

    protected Node addStorageNode(TopoBaseContext context, DrStorage drStorage, Site siteInfo, Node root) {
        String siteStyleNodeId = siteInfo.getSiteId() + "---" + "Style:unvisible";
        Node siteStyleNode = (Node)context.getElementBox().getDataByID((Object)siteStyleNodeId);
        if (siteStyleNode == null) {
            siteStyleNode = this.createUnVisibleStyleNode(context, siteInfo.getSiteId() + "---" + "Style");
            context.addChild((IData)root, (IData)siteStyleNode);
        }
        String storageStyleNodeId = drStorage.getDeviceSn() + "---" + "Style:unvisible";
        Node storageStyleNode = (Node)context.getElementBox().getDataByID((Object)storageStyleNodeId);
        if (storageStyleNode == null) {
            storageStyleNode = this.createUnVisibleStyleNode(context, drStorage.getDeviceSn() + "---" + "Style");
            context.addChild((IData)siteStyleNode, (IData)storageStyleNode);
        }
        String snid = drStorage.getDeviceSn() + ":storage";
        Node storage = (Node)context.getElementBox().getDataByID((Object)snid);
        if (null == storage) {
            storage = (Node)context.addChild((IData)storageStyleNode, (IData)new StorageElement(drStorage));
        }
        return storage;
    }

    protected Node addStorageForRepAsyn(TopoBaseContext context, DrStorage drStorage, Site siteInfo, Node root) {
        String siteStyleNodeId = siteInfo.getSiteId() + "---" + "Style:unvisible";
        Node siteStyleNode = (Node)context.getElementBox().getDataByID((Object)siteStyleNodeId);
        if (siteStyleNode == null) {
            siteStyleNode = this.createUnVisibleStyleNode(context, siteInfo.getSiteId() + "---" + "Style");
            context.addChild((IData)root, (IData)siteStyleNode);
        }
        String snid = drStorage.getDeviceSn() + ":storage";
        Node storage = (Node)context.getElementBox().getDataByID((Object)snid);
        if (null == storage) {
            storage = (Node)context.addChild(siteStyleNodeId, (IData)new StorageElement(context, drStorage));
        }
        return storage;
    }

    private void addLinkIdInfo(StringBuilder lunIdList, ReplicationTargetLun repLunInfo, String linkId) {
        if (null != repLunInfo) {
            int modeNasRep = TopoServiceUtil.getArrayReplicationMode((ReplicationTargetLun)repLunInfo);
            if (modeNasRep == 2) {
                lunIdList.append(linkId);
                lunIdList.append(";");
            }
        } else {
            logger.error((Object)("The repLunInfo is null: " + linkId));
        }
    }

    private List<StorageResource> symmetrySort(List<StorageResource> sortedResourceList) {
        ArrayList<StorageResource> arrayList = new ArrayList<StorageResource>(sortedResourceList.size());
        List<StorageResource> arraySrcDevsnList = sortedResourceList.subList(0, sortedResourceList.size() / 2);
        List<StorageResource> arrayTargetDevsnList = sortedResourceList.subList(sortedResourceList.size() / 2, sortedResourceList.size());
        this.sortResourceByWwn(arraySrcDevsnList);
        this.sortResourceByWwn(arrayTargetDevsnList);
        arrayList.addAll(arraySrcDevsnList);
        arrayList.addAll(arrayTargetDevsnList);
        return arrayList;
    }

    private void sortResourceByWwn(List<StorageResource> sortedResourceList) {
        Collections.sort(sortedResourceList, (o1, o2) -> ((Lun)o1).getWwn().compareToIgnoreCase(((Lun)o2).getWwn()));
    }
}

