/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.builder.AbstractTopoBuilder;
import com.huawei.ism.drm.topo.element.LunElement;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.model.pg.ProtectGroupNode;
import com.huawei.ism.drm.topo.model.site.SiteNode;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.IData;
import com.huawei.twaver.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-2##PolicyTemplate-14")
public class SnapTopoBuilder
extends AbstractTopoBuilder {
    private static final double SNAP_INNER_SONS_GAP = 150.0;
    private static final double GROUP_LOCAL_X_OFFSET = 70.0;
    private static final double STORAGE_Y_SONS_GAP = 14.0;

    public void buildTopo(TopoBaseContext context) {
        ProtectGroup protectGroup;
        if (context.getRootNode() == null) {
            this.initialize(context);
        }
        if ((protectGroup = context.getProtectGroup()).getTemplate().getType() == 14) {
            this.initNasNodedata(context, protectGroup);
        } else if (protectGroup.getTemplate().getType() == 2) {
            Node arraySiteStyle = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)("hyperMetroStyle:" + protectGroup.getUuid()));
            arraySiteStyle.setClient("sonsGap", 14.0);
            Node root = (Node)context.addChild((IData)context.getRootNode(), (IData)arraySiteStyle);
            this.initLunNodedata(context, root);
        }
    }

    private void initLunNodedata(TopoBaseContext context, Node root) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List poStorageList = protectGroup.distinctStorageInfo();
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)poStorageList);
        if (null == posi) {
            throw new LegoCheckedException(2117645L);
        }
        String usedDevSn = posi.getResourceProviderSN();
        List poStorageResourceId = poStorageList.stream().map(e -> e.getResourceId()).collect(Collectors.toList());
        List resourceList = context.getStorageService().getStorageResources(usedDevSn, poStorageResourceId, DrmEnumDefine.ResourceTypeE.LUN);
        for (StorageResource storageResource : resourceList) {
            if (!(storageResource instanceof Lun)) continue;
            Lun lun = (Lun)storageResource;
            String siteId = protectGroup.getProductSiteId();
            Site siteNode = context.getSiteService().getSiteById(siteId);
            String devSn = lun.getDevSn();
            DrStorage drStorage = (DrStorage)this.getDrResource(devSn);
            Node srcStorageNode = this.addStorageArraySnapShot(context, drStorage, siteNode, root);
            LunElement srcNode = new LunElement((Object)(siteId + lun.getWwn()), lun);
            context.addChild((IData)srcStorageNode, (IData)srcNode);
        }
    }

    private void initNasNodedata(TopoBaseContext context, ProtectGroup protectGroup) {
        Node protectGroupNode;
        Node siteNode = this.addSiteNode(context, protectGroup);
        Node protectGroupStyleNode = this.addProtectGroupStyleNode(context, protectGroup, siteNode);
        ArrayList protectGroupReplicaList = new ArrayList();
        List protectGroupReplicaSet = context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "TIME_STAMP", true);
        protectGroupReplicaList.addAll(protectGroupReplicaSet);
        String scheduleInfo = null;
        if (!VerifyUtil.isEmpty(protectGroupReplicaList)) {
            scheduleInfo = this.getScheduleTooltips(context, protectGroup, ((ProtectGroupReplica)protectGroupReplicaList.get(0)).getProtectLocation());
        }
        if (!VerifyUtil.isEmpty((Object)(protectGroupNode = this.addProtectGroupNode(context, protectGroup, protectGroupStyleNode)))) {
            protectGroupNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/ic_asynchronous.png");
            protectGroupNode.setStyle("icons.position", (Object)"right.right");
            protectGroupNode.setStyle("icons.xoffset", 70.0 - (double)(2 * protectGroupNode.getName().length()));
            protectGroupStyleNode.setToolTip(protectGroupNode.getToolTip());
            protectGroupNode.setToolTip(scheduleInfo);
        }
        this.buildSnapReplicaTopo(context, siteNode, scheduleInfo, protectGroupNode, protectGroupReplicaList);
    }

    protected Node addStorageArraySnapShot(TopoBaseContext context, DrStorage drStorage, Site siteInfo, Node root) {
        String siteStyleNodeId = siteInfo.getSiteId() + "---" + "Style:unvisible";
        Node siteStyleNode = (Node)context.getElementBox().getDataByID((Object)siteStyleNodeId);
        if (siteStyleNode == null) {
            siteStyleNode = TopoServiceUtil.createUnVisibleStorageNode((TopoBaseContext)context, (String)(siteInfo.getSiteId() + "---" + "Style"));
            context.addChild((IData)root, (IData)siteStyleNode);
        }
        String snid = drStorage.getDeviceSn() + ":storage";
        Node storage = (Node)context.getElementBox().getDataByID((Object)snid);
        if (null == storage) {
            storage = (Node)context.addChild(siteStyleNodeId, (IData)new StorageElement(context, drStorage));
        }
        return storage;
    }

    protected Node addProtectGroupNode(TopoBaseContext context, ProtectGroup protectGroup, Node protectGroupStyleNode) {
        String protectGroupID = protectGroup.getUuid() + "-ProtectGroup";
        ElementBox box = context.getElementBox();
        Node protectGroupNode = (Node)box.getElementByID((Object)protectGroupID);
        if (protectGroupNode == null) {
            protectGroupNode = (Node)new ProtectGroupNode(protectGroup, this.getTopoResourceManager()).getLocalView();
            if (protectGroup.getReplicaCount() <= 1) {
                protectGroupNode.setClient("ISSNAPPO", (Object)"FALSE");
            }
            protectGroupStyleNode.setToolTip(protectGroupNode.getToolTip());
            context.addChild((IData)protectGroupStyleNode, (IData)protectGroupNode);
        }
        return protectGroupNode;
    }

    protected Node addProtectGroupStyleNode(TopoBaseContext context, ProtectGroup protectGroup, Node siteNode) {
        String protectGroupStyleNodeId = protectGroup.getUuid() + "-" + protectGroup.getPoType();
        Node pgStyleNode = TopoServiceUtil.findNodeByIdInBox((ElementBox)context.getElementBox(), (String)protectGroupStyleNodeId);
        if (pgStyleNode == null) {
            pgStyleNode = this.createPoInstanceStyleNode(protectGroupStyleNodeId);
            context.addChild((IData)siteNode, (IData)pgStyleNode);
        }
        return pgStyleNode;
    }

    protected Node addSiteNode(TopoBaseContext context, ProtectGroup protectGroup) {
        String siteId = protectGroup.getProductSiteId();
        Site site = context.getSiteService().getSiteById(siteId);
        Node siteNode = new SiteNode(site, this.getTopoResourceManager()).getSnapView();
        context.addChild((IData)context.getRootNode(), (IData)siteNode);
        siteNode.setClient("sonsGap", 150.0);
        return siteNode;
    }

    public String getTopoType() {
        return "PolicyTemplate-11";
    }
}

